/*
 * Decompiled with CFR 0.152.
 */
package com.captcha.botdetect.web.servlet;

import com.captcha.botdetect.SoundRegenerationMode;
import com.captcha.botdetect.internal.infrastructure.resources.ResourceHelper;
import com.captcha.botdetect.internal.infrastructure.text.StringHelper;
import com.captcha.botdetect.web.CaptchaHttpCommand;
import com.captcha.botdetect.web.servlet.Captcha;
import com.captcha.botdetect.web.servlet.HttpHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CaptchaServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(CaptchaServlet.class.getName());
    public static final Pattern BYTE_RANGE_PATTERN = Pattern.compile("bytes=([0-9]+)-([0-9]+)");
    public static final String WHOLE_BYTE_RANGE_PATTERN = "bytes=0-$";

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("get");
        CaptchaHttpCommand captchaHttpCommand = CaptchaHttpCommand.getCaptchaCommand((String)string);
        switch (captchaHttpCommand) {
            case GET_IMAGE: {
                CaptchaServlet.getImage(httpServletRequest, httpServletResponse);
                break;
            }
            case GET_SOUND: {
                CaptchaServlet.getSound(httpServletRequest, httpServletResponse);
                break;
            }
            case GET_VALIDATION_RESULT: {
                CaptchaServlet.getValidationResult(httpServletRequest, httpServletResponse);
                break;
            }
            case GET_SOUND_ICON: {
                CaptchaServlet.getSoundIcon(httpServletResponse);
                break;
            }
            case GET_SMALL_SOUND_ICON: {
                CaptchaServlet.getSmallSoundIcon(httpServletResponse);
                break;
            }
            case GET_DISABLED_SOUND_ICON: {
                CaptchaServlet.getDisabledSoundIcon(httpServletResponse);
                break;
            }
            case GET_SMALL_DISABLED_SOUND_ICON: {
                CaptchaServlet.getSmallDisabledSoundIcon(httpServletResponse);
                break;
            }
            case GET_RELOAD_ICON: {
                CaptchaServlet.getReloadIcon(httpServletResponse);
                break;
            }
            case GET_SMALL_RELOAD_ICON: {
                CaptchaServlet.getSmallReloadIcon(httpServletResponse);
                break;
            }
            case GET_DISABLED_RELOAD_ICON: {
                CaptchaServlet.getDisabledReloadIcon(httpServletResponse);
                break;
            }
            case GET_SMALL_DISABLED_RELOAD_ICON: {
                CaptchaServlet.getSmallDisabledReloadIcon(httpServletResponse);
                break;
            }
            case GET_SCRIPT_INCLUDE: {
                CaptchaServlet.getScriptInclude(httpServletResponse);
                break;
            }
            case GET_LAYOUT_STYLE_SHEET: {
                CaptchaServlet.getLayoutStyleSheet(httpServletResponse);
                break;
            }
            default: {
                CaptchaServlet.unknownCommand(httpServletResponse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getImage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ServletOutputStream servletOutputStream = null;
        Captcha captcha = CaptchaServlet.getCaptchaInstance(httpServletRequest);
        if (captcha == null) {
            HttpHelper.badRequest(httpServletResponse, "Captcha doesn't exist");
            return;
        }
        String string = CaptchaServlet.getInstanceId(httpServletRequest);
        if (string == null) {
            HttpHelper.badRequest(httpServletResponse, "Instance doesn't exist");
            return;
        }
        CaptchaServlet.clearSoundData(httpServletRequest, string);
        String string2 = captcha.getImageFormat().name().toLowerCase();
        httpServletResponse.setContentType("image/" + string2);
        HttpHelper.smartDisallowCache(httpServletRequest, httpServletResponse);
        ByteArrayOutputStream byteArrayOutputStream = captcha.getCaptchaBase().getImage(string);
        captcha.saveCaptchaCodes(captcha);
        try {
            servletOutputStream = httpServletResponse.getOutputStream();
            byteArrayOutputStream.writeTo((OutputStream)servletOutputStream);
        }
        catch (IOException iOException) {
            log.logp(Level.SEVERE, CaptchaServlet.class.getName(), "getImage", iOException.toString());
        }
        finally {
            try {
                if (servletOutputStream != null) {
                    servletOutputStream.close();
                }
            }
            catch (IOException iOException) {
                log.logp(Level.INFO, CaptchaServlet.class.getName(), "getImage.out.close", iOException.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getSound(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Object object;
        boolean bl;
        ServletOutputStream servletOutputStream = null;
        Captcha captcha = CaptchaServlet.getCaptchaInstance(httpServletRequest);
        if (captcha == null) {
            HttpHelper.badRequest(httpServletResponse, "Captcha doesn't exist");
            return;
        }
        if (!captcha.isSoundEnabled()) {
            HttpHelper.badRequest(httpServletResponse, "Sound disabled");
            return;
        }
        String string = CaptchaServlet.getInstanceId(httpServletRequest);
        if (string == null) {
            HttpHelper.badRequest(httpServletResponse, "Instance doesn't exist");
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = CaptchaServlet.getSoundData(httpServletRequest, captcha, string);
        if (byteArrayOutputStream == null) {
            HttpHelper.badRequest(httpServletResponse, "Please reload the form page before requesting new Captcha sound");
            return;
        }
        int n = byteArrayOutputStream.size();
        HttpHelper.smartDisallowCache(httpServletRequest, httpServletResponse);
        httpServletResponse.setContentType("audio/x-wav");
        httpServletResponse.addHeader("Content-Transfer-Encoding", "binary");
        boolean bl2 = bl = httpServletRequest.getParameter("d") != null;
        if (!bl) {
            object = UUID.randomUUID().toString().replaceAll("-", "");
            String string2 = String.format("captcha_%s.wav", object);
            httpServletResponse.addHeader("Content-Disposition", "attachment; filename=" + string2);
        }
        try {
            servletOutputStream = httpServletResponse.getOutputStream();
            if (CaptchaServlet.detectIosRangeRequest(httpServletRequest)) {
                object = CaptchaServlet.getSoundByteRange(httpServletRequest);
                Object object2 = object[0];
                Object object3 = object[1];
                reference var11_15 = object3 - object2 + true;
                httpServletResponse.setStatus(206);
                httpServletResponse.addHeader("Accept-Ranges", "bytes");
                httpServletResponse.addHeader("Content-Length", String.valueOf((int)var11_15));
                httpServletResponse.addHeader("Content-Range", String.format("bytes %d-%d/%d", (int)object2, (int)object3, n));
                byte[] byArray = new byte[var11_15];
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                System.arraycopy(byArray2, (int)object2, byArray, 0, (int)var11_15);
                servletOutputStream.write(byArray, 0, (int)var11_15);
            } else if (CaptchaServlet.detectFakeRangeRequest(httpServletRequest)) {
                httpServletResponse.setStatus(206);
                httpServletResponse.addHeader("Accept-Ranges", "bytes");
                httpServletResponse.addHeader("Content-Length", String.valueOf(n));
                httpServletResponse.addHeader("Content-Range", String.format("bytes %d-%d/%d", 0, n - 1, n));
                object = byteArrayOutputStream.toByteArray();
                servletOutputStream.write((byte[])object);
                servletOutputStream.flush();
            } else {
                httpServletResponse.addHeader("Accept-Ranges", "none");
                byteArrayOutputStream.writeTo((OutputStream)servletOutputStream);
            }
        }
        catch (IOException iOException) {
            System.err.println("CaptchaServlet.getSound:" + iOException);
            log.log(Level.SEVERE, iOException.getMessage());
        }
        finally {
            try {
                if (servletOutputStream != null) {
                    servletOutputStream.close();
                }
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, iOException.getMessage());
            }
        }
    }

    protected static ByteArrayOutputStream getSoundData(HttpServletRequest httpServletRequest, Captcha captcha, String string) {
        ByteArrayOutputStream byteArrayOutputStream;
        boolean bl;
        boolean bl2 = bl = captcha.getSoundRegenerationMode() == SoundRegenerationMode.NONE || CaptchaServlet.detectIosRangeRequest(httpServletRequest);
        if (bl) {
            byteArrayOutputStream = CaptchaServlet.loadSoundData(httpServletRequest, string);
            if (byteArrayOutputStream != null) {
                return byteArrayOutputStream;
            }
        } else {
            CaptchaServlet.clearSoundData(httpServletRequest, string);
        }
        byteArrayOutputStream = CaptchaServlet.generateSoundData(captcha, string);
        if (bl) {
            CaptchaServlet.saveSoundData(httpServletRequest, string, byteArrayOutputStream);
        }
        return byteArrayOutputStream;
    }

    static ByteArrayOutputStream generateSoundData(Captcha captcha, String string) {
        ByteArrayOutputStream byteArrayOutputStream = captcha.getCaptchaBase().getSound(string);
        captcha.saveCaptchaCodes(captcha);
        return byteArrayOutputStream;
    }

    protected static void saveSoundData(HttpServletRequest httpServletRequest, String string, ByteArrayOutputStream byteArrayOutputStream) {
        HttpSession httpSession = httpServletRequest.getSession(true);
        if (httpSession != null) {
            SoundDataHelper soundDataHelper = new CaptchaServlet().new SoundDataHelper();
            soundDataHelper.setSoundBytes(byteArrayOutputStream);
            httpSession.setAttribute("BDC_Cached_SoundData_" + string, (Object)soundDataHelper);
        }
    }

    protected static ByteArrayOutputStream loadSoundData(HttpServletRequest httpServletRequest, String string) {
        HttpSession httpSession = httpServletRequest.getSession(true);
        if (httpSession == null) {
            return null;
        }
        SoundDataHelper soundDataHelper = (SoundDataHelper)httpSession.getAttribute("BDC_Cached_SoundData_" + string);
        if (soundDataHelper == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = soundDataHelper.getSoundBytes();
        return byteArrayOutputStream;
    }

    protected static void clearSoundData(HttpServletRequest httpServletRequest, String string) {
        HttpSession httpSession = httpServletRequest.getSession(true);
        if (httpSession != null) {
            httpSession.removeAttribute("BDC_Cached_SoundData_" + string);
        }
    }

    static boolean detectIosRangeRequest(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        if (httpServletRequest != null) {
            String string = httpServletRequest.getHeader("X-Playback-Session-Id");
            String string2 = httpServletRequest.getHeader("Range");
            if (StringHelper.hasValue((String)string) && StringHelper.hasValue((String)string2)) {
                bl = true;
            }
        }
        return bl;
    }

    static int[] getSoundByteRange(HttpServletRequest httpServletRequest) {
        Matcher matcher;
        int[] nArray = new int[2];
        String string = httpServletRequest.getHeader("Range");
        if (StringHelper.hasValue((String)string) && (matcher = BYTE_RANGE_PATTERN.matcher(string)).find()) {
            nArray[0] = Integer.valueOf(matcher.group(1));
            nArray[1] = Integer.valueOf(matcher.group(2));
        }
        return nArray;
    }

    static boolean detectFakeRangeRequest(HttpServletRequest httpServletRequest) {
        String string;
        boolean bl = false;
        if (httpServletRequest != null && StringHelper.hasValue((String)(string = httpServletRequest.getHeader("Range"))) && Pattern.matches(WHOLE_BYTE_RANGE_PATTERN, string)) {
            bl = true;
        }
        return bl;
    }

    static void getValidationResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Captcha captcha = CaptchaServlet.getCaptchaInstance(httpServletRequest);
        if (captcha == null) {
            HttpHelper.badRequest(httpServletResponse, "getCaptchaInstance");
            return;
        }
        String string = CaptchaServlet.getInstanceId(httpServletRequest);
        if (string == null) {
            HttpHelper.badRequest(httpServletResponse, "getInstanceId");
            return;
        }
        String string2 = CaptchaServlet.getUserInput(httpServletRequest);
        httpServletResponse.setContentType("application/json");
        HttpHelper.smartDisallowCache(httpServletRequest, httpServletResponse);
        boolean bl = captcha.ajaxValidate(string2, string);
        captcha.saveCaptchaCodes(captcha);
        try {
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.write(CaptchaServlet.getJsonValidationResult(bl));
            printWriter.close();
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, iOException.toString());
        }
    }

    static void getSoundIcon(HttpServletResponse httpServletResponse) {
        CaptchaServlet.getWebResource(httpServletResponse, ResourceHelper.icons + "bdc-sound-icon.gif", "image/gif");
    }

    static void getSmallSoundIcon(HttpServletResponse httpServletResponse) {
        CaptchaServlet.getWebResource(httpServletResponse, ResourceHelper.icons + "bdc-sound-small-icon.gif", "image/gif");
    }

    static void getDisabledSoundIcon(HttpServletResponse httpServletResponse) {
        CaptchaServlet.getWebResource(httpServletResponse, ResourceHelper.icons + "bdc-sound-disabled-icon.gif", "image/gif");
    }

    static void getSmallDisabledSoundIcon(HttpServletResponse httpServletResponse) {
        CaptchaServlet.getWebResource(httpServletResponse, ResourceHelper.icons + "bdc-sound-small-disabled-icon.gif", "image/gif");
    }

    static void getReloadIcon(HttpServletResponse httpServletResponse) {
        CaptchaServlet.getWebResource(httpServletResponse, ResourceHelper.icons + "bdc-reload-icon.gif", "image/gif");
    }

    static void getSmallReloadIcon(HttpServletResponse httpServletResponse) {
        CaptchaServlet.getWebResource(httpServletResponse, ResourceHelper.icons + "bdc-reload-small-icon.gif", "image/gif");
    }

    static void getDisabledReloadIcon(HttpServletResponse httpServletResponse) {
        CaptchaServlet.getWebResource(httpServletResponse, ResourceHelper.icons + "bdc-reload-disabled-icon.gif", "image/gif");
    }

    static void getSmallDisabledReloadIcon(HttpServletResponse httpServletResponse) {
        CaptchaServlet.getWebResource(httpServletResponse, ResourceHelper.icons + "bdc-reload-small-disabled-icon.gif", "image/gif");
    }

    static void getLayoutStyleSheet(HttpServletResponse httpServletResponse) {
        CaptchaServlet.getWebResource(httpServletResponse, ResourceHelper.styles + "bdc-layout-stylesheet.css", "text/css");
    }

    static void getScriptInclude(HttpServletResponse httpServletResponse) {
        CaptchaServlet.getWebResource(httpServletResponse, ResourceHelper.clientside + "bdc-script-include.js", "text/javascript");
    }

    static void unknownCommand(HttpServletResponse httpServletResponse) {
        try {
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.write("unknown command");
            printWriter.close();
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, iOException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getWebResource(HttpServletResponse httpServletResponse, String string, String string2) {
        ServletOutputStream servletOutputStream = null;
        try {
            servletOutputStream = httpServletResponse.getOutputStream();
            httpServletResponse.setContentType(string2);
            servletOutputStream.write(ResourceHelper.getResource((String)string));
        }
        catch (IOException iOException) {
            log.logp(Level.SEVERE, CaptchaServlet.class.getName(), "getWebResource", iOException.toString());
        }
        finally {
            if (servletOutputStream != null) {
                try {
                    servletOutputStream.close();
                }
                catch (Exception exception) {
                    log.logp(Level.INFO, CaptchaServlet.class.getName(), "getWebResource.out.close", exception.toString());
                }
            }
        }
    }

    static Captcha getCaptchaInstance(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("c");
        if (!StringHelper.hasValue((String)string)) {
            return null;
        }
        Object object = httpServletRequest.getAttribute(string);
        if (object != null) {
            return (Captcha)object;
        }
        return Captcha.load((ServletRequest)httpServletRequest, string);
    }

    static String getInstanceId(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("t");
        if (!StringHelper.hasValue((String)string)) {
            return null;
        }
        if (string.length() != 32) {
            return null;
        }
        if (!string.matches("^(\\w+)$")) {
            return null;
        }
        return string;
    }

    static String getUserInput(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("i");
        if (StringHelper.hasValue((String)string)) {
            return string;
        }
        Map map = httpServletRequest.getParameterMap();
        for (String string2 : map.keySet()) {
            if (string2.equals("get") || string2.equals("c") || string2.equals("t") || string2.equals("d") || !StringHelper.hasValue((String)(string = httpServletRequest.getParameter(string2)))) continue;
            return string;
        }
        return null;
    }

    static String getJsonValidationResult(boolean bl) {
        return String.valueOf(bl);
    }

    public String getServletInfo() {
        return "Captcha request handling servlet.";
    }

    class SoundDataHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient ByteArrayOutputStream soundBytes;

        public ByteArrayOutputStream getSoundBytes() {
            return this.soundBytes;
        }

        public void setSoundBytes(ByteArrayOutputStream byteArrayOutputStream) {
            this.soundBytes = byteArrayOutputStream;
        }
    }
}

