/*
 * Decompiled with CFR 0.152.
 */
package com.captcha.botdetect.web.servlet;

import com.captcha.botdetect.CodeStyle;
import com.captcha.botdetect.HelpLinkMode;
import com.captcha.botdetect.ImageFormat;
import com.captcha.botdetect.ImageSize;
import com.captcha.botdetect.ImageStyle;
import com.captcha.botdetect.JavaScriptHelper;
import com.captcha.botdetect.PascalString;
import com.captcha.botdetect.SoundFormat;
import com.captcha.botdetect.SoundRegenerationMode;
import com.captcha.botdetect.SoundStyle;
import com.captcha.botdetect.UrlHelper;
import com.captcha.botdetect.configuration.ICaptchaConfiguration;
import com.captcha.botdetect.internal.core.CaptchaBase;
import com.captcha.botdetect.internal.core.captchacode.validation.ValidationAttemptOrigin;
import com.captcha.botdetect.internal.infrastructure.text.StringHelper;
import com.captcha.botdetect.internal.infrastructure.util.Base64;
import com.captcha.botdetect.internal.support.helplink.HelpLinkHelper;
import com.captcha.botdetect.internal.support.i18n.Localization;
import com.captcha.botdetect.web.CaptchaUrls;
import com.captcha.botdetect.web.HtmlHelper;
import com.captcha.botdetect.web.ICaptchaUrlGenerator;
import com.captcha.botdetect.web.servlet.HttpHelper;
import com.captcha.botdetect.web.servlet.persistence.CaptchaPersistence;
import com.captcha.botdetect.web.servlet.persistence.PersistenceHelper;
import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Captcha {
    private CaptchaBase captchaBase;
    private ICaptchaConfiguration captchaConfiguration;
    private CaptchaPersistence captchaPersistence;
    private String userInputID;
    private String imageTooltip;
    private String soundTooltip;
    private String reloadTooltip;
    private String helpLinkText;
    private String helpLinkUrl;
    private boolean reloadEnabled;
    private Boolean useSmallIcons;
    private Boolean useHorizontalIcons;
    private String soundIconUrl;
    private String reloadIconUrl;
    private Integer iconsDivWidth;
    private String additionalCssClasses;
    private String additionalInlineCss;
    private boolean addCssInclude;
    private boolean addScriptInclude;
    private boolean addInitScript;
    private boolean autoFocusInput;
    private boolean autoClearInput;
    private boolean autoUppercaseInput;
    private boolean autoReloadExpiredCaptchas;
    private int autoReloadTimeout;
    private int soundStartDelay;
    private boolean remoteScriptEnabled;
    static final int TAB_INDEX_NOT_SET = -255;
    private int tabIndex;
    protected boolean isCodeLengthModified = false;
    protected boolean isCodeStyleModified = false;
    protected boolean isCodeTimeoutModified = false;
    protected boolean isCustomDarkColorModified = false;
    protected boolean isCustomLightColorModified = false;
    protected boolean isDisallowedCodeSubstringsModified = false;
    protected boolean isHelpLinkEnabledModified = false;
    protected boolean isHelpLinkModeModified = false;
    protected boolean isImageFormatModified = false;
    protected boolean isImageStyleModified = false;
    protected boolean isImageSizeModified = false;
    protected boolean isLocaleModified = false;
    protected boolean isSoundEnabledModified = false;
    protected boolean isSoundFormatModified = false;
    protected boolean isSoundRegenerationModeModified = false;
    protected boolean isSoundStyleModified = false;
    private String contextPath;
    private ICaptchaUrlGenerator urls;
    private HttpServletRequest httpRequest;
    public static final String MISSING_SOUND_PACKAGE_TOOLTIP = "<em>Captcha sound is enabled, but the pronunciation sound package required for the current locale can not be found.</em>\n<em>To enable Captcha sound for this locale, please deploy the appropriate sound package from the <code>\\BotDetectSounds\\</code> folder in the <code>\\WEB-INF\\</code> folder of your application. For example, use <code>Pronunciation_English_GB.bdsp</code> for British English Captcha sounds.</em>\n<em>To disable this warning and remove the sound icon for the current Captcha locale, set parameter <code>BDC_warnAboutMissingSoundPackages</code> to <code>false</code> in the <code>web.xml</code> application file. To remove the sound icon for all locales, simply set <code>web.xml</code> parameter <code>BDC_soundEnabled</code> to <code>false</code>.</em>";
    private static final String FIRST_ALPHA_ONLY_PATTERN = "([^\\d])([^\\d]*?)(\\d+)";

    public Captcha(String string, ICaptchaConfiguration iCaptchaConfiguration, CaptchaPersistence captchaPersistence) {
        this.captchaBase = new CaptchaBase(string, iCaptchaConfiguration);
        this.captchaConfiguration = iCaptchaConfiguration;
        this.captchaPersistence = captchaPersistence;
        this.imageTooltip = iCaptchaConfiguration.getImageTooltip();
        this.soundTooltip = iCaptchaConfiguration.getSoundTooltip();
        this.reloadTooltip = iCaptchaConfiguration.getReloadTooltip();
        this.helpLinkText = iCaptchaConfiguration.getHelpLinkText();
        this.helpLinkUrl = iCaptchaConfiguration.getHelpLinkUrl();
        this.reloadEnabled = iCaptchaConfiguration.isReloadEnabled();
        this.useSmallIcons = iCaptchaConfiguration.isUseSmallIcons();
        this.useHorizontalIcons = iCaptchaConfiguration.isUseHorizontalIcons();
        this.soundIconUrl = iCaptchaConfiguration.getSoundIconUrl();
        this.reloadIconUrl = iCaptchaConfiguration.getReloadIconUrl();
        this.iconsDivWidth = iCaptchaConfiguration.getIconsDivWidth();
        this.additionalCssClasses = iCaptchaConfiguration.getAdditionalCssClasses();
        this.additionalInlineCss = iCaptchaConfiguration.getAdditionalInlineCss();
        this.addCssInclude = iCaptchaConfiguration.isAddCssInclude();
        this.addScriptInclude = iCaptchaConfiguration.isAddScriptInclude();
        this.addInitScript = iCaptchaConfiguration.isAddInitScript();
        this.autoFocusInput = iCaptchaConfiguration.isAutoFocusInput();
        this.autoClearInput = iCaptchaConfiguration.isAutoClearInput();
        this.autoUppercaseInput = iCaptchaConfiguration.isAutoUppercaseInput();
        this.autoReloadExpiredCaptchas = iCaptchaConfiguration.isAutoReloadExpiredCaptchas();
        this.autoReloadTimeout = iCaptchaConfiguration.getAutoReloadTimeout();
        this.soundStartDelay = iCaptchaConfiguration.getSoundStartDelay();
        this.remoteScriptEnabled = iCaptchaConfiguration.isRemoteScriptEnabled();
        this.tabIndex = -255;
        this.urls = CaptchaUrls.getRelative();
    }

    public CaptchaBase getCaptchaBase() {
        return this.captchaBase;
    }

    public String getCaptchaId() {
        return this.captchaBase.getCaptchaId();
    }

    public String getCurrentInstanceId() {
        return this.captchaBase.getInstanceId();
    }

    public String getUserInputID() {
        return this.userInputID;
    }

    public void setUserInputID(String string) {
        this.userInputID = string;
    }

    public int getCodeLength() {
        return this.captchaBase.getCodeLength();
    }

    public void setCodeLength(int n) {
        this.captchaBase.setCodeLength(n);
        this.isCodeLengthModified = true;
    }

    public CodeStyle getCodeStyle() {
        return this.captchaBase.getCodeStyle();
    }

    public void setCodeStyle(CodeStyle codeStyle) {
        this.captchaBase.setCodeStyle(codeStyle);
        this.isCodeStyleModified = true;
    }

    public void setDisallowedCodeSubstringsCsv(String string) {
        this.captchaBase.setDisallowedCodeSubstringsCsv(string);
        this.isDisallowedCodeSubstringsModified = true;
    }

    public void setDisallowedCodeSubstringsList(List<String> list) {
        this.captchaBase.setDisallowedCodeSubstringsList(list);
        this.isDisallowedCodeSubstringsModified = true;
    }

    public int getCodeTimeout() {
        return this.captchaBase.getCodeTimeout();
    }

    public void setCodeTimeout(int n) {
        this.captchaBase.setCodeTimeout(n);
        this.isCodeTimeoutModified = true;
    }

    public List<ImageStyle> getImageStyle() {
        return this.captchaBase.getImageStyle();
    }

    public void setImageStyle(ImageStyle imageStyle) {
        if (imageStyle != null) {
            ArrayList<ImageStyle> arrayList = new ArrayList<ImageStyle>();
            arrayList.add(imageStyle);
            this.setImageStyle(arrayList);
        } else {
            this.setImageStyle((List<ImageStyle>)null);
        }
    }

    public void setImageStyle(List<ImageStyle> list) {
        this.captchaBase.setImageStyle(list);
        this.isImageStyleModified = true;
    }

    public ImageSize getImageSize() {
        return this.captchaBase.getImageSize();
    }

    public void setImageSize(ImageSize imageSize) {
        this.captchaBase.setImageSize(imageSize);
        this.isImageSizeModified = true;
    }

    public ImageFormat getImageFormat() {
        return this.captchaBase.getImageFormat();
    }

    public void setImageFormat(ImageFormat imageFormat) {
        this.captchaBase.setImageFormat(imageFormat);
        this.isImageFormatModified = true;
    }

    public Color getCustomDarkColor() {
        return this.captchaBase.getCustomDarkColor();
    }

    public void setCustomDarkColor(Color color) {
        this.captchaBase.setCustomDarkColor(color);
        this.isCustomDarkColorModified = true;
    }

    public Color getCustomLightColor() {
        return this.captchaBase.getCustomLightColor();
    }

    public void setCustomLightColor(Color color) {
        this.captchaBase.setCustomLightColor(color);
        this.isCustomLightColorModified = true;
    }

    public boolean isSoundEnabled() {
        return this.captchaBase.isSoundEnabled();
    }

    public void setSoundEnabled(boolean bl) {
        this.captchaBase.setSoundEnabled(bl);
        this.isSoundEnabledModified = true;
    }

    public List<SoundStyle> getSoundStyle() {
        return this.captchaBase.getSoundStyle();
    }

    public void setSoundStyle(SoundStyle soundStyle) {
        if (soundStyle != null) {
            ArrayList<SoundStyle> arrayList = new ArrayList<SoundStyle>();
            arrayList.add(soundStyle);
            this.setSoundStyle(arrayList);
        } else {
            this.setSoundStyle((List<SoundStyle>)null);
        }
    }

    public void setSoundStyle(List<SoundStyle> list) {
        this.captchaBase.setSoundStyle(list);
        this.isSoundStyleModified = true;
    }

    public SoundFormat getSoundFormat() {
        return this.captchaBase.getSoundFormat();
    }

    public void setSoundFormat(SoundFormat soundFormat) {
        this.captchaBase.setSoundFormat(soundFormat);
        this.isSoundFormatModified = true;
    }

    public SoundRegenerationMode getSoundRegenerationMode() {
        return this.captchaBase.getSoundRegenerationMode();
    }

    public void setSoundRegenerationMode(SoundRegenerationMode soundRegenerationMode) {
        this.captchaBase.setSoundRegenerationMode(soundRegenerationMode);
        this.isSoundRegenerationModeModified = true;
    }

    public boolean isLimitSoundRegeneration() {
        return SoundRegenerationMode.LIMITED == this.getSoundRegenerationMode();
    }

    public String getLocale() {
        return this.captchaBase.getLocale();
    }

    public void setLocale(String string) {
        this.captchaBase.setLocale(string);
        this.isLocaleModified = true;
    }

    public Localization getLocalization() {
        return this.captchaBase.getLocalization();
    }

    public void setLocalization(Localization localization) {
        this.captchaBase.setLocalization(localization);
        this.isLocaleModified = true;
    }

    public String getImageTooltip() {
        if (StringHelper.hasValue((String)this.imageTooltip)) {
            return this.imageTooltip;
        }
        return this.captchaBase.getLocalization().getImageTooltip();
    }

    public void setImageTooltip(String string) {
        this.imageTooltip = string;
    }

    public String getSoundTooltip() {
        if (this.isSoundPackageMissing() && this.captchaConfiguration.isWarnAboutMissingSoundPackages()) {
            return MISSING_SOUND_PACKAGE_TOOLTIP;
        }
        if (StringHelper.hasValue((String)this.soundTooltip)) {
            return this.soundTooltip;
        }
        return this.captchaBase.getLocalization().getSoundTooltip();
    }

    public void setSoundTooltip(String string) {
        this.soundTooltip = string;
    }

    public boolean isCaptchaSoundAvailable() {
        return this.captchaBase.getLocalization().isLocalizedPronunciationAvailable();
    }

    public boolean isSoundPackageMissing() {
        return this.isSoundEnabled() && !this.isCaptchaSoundAvailable();
    }

    public String getReloadTooltip() {
        if (StringHelper.hasValue((String)this.reloadTooltip)) {
            return this.reloadTooltip;
        }
        return this.captchaBase.getLocalization().getReloadTooltip();
    }

    public void setReloadTooltip(String string) {
        this.reloadTooltip = string;
    }

    public String getHelpLinkText() {
        if (StringHelper.hasValue((String)this.helpLinkText)) {
            return this.helpLinkText;
        }
        return HelpLinkHelper.getDefaultHelpLinkText((int)this.getImageSize().getWidth());
    }

    public void setHelpLinkText(String string) {
        if (HelpLinkHelper.isValidCustomHelpLinkText((String)string)) {
            this.helpLinkText = string;
        }
    }

    public String getHelpLinkUrl() {
        return HelpLinkHelper.getDefaultHelpLinkUrl((Localization)this.captchaBase.getLocalization());
    }

    public void setHelpLinkUrl(String string) {
        this.helpLinkUrl = UrlHelper.resolveUserSetUrl((String)string);
    }

    public boolean isReloadEnabled() {
        return this.reloadEnabled;
    }

    public void setReloadEnabled(boolean bl) {
        this.reloadEnabled = bl;
    }

    public boolean isRenderIcons() {
        return this.isReloadEnabled() || this.isSoundEnabled();
    }

    public boolean isUseSmallIcons() {
        if (this.useSmallIcons != null) {
            return this.useSmallIcons;
        }
        return this.getImageSize().getHeight() < 50;
    }

    public void setUseSmallIcons(boolean bl) {
        this.useSmallIcons = bl;
    }

    public boolean isUseHorizontalIcons() {
        if (this.useHorizontalIcons != null) {
            return this.useHorizontalIcons;
        }
        return this.getImageSize().getHeight() < 40;
    }

    public void setUseHorizontalIcons(boolean bl) {
        this.useHorizontalIcons = bl;
    }

    public String getSoundIconUrl() {
        String string;
        if (StringHelper.hasValue((String)this.soundIconUrl)) {
            string = this.soundIconUrl;
        } else {
            string = this.urls.getDefaultSoundIconUrl();
            if (this.isUseSmallIcons()) {
                string = this.urls.getSmallIconUrl(string);
            }
        }
        if (this.isSoundPackageMissing() && this.captchaConfiguration.isWarnAboutMissingSoundPackages()) {
            string = this.urls.getDisabledIconUrl(string);
        }
        return string;
    }

    public void setSoundIconUrl(String string) {
        this.soundIconUrl = UrlHelper.resolveUserSetUrl((String)string);
    }

    public String getReloadIconUrl() {
        String string;
        if (StringHelper.hasValue((String)this.reloadIconUrl)) {
            string = this.reloadIconUrl;
        } else {
            string = this.urls.getDefaultReloadIconUrl();
            if (this.isUseSmallIcons()) {
                string = this.urls.getSmallIconUrl(string);
            }
        }
        return string;
    }

    public void setReloadIconUrl(String string) {
        this.reloadIconUrl = UrlHelper.resolveUserSetUrl((String)string);
    }

    public int getIconsDivWidth() {
        if (this.iconsDivWidth != null) {
            return this.iconsDivWidth;
        }
        if (this.isUseHorizontalIcons()) {
            return 2 * this.getIconSizeDefault() + 8;
        }
        return this.getIconSizeDefault() + 2;
    }

    public void setIconsDivWidth(int n) {
        this.iconsDivWidth = n;
    }

    protected int getIconSizeDefault() {
        if (this.isUseSmallIcons()) {
            return 17;
        }
        return 22;
    }

    public boolean isHelpLinkEnabled() {
        return true;
    }

    public void setHelpLinkEnabled(boolean bl) {
        this.captchaBase.setHelpLinkEnabled(bl);
        this.isHelpLinkEnabledModified = true;
    }

    public HelpLinkMode getHelpLinkMode() {
        return this.captchaBase.getHelpLinkMode();
    }

    public void setHelpLinkMode(HelpLinkMode helpLinkMode) {
        this.captchaBase.setHelpLinkMode(helpLinkMode);
        this.isHelpLinkModeModified = true;
    }

    protected int getAdjustedHeight() {
        return this.captchaBase.getImageSize().getHeight() - 10;
    }

    protected int getHelpLinkHeight() {
        return 10;
    }

    protected int getHelpLinkFontSize() {
        return 9;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(int n) {
        this.tabIndex = n;
    }

    public boolean isTabIndexSet() {
        return -255 != this.tabIndex;
    }

    public String getAdditionalCssClasses() {
        return this.additionalCssClasses;
    }

    public void setAdditionalCssClasses(String string) {
        this.additionalCssClasses = string;
    }

    public String getAdditionalInlineCss() {
        return this.additionalInlineCss;
    }

    public void setAdditionalInlineCss(String string) {
        this.additionalInlineCss = string;
    }

    public boolean isAddCssInclude() {
        return this.addCssInclude;
    }

    public void setAddCssInclude(boolean bl) {
        this.addCssInclude = bl;
    }

    public int getTotalWidth() {
        int n = this.getImageSize().getWidth();
        if (this.isRenderIcons()) {
            n = n + 6 + this.getIconsDivWidth();
        }
        return n;
    }

    public int getTotalHeight() {
        return this.getImageSize().getHeight();
    }

    public boolean isAddScriptInclude() {
        return this.addScriptInclude;
    }

    public void setAddScriptInclude(boolean bl) {
        this.addScriptInclude = bl;
    }

    public String getScriptIncludeMarkup() {
        return HtmlHelper.scriptInclude((String)(this.contextPath + this.urls.getScriptIncludeUrl()));
    }

    public boolean isAddInitScript() {
        return this.addInitScript;
    }

    public void setAddInitScript(boolean bl) {
        this.addInitScript = bl;
    }

    public boolean isAutoUppercaseInput() {
        return this.autoUppercaseInput;
    }

    public void setAutoUppercaseInput(boolean bl) {
        this.autoUppercaseInput = bl;
    }

    public boolean isAutoFocusInput() {
        return this.autoFocusInput;
    }

    public void setAutoFocusInput(boolean bl) {
        this.autoFocusInput = bl;
    }

    public boolean isAutoClearInput() {
        return this.autoClearInput;
    }

    public void setAutoClearInput(boolean bl) {
        this.autoClearInput = bl;
    }

    public boolean isAutoReloadExpiredCaptchas() {
        return this.autoReloadExpiredCaptchas;
    }

    public void setAutoReloadExpiredCaptchas(boolean bl) {
        this.autoReloadExpiredCaptchas = bl;
    }

    public int getAutoReloadTimeout() {
        return this.autoReloadTimeout;
    }

    public void setAutoReloadTimeout(int n) {
        this.autoReloadTimeout = n;
    }

    public int getSoundStartDelay() {
        return this.soundStartDelay;
    }

    public void setSoundStartDelay(int n) {
        this.soundStartDelay = n;
    }

    public boolean isRemoteScriptEnabled() {
        boolean bl = this.remoteScriptEnabled;
        bl = true;
        if (HttpHelper.isLocalRequest(this.httpRequest)) {
            bl = false;
        }
        return bl;
    }

    public void setRemoteScriptEnabled(boolean bl) {
        this.remoteScriptEnabled = bl;
    }

    public void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        this.httpRequest = httpServletRequest;
    }

    public void setContextPath(String string) {
        this.contextPath = string;
    }

    public ICaptchaUrlGenerator getUrlGenerator() {
        return this.urls;
    }

    public void setUrlGenerator(ICaptchaUrlGenerator iCaptchaUrlGenerator) {
        this.urls = iCaptchaUrlGenerator;
    }

    public String getCaptchaImageUrl() {
        return this.urls.getCaptchaImageUrl(this.getCaptchaId(), this.getCurrentInstanceId());
    }

    public String getCaptchaSoundUrl() {
        return this.urls.getCaptchaSoundUrl(this.getCaptchaId(), this.getCurrentInstanceId());
    }

    public String getImageClientId() {
        return this.getCaptchaId() + "_CaptchaImage";
    }

    public String getAudioPlaceholderClientId() {
        return this.getCaptchaId() + "_AudioPlaceholder";
    }

    public String getValidatingInstanceKey() {
        return "BDC_VCID_" + this.getCaptchaId();
    }

    public String getValidatingInstanceId() {
        return this.httpRequest.getParameter(this.getValidatingInstanceKey());
    }

    public String getSubmittedUserInput() {
        return Captcha.getUserInputUTF8(this.httpRequest, this.httpRequest.getParameter(this.getUserInputID()));
    }

    public boolean isSubmit() {
        boolean bl = false;
        String string = this.getValidatingInstanceId();
        if (StringHelper.hasValue((String)string)) {
            bl = string.matches("^(\\w+)$");
        }
        return bl;
    }

    public void initialize() {
        this.load(this);
    }

    public void load(Captcha captcha) {
        String string = captcha.getCaptchaId();
        this.captchaPersistence.loadCodeCollection(captcha.getCaptchaBase(), string);
        this.captchaPersistence.loadCodeLength(captcha.getCaptchaBase(), string);
        this.captchaPersistence.loadCodeStyle(captcha.getCaptchaBase(), string);
        this.captchaPersistence.loadCodeTimeout(captcha.getCaptchaBase(), string);
        this.captchaPersistence.loadDisallowedCodeSubstrings(captcha.getCaptchaBase(), string);
        this.captchaPersistence.loadImageStyle(captcha.getCaptchaBase(), string);
        this.captchaPersistence.loadImageFormat(captcha.getCaptchaBase(), string);
        this.captchaPersistence.loadImageSize(captcha.getCaptchaBase(), string);
        this.captchaPersistence.loadCustomLightColor(captcha.getCaptchaBase(), string);
        this.captchaPersistence.loadCustomDarkColor(captcha.getCaptchaBase(), string);
        this.captchaPersistence.loadSoundEnabled(captcha.getCaptchaBase(), string);
        this.captchaPersistence.loadSoundStyle(captcha.getCaptchaBase(), string);
        this.captchaPersistence.loadSoundFormat(captcha.getCaptchaBase(), string);
        this.captchaPersistence.loadSoundRegenerationMode(captcha.getCaptchaBase(), string);
        this.captchaPersistence.loadHelpLinkEnabled(captcha.getCaptchaBase(), string);
        this.captchaPersistence.loadHelpLinkMode(captcha.getCaptchaBase(), string);
        this.captchaPersistence.loadLocale(captcha.getCaptchaBase(), string);
    }

    public void save(Captcha captcha) {
        String string = captcha.getCaptchaId();
        captcha.saveCaptchaCodes(captcha);
        if (captcha.isCodeLengthModified) {
            this.captchaPersistence.saveCodeLength(string, captcha.getCaptchaBase().getCodeLengthNullable());
        }
        if (captcha.isCodeStyleModified) {
            this.captchaPersistence.saveCodeStyle(string, captcha.getCodeStyle());
        }
        if (captcha.isCodeTimeoutModified) {
            this.captchaPersistence.saveCodeTimeout(string, captcha.getCaptchaBase().getCodeTimeout());
        }
        if (captcha.isDisallowedCodeSubstringsModified) {
            this.captchaPersistence.saveDisallowedCodeSubstrings(string, captcha.getCaptchaBase().getDisallowedCodeSubstrings());
        }
        if (captcha.isImageStyleModified) {
            this.captchaPersistence.saveImageStyle(string, captcha.getCaptchaBase().getImageStyle());
        }
        if (captcha.isImageFormatModified) {
            this.captchaPersistence.saveImageFormat(string, captcha.getImageFormat());
        }
        if (captcha.isImageSizeModified) {
            this.captchaPersistence.saveImageSize(string, captcha.getCaptchaBase().getImageSize());
        }
        if (captcha.isCustomLightColorModified) {
            this.captchaPersistence.saveCustomLightColor(string, captcha.getCaptchaBase().getCustomLightColor());
        }
        if (captcha.isCustomDarkColorModified) {
            this.captchaPersistence.saveCustomDarkColor(string, captcha.getCaptchaBase().getCustomDarkColor());
        }
        if (captcha.isSoundEnabledModified) {
            this.captchaPersistence.saveSoundEnabled(string, captcha.getCaptchaBase().isSoundEnabled());
        }
        if (captcha.isSoundStyleModified) {
            this.captchaPersistence.saveSoundStyle(string, captcha.getCaptchaBase().getSoundStyle());
        }
        if (captcha.isSoundFormatModified) {
            this.captchaPersistence.saveSoundFormat(string, captcha.getSoundFormat());
        }
        if (captcha.isSoundRegenerationModeModified) {
            this.captchaPersistence.saveSoundRegenerationMode(string, captcha.getSoundRegenerationMode());
        }
        if (captcha.isHelpLinkEnabledModified) {
            this.captchaPersistence.saveHelpLinkEnabled(string, captcha.isHelpLinkEnabled());
        }
        if (captcha.isHelpLinkModeModified) {
            this.captchaPersistence.saveHelpLinkMode(string, captcha.getHelpLinkMode());
        }
        if (captcha.isLocaleModified) {
            this.captchaPersistence.saveLocale(string, captcha.getLocale());
        }
    }

    public void saveCaptchaCodes(Captcha captcha) {
        String string = captcha.getCaptchaId();
        this.captchaPersistence.saveCodeCollection(string, captcha.getCaptchaBase().getCodeCollection());
    }

    public static Captcha load(ServletRequest servletRequest, String string) {
        if (!StringHelper.hasValue((String)string)) {
            return null;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        CaptchaPersistence captchaPersistence = PersistenceHelper.getJspPersistence(httpServletRequest);
        Captcha captcha = captchaPersistence.load(string);
        captcha.setHttpServletRequest(httpServletRequest);
        captcha.setContextPath(httpServletRequest.getContextPath());
        return captcha;
    }

    public String getInitScriptMarkup() {
        String string = String.format("     BotDetect.Init(%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s);", JavaScriptHelper.string((String)this.getCaptchaId()), JavaScriptHelper.string((String)this.getCurrentInstanceId()), JavaScriptHelper.string((String)this.getUserInputID()), JavaScriptHelper.bool((boolean)this.isAutoUppercaseInput()), JavaScriptHelper.bool((boolean)this.isAutoFocusInput()), JavaScriptHelper.bool((boolean)this.isAutoClearInput()), JavaScriptHelper.bool((boolean)this.isAutoReloadExpiredCaptchas()), this.getCodeTimeout(), this.getAutoReloadTimeout(), this.getSoundStartDelay(), JavaScriptHelper.bool((boolean)this.isLimitSoundRegeneration()));
        return HtmlHelper.scriptFragment((String)string);
    }

    public String getRemoteScriptIncludeMarkup() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        PascalString.append((StringBuilder)stringBuilder, (String)"0");
        PascalString.append((StringBuilder)stringBuilder, (String)"3");
        PascalString.append((StringBuilder)stringBuilder, (String)"0");
        String string2 = "0";
        String string3 = "0";
        String string4 = "0";
        String[] stringArray = ((String)CaptchaBase.getProductInfo().get("version")).split("\\.");
        string2 = stringArray[0].replaceAll(FIRST_ALPHA_ONLY_PATTERN, "$1$3");
        string3 = stringArray[1].replaceAll(FIRST_ALPHA_ONLY_PATTERN, "$1$3");
        string4 = stringArray[2].replaceAll(FIRST_ALPHA_ONLY_PATTERN, "$1$3");
        PascalString.append((StringBuilder)stringBuilder, (String)string2);
        PascalString.append((StringBuilder)stringBuilder, (String)string3);
        PascalString.append((StringBuilder)stringBuilder, (String)string4);
        String string5 = "UNKNOWN";
        String string6 = null;
        HttpSession httpSession = null;
        if (this.httpRequest != null) {
            httpSession = this.httpRequest.getSession();
        }
        if (httpSession != null) {
            string5 = httpSession.getId();
            string6 = (String)httpSession.getAttribute("BDC_SessionSalt");
        }
        if (string6 == null) {
            string6 = UUID.randomUUID().toString();
            if (httpSession != null) {
                httpSession.setAttribute("BDC_SessionSalt", (Object)string6);
            }
        }
        string6 = string5 + string6;
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("Captcha.getRemoteScriptIncludeMarkup:" + noSuchAlgorithmException);
        }
        if (messageDigest != null) {
            try {
                string = new String(messageDigest.digest(string6.getBytes("US-ASCII")));
                PascalString.append((StringBuilder)stringBuilder, (String)string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("Captcha.getRemoteScriptIncludeMarkup.hash:" + unsupportedEncodingException);
            }
        }
        PascalString.append((StringBuilder)stringBuilder, (String)"2");
        PascalString.append((StringBuilder)stringBuilder, (String)"0");
        PascalString.append((StringBuilder)stringBuilder, (String)"0");
        PascalString.append((StringBuilder)stringBuilder, (String)"3");
        PascalString.append((StringBuilder)stringBuilder, (String)"0");
        PascalString.append((StringBuilder)stringBuilder, (String)"1");
        PascalString.append((StringBuilder)stringBuilder, (String)"6.0");
        PascalString.append((StringBuilder)stringBuilder, (String)"1");
        PascalString.append((StringBuilder)stringBuilder, (String)this.getLocale());
        PascalString.append((StringBuilder)stringBuilder, (String)Integer.toString(this.getImageSize().getWidth()));
        PascalString.append((StringBuilder)stringBuilder, (String)Integer.toString(this.getImageSize().getHeight()));
        string = "";
        try {
            string = Base64.encodeBytes((byte[])stringBuilder.toString().getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("Captcha.getRemoteScriptIncludeMarkup.id:" + unsupportedEncodingException);
        }
        string = string.replace('+', '-').replace('/', '_').replace("=", "");
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("      try{(function(){var bdrsn = document.createElement('script'); bdrsn.type = 'text/javascript'; bdrsn.async = true; bdrsn.src = document.location.protocol + '//remote.captcha.com/include.js?i=");
        stringBuilder2.append(string);
        stringBuilder2.append("'; var fsn = document.getElementsByTagName('script')[0]; fsn.parentNode.insertBefore(bdrsn, fsn);})();} catch(err){}");
        return HtmlHelper.scriptFragment((String)stringBuilder2.toString());
    }

    public String getHtml() {
        this.save(this);
        StringBuilder stringBuilder = new StringBuilder();
        this.renderXhtml11Strict(stringBuilder);
        return stringBuilder.toString();
    }

    public void renderXhtml11Strict(StringBuilder stringBuilder) {
        if (!this.isCaptchaSoundAvailable() && !this.captchaConfiguration.isWarnAboutMissingSoundPackages()) {
            this.setSoundEnabled(false);
        }
        stringBuilder.append("\r\n");
        this.renderCssIncludes(stringBuilder);
        this.renderWarnings(stringBuilder);
        stringBuilder.append(String.format("  <div class=\"BDC_CaptchaDiv %s\" id=\"%s_CaptchaDiv\" style=\"width: %dpx !important; height: %dpx !important; %s\"><!--", this.getAdditionalCssClasses(), this.getCaptchaId(), this.getTotalWidth(), this.getTotalHeight(), this.getAdditionalInlineCss()));
        stringBuilder.append("\r\n");
        this.renderCaptchaImageMarkup(stringBuilder);
        this.renderCaptchaIcons(stringBuilder);
        this.renderScriptIncludes(stringBuilder);
        this.renderHiddenFields(stringBuilder);
        stringBuilder.append("\r\n");
        stringBuilder.append("  </div>");
        stringBuilder.append("\r\n");
    }

    void renderWarnings(StringBuilder stringBuilder) {
        this.renderTestModeWarning(stringBuilder);
    }

    protected void renderTestModeWarning(StringBuilder stringBuilder) {
        if (this.captchaConfiguration.isTestModeEnabled()) {
            stringBuilder.append("<p class=\"BDC_Warning\">Test Mode Enabled</p>");
        }
    }

    protected void renderCaptchaImageMarkup(StringBuilder stringBuilder) {
        stringBuilder.append(String.format(" --><div class=\"BDC_CaptchaImageDiv\" id=\"%s_CaptchaImageDiv\" style=\"width: %dpx !important; height: %dpx !important;\"><!--", this.getCaptchaId(), this.getImageSize().getWidth(), this.getImageSize().getHeight()));
        stringBuilder.append("\r\n");
        if (!this.isHelpLinkEnabled()) {
            this.renderPlainImage(stringBuilder);
        } else {
            switch (this.getHelpLinkMode()) {
                case IMAGE: {
                    this.renderLinkedImage(stringBuilder);
                    break;
                }
                case TEXT: {
                    this.renderPlainImageWithTextLink(stringBuilder);
                }
            }
        }
        stringBuilder.append("\r\n");
        if (this.isRenderIcons()) {
            stringBuilder.append(" --></div><!--");
        } else {
            stringBuilder.append("  --></div>");
        }
    }

    protected void renderPlainImage(StringBuilder stringBuilder) {
        stringBuilder.append(String.format("   --><img class=\"BDC_CaptchaImage\" id=\"%s\" src=\"%s\" alt=\"%s\" /><!--", this.getImageClientId(), this.contextPath + this.getCaptchaImageUrl(), this.getImageTooltip()));
    }

    protected void renderLinkedImage(StringBuilder stringBuilder) {
        if (this.isTabIndexSet()) {
            stringBuilder.append(String.format("   --><a href=\"%s\" title=\"%s\" tabindex=\"%d\" onclick=\"%s.OnHelpLinkClick(); return %s.FollowHelpLink;\"><img class=\"BDC_CaptchaImage\" id=\"%s\" src=\"%s\" alt=\"%s\" /></a><!--", this.getHelpLinkUrl(), this.getHelpLinkText(), this.getTabIndex(), this.getCaptchaId(), this.getCaptchaId(), this.getImageClientId(), this.contextPath + this.getCaptchaImageUrl(), this.getImageTooltip()));
            if (this.getTabIndex() != -1) {
                this.setTabIndex((short)(this.getTabIndex() + 1));
            }
        } else {
            stringBuilder.append(String.format("   --><a href=\"%s\" title=\"%s\" onclick=\"%s.OnHelpLinkClick(); return %s.FollowHelpLink;\"><img class=\"BDC_CaptchaImage\" id=\"%s\" src=\"%s\" alt=\"%s\" /></a><!--", this.getHelpLinkUrl(), this.getHelpLinkText(), this.getCaptchaId(), this.getCaptchaId(), this.getImageClientId(), this.contextPath + this.getCaptchaImageUrl(), this.getImageTooltip()));
        }
    }

    protected void renderPlainImageWithTextLink(StringBuilder stringBuilder) {
        stringBuilder.append(String.format("   --><div class=\"BDC_CaptchaImageDiv\" style=\"width:%dpx; height:%dpx;\"><img class=\"BDC_CaptchaImage\" id=\"%s\" src=\"%s\" alt=\"%s\" /></div><!--", this.getImageSize().getWidth(), this.getAdjustedHeight(), this.getImageClientId(), this.contextPath + this.getCaptchaImageUrl(), this.getImageTooltip()));
        stringBuilder.append("\r\n");
        if (this.isTabIndexSet()) {
            stringBuilder.append(String.format("   --><a href=\"%s\" title=\"%s\" tabindex=\"%d\" style=\"display: block !important; height: %dpx !important; margin: 0 !important; padding: 0 !important; font-size: %dpx !important; line-height: %dpx !important; visibility: visible !important; font-family: Verdana, DejaVu Sans, Bitstream Vera Sans, Verdana Ref, sans-serif !important; vertical-align: middle !important; text-align: center !important; text-decoration: none !important; background-color: #f8f8f8 !important; color: #606060 !important;\">%s</a><!--", this.getHelpLinkUrl(), this.getHelpLinkText(), this.getTabIndex(), this.getHelpLinkHeight(), this.getHelpLinkFontSize(), this.getHelpLinkHeight(), this.getHelpLinkText()));
            if (this.getTabIndex() != -1) {
                this.setTabIndex((short)(this.getTabIndex() + 1));
            }
        } else {
            stringBuilder.append(String.format("   --><a href=\"%s\" title=\"%s\" style=\"display: block !important; height: %dpx !important; margin: 0 !important; padding: 0 !important; font-size: %dpx !important; line-height: %dpx !important; visibility: visible !important; font-family: Verdana, DejaVu Sans, Bitstream Vera Sans, Verdana Ref, sans-serif !important; vertical-align: middle !important; text-align: center !important; text-decoration: none !important; background-color: #f8f8f8 !important; color: #606060 !important;\">%s</a><!--", this.getHelpLinkUrl(), this.getHelpLinkText(), this.getHelpLinkHeight(), this.getHelpLinkFontSize(), this.getHelpLinkHeight(), this.getHelpLinkText()));
        }
    }

    protected void renderCaptchaIcons(StringBuilder stringBuilder) {
        if (this.isRenderIcons()) {
            stringBuilder.append("\r\n");
            stringBuilder.append(String.format(" --><div class=\"BDC_CaptchaIconsDiv\" id=\"%s_CaptchaIconsDiv\" style=\"width: %dpx !important;\"><!--", this.getCaptchaId(), this.getIconsDivWidth()));
            stringBuilder.append("\r\n");
        }
        if (this.isReloadEnabled()) {
            if (this.isTabIndexSet()) {
                stringBuilder.append(String.format("   --><a class=\"BDC_ReloadLink\" id=\"%s_ReloadLink\" href=\"#\" tabindex=\"%d\" onclick=\"%s.ReloadImage(); this.blur(); return false;\" title=\"%s\"><img class=\"BDC_ReloadIcon\" id=\"%s_ReloadIcon\" src=\"%s\" alt=\"%s\" /></a><!--", this.getCaptchaId(), this.getTabIndex(), this.getCaptchaId(), this.getReloadTooltip(), this.getCaptchaId(), this.contextPath + this.getReloadIconUrl(), this.getReloadTooltip()));
                if (this.getTabIndex() != -1) {
                    this.setTabIndex((short)(this.getTabIndex() + 1));
                }
            } else {
                stringBuilder.append(String.format("   --><a class=\"BDC_ReloadLink\" id=\"%s_ReloadLink\" href=\"#\" onclick=\"%s.ReloadImage(); this.blur(); return false;\" title=\"%s\"><img class=\"BDC_ReloadIcon\" id=\"%s_ReloadIcon\" src=\"%s\" alt=\"%s\" /></a><!--", this.getCaptchaId(), this.getCaptchaId(), this.getReloadTooltip(), this.getCaptchaId(), this.contextPath + this.getReloadIconUrl(), this.getReloadTooltip()));
            }
            stringBuilder.append("\r\n");
        }
        if (this.isSoundEnabled()) {
            if (this.isCaptchaSoundAvailable()) {
                if (this.isTabIndexSet()) {
                    stringBuilder.append(String.format("   --><a rel=\"nofollow\" class=\"BDC_SoundLink\" id=\"%s_SoundLink\" href=\"%s\" tabindex=\"%d\" onclick=\"%s.PlaySound(); this.blur(); return false;\" title=\"%s\"><img class=\"BDC_SoundIcon\" id=\"%s_SoundIcon\" src=\"%s\" alt=\"%s\" /></a><!--", this.getCaptchaId(), this.contextPath + this.getCaptchaSoundUrl(), this.getTabIndex(), this.getCaptchaId(), this.getSoundTooltip(), this.getCaptchaId(), this.contextPath + this.getSoundIconUrl(), this.getSoundTooltip()));
                } else {
                    stringBuilder.append(String.format("   --><a rel=\"nofollow\" class=\"BDC_SoundLink\" id=\"%s_SoundLink\" href=\"%s\" onclick=\"%s.PlaySound(); this.blur(); return false;\" title=\"%s\"><img class=\"BDC_SoundIcon\" id=\"%s_SoundIcon\" src=\"%s\" alt=\"%s\" /></a><!--", this.getCaptchaId(), this.contextPath + this.getCaptchaSoundUrl(), this.getCaptchaId(), this.getSoundTooltip(), this.getCaptchaId(), this.contextPath + this.getSoundIconUrl(), this.getSoundTooltip()));
                }
                stringBuilder.append("\r\n");
            } else if (this.captchaConfiguration.isWarnAboutMissingSoundPackages()) {
                stringBuilder.append(String.format("   --><a target=\"_blank\" class=\"BDC_DisabledLink\" id=\"%s_SoundLink\" href=\"#\" tabindex=\"%d\" onclick=\"this.blur(); return false;\"><img class=\"BDC_SoundIcon\" id=\"%s_SoundIcon\" src=\"%s\" alt=\"\" /><span>%s</span></a><!--", this.getCaptchaId(), -255, this.getCaptchaId(), this.contextPath + this.getSoundIconUrl(), this.getSoundTooltip()));
                stringBuilder.append("\r\n");
            }
        }
        if (this.isSoundEnabled()) {
            stringBuilder.append(String.format("   --><div class=\"BDC_Placeholder\" id=\"%s\">&nbsp;</div><!--", this.getAudioPlaceholderClientId()));
        }
        stringBuilder.append(" --></div>");
    }

    protected void renderScriptIncludes(StringBuilder stringBuilder) {
        if (this.isAddScriptInclude()) {
            stringBuilder.append("\r\n");
            stringBuilder.append(this.getScriptIncludeMarkup());
        }
        if (this.isAddInitScript()) {
            stringBuilder.append("\r\n");
            stringBuilder.append(this.getInitScriptMarkup());
        }
        if (this.isRemoteScriptEnabled()) {
            stringBuilder.append(this.getRemoteScriptIncludeMarkup());
        }
    }

    protected void renderCssIncludes(StringBuilder stringBuilder) {
        if (this.isAddCssInclude()) {
            stringBuilder.append("\r\n");
            stringBuilder.append("  ").append(HtmlHelper.stylesheetInclude((String)(this.contextPath + CaptchaUrls.getLayoutStyleSheetUrl())));
            stringBuilder.append("\r\n");
        }
    }

    protected void renderHiddenFields(StringBuilder stringBuilder) {
        stringBuilder.append("\r\n");
        stringBuilder.append(HtmlHelper.hiddenField((String)this.getValidatingInstanceKey(), (String)this.getCurrentInstanceId()));
        stringBuilder.append("\r\n");
        stringBuilder.append(HtmlHelper.hiddenField((String)("BDC_BackWorkaround_" + this.getCaptchaId()), (String)"0"));
    }

    public boolean validate() {
        return this.captchaBase.validate(this.getSubmittedUserInput(), this.getValidatingInstanceId(), ValidationAttemptOrigin.SERVER);
    }

    public boolean ajaxValidate() {
        return this.captchaBase.validate(this.getSubmittedUserInput(), this.getValidatingInstanceId(), ValidationAttemptOrigin.CLIENT);
    }

    public boolean validate(String string) {
        return this.captchaBase.validate(Captcha.getUserInputUTF8(this.httpRequest, string), this.getValidatingInstanceId(), ValidationAttemptOrigin.SERVER);
    }

    public boolean ajaxValidate(String string) {
        return this.captchaBase.validate(Captcha.getUserInputUTF8(this.httpRequest, string), this.getValidatingInstanceId(), ValidationAttemptOrigin.CLIENT);
    }

    public boolean validate(String string, String string2) {
        return this.captchaBase.validate(Captcha.getUserInputUTF8(this.httpRequest, string), string2, ValidationAttemptOrigin.SERVER);
    }

    public boolean ajaxValidate(String string, String string2) {
        return this.captchaBase.validate(Captcha.getUserInputUTF8(this.httpRequest, string), string2, ValidationAttemptOrigin.CLIENT);
    }

    public static boolean validate(ServletRequest servletRequest, String string, String string2, String string3) {
        Captcha captcha = Captcha.load(servletRequest, string);
        String string4 = Captcha.getUserInputUTF8((HttpServletRequest)servletRequest, string2);
        return captcha.getCaptchaBase().validate(string4, string3, ValidationAttemptOrigin.SERVER);
    }

    public static boolean ajaxValidate(ServletRequest servletRequest, String string, String string2, String string3) {
        Captcha captcha = Captcha.load(servletRequest, string);
        String string4 = Captcha.getUserInputUTF8((HttpServletRequest)servletRequest, string2);
        return captcha.getCaptchaBase().validate(string4, string3, ValidationAttemptOrigin.CLIENT);
    }

    private static String getUserInputUTF8(HttpServletRequest httpServletRequest, String string) {
        String string2;
        try {
            string2 = httpServletRequest.getCharacterEncoding() == null ? new String(string.getBytes("8859_1"), "UTF8") : new String(string.getBytes(httpServletRequest.getCharacterEncoding()), "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("Captcha.getUserInputUTF8: " + unsupportedEncodingException.getMessage());
            string2 = string;
        }
        return string2;
    }

    public static boolean isFree() {
        return true;
    }

    public static String getLibInfo() {
        Map map = CaptchaBase.getProductInfo();
        return String.format("%s version %s %s loaded by Java version %s", map.get("name"), map.get("version"), Captcha.isFree() ? "Free" : "Enterprise", System.getProperty("java.version"));
    }
}

