/*
 * Decompiled with CFR 0.152.
 */
package com.captcha.botdetect.internal.support.i18n;

import com.captcha.botdetect.internal.infrastructure.d.c.c;
import com.captcha.botdetect.internal.infrastructure.d.c.d;
import com.captcha.botdetect.internal.infrastructure.e.a;
import com.captcha.botdetect.internal.infrastructure.e.e;
import com.captcha.botdetect.internal.infrastructure.text.StringHelper;
import com.captcha.botdetect.internal.support.CaptchaDefaults;
import com.captcha.botdetect.internal.support.i18n.b;
import java.util.Set;

public class Localization {
    private c fonts;
    private String canonicalLocaleString;
    private e macrolanguage;
    private com.captcha.botdetect.internal.infrastructure.e.b language;
    private String languageCode;
    private a charset;
    private String charsetCode;
    private com.captcha.botdetect.internal.infrastructure.e.c country;
    private String countryCode;
    private Set charsetDiff;
    private String helpLinkUrl;
    private String imageTooltip;
    private String reloadTooltip;
    private String soundTooltip;
    private String soundPackagesFolder;
    private String pronunciationFilename;
    private boolean isRtl;

    public Localization(b b2) {
        this.macrolanguage = b2.a();
        this.language = b2.b();
        this.charset = b2.c();
        this.country = b2.d();
        this.charsetDiff = StringHelper.getCodePoints(b2.e());
        this.imageTooltip = b2.g();
        this.reloadTooltip = b2.h();
        this.soundTooltip = b2.i();
        this.helpLinkUrl = b2.f();
        this.init();
    }

    public c getFonts() {
        return this.fonts;
    }

    public e getMacrolanguage() {
        return this.macrolanguage;
    }

    public void setMacrolanguage(e e2) {
        this.macrolanguage = e2;
    }

    public com.captcha.botdetect.internal.infrastructure.e.b getLanguage() {
        return this.language;
    }

    public void setLanguage(com.captcha.botdetect.internal.infrastructure.e.b b2) {
        this.language = b2;
    }

    public a getCharset() {
        return this.charset;
    }

    public void setCharset(a a2) {
        this.charset = a2;
    }

    public Set getCharsetDiff() {
        return this.charsetDiff;
    }

    public com.captcha.botdetect.internal.infrastructure.e.c getCountry() {
        return this.country;
    }

    public void setCountry(com.captcha.botdetect.internal.infrastructure.e.c c2) {
        this.country = c2;
    }

    public String getHelpLinkUrl() {
        return this.helpLinkUrl;
    }

    public String getImageTooltip() {
        return this.imageTooltip;
    }

    public String getReloadTooltip() {
        return this.reloadTooltip;
    }

    public String getSoundTooltip() {
        return this.soundTooltip;
    }

    public String getSoundPackagesFolder() {
        return this.soundPackagesFolder;
    }

    public void setSoundPackagesFolder(String string) {
        this.soundPackagesFolder = string;
    }

    public String getPronunciationFilename() {
        return this.pronunciationFilename;
    }

    public boolean isRtl() {
        return this.isRtl;
    }

    public final void init() {
        this.initLanguage();
        this.initCharset();
        this.initCountry();
        this.initCanonicalLocaleString();
        this.initPronunciationFilename();
    }

    private void initLanguage() {
        this.languageCode = "";
        if (this.macrolanguage != e.a) {
            this.languageCode = this.languageCode + e.a(this.macrolanguage);
        }
        if (this.macrolanguage != e.a && this.language != com.captcha.botdetect.internal.infrastructure.e.b.a) {
            this.languageCode = this.languageCode + "-";
        }
        if (this.language != com.captcha.botdetect.internal.infrastructure.e.b.a) {
            this.languageCode = this.languageCode + com.captcha.botdetect.internal.infrastructure.e.b.a(this.language);
        }
    }

    private void initCharset() {
        this.initRtl();
        this.initFonts();
        this.charsetCode = a.a(this.charset);
    }

    private void initRtl() {
        this.isRtl = false;
        if (this.charset == a.b || this.charset == a.j) {
            this.isRtl = true;
        }
    }

    private void initFonts() {
        this.fonts = new c();
        for (String string : d.a(this.charset)) {
            this.fonts.a(new com.captcha.botdetect.internal.core.b.d(string, 1, com.captcha.botdetect.internal.infrastructure.d.c.e.a));
        }
    }

    private void initCountry() {
        this.countryCode = com.captcha.botdetect.internal.infrastructure.e.d.a(this.country);
    }

    private void initCanonicalLocaleString() {
        if (this.country == com.captcha.botdetect.internal.infrastructure.e.c.a) {
            this.canonicalLocaleString = String.format(null, "%s-%s", this.languageCode, this.charsetCode);
            return;
        }
        this.canonicalLocaleString = String.format(null, "%s-%s-%s", this.languageCode, this.charsetCode, this.countryCode);
    }

    private void initPronunciationFilename() {
        String string = "Unknown";
        if (com.captcha.botdetect.internal.infrastructure.e.b.a != this.language) {
            string = this.language.toString();
        } else if (e.a != this.macrolanguage) {
            string = this.macrolanguage.toString();
        }
        if (com.captcha.botdetect.internal.infrastructure.e.c.a == this.country) {
            this.pronunciationFilename = String.format(null, "Pronunciation_%s.bdsp", string);
            return;
        }
        this.pronunciationFilename = String.format(null, "Pronunciation_%s_%s.bdsp", string, this.countryCode);
    }

    public boolean isLocalizedPronunciationAvailable() {
        if (this.language == CaptchaDefaults.LOCALIZATION.getLanguage() && this.country == CaptchaDefaults.LOCALIZATION.getCountry()) {
            return true;
        }
        com.captcha.botdetect.internal.infrastructure.a.e.b b2 = com.captcha.botdetect.internal.infrastructure.a.e.d.a(this);
        return b2.i();
    }

    public String toString() {
        return this.canonicalLocaleString;
    }
}

