/*
 * Decompiled with CFR 0.152.
 */
package com.captcha.botdetect.internal.infrastructure.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Base64 {
    public static final int NO_OPTIONS = 0;
    public static final int ENCODE = 1;
    public static final int DECODE = 0;
    public static final int GZIP = 2;
    public static final int DONT_GUNZIP = 4;
    public static final int DO_BREAK_LINES = 8;
    public static final int URL_SAFE = 16;
    public static final int ORDERED = 32;
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final String PREFERRED_ENCODING = "US-ASCII";
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;
    private static final byte[] _STANDARD_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] _STANDARD_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9};
    private static final byte[] _URL_SAFE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] _URL_SAFE_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, 63, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9};
    private static final byte[] _ORDERED_ALPHABET = new byte[]{45, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private static final byte[] _ORDERED_DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 0, -9, -9, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, -9, -9, -9, -1, -9, -9, -9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, -9, -9, -9, -9, 37, -9, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9};

    private static final byte[] getAlphabet(int n2) {
        if ((n2 & 0x10) == 16) {
            return _URL_SAFE_ALPHABET;
        }
        if ((n2 & 0x20) == 32) {
            return _ORDERED_ALPHABET;
        }
        return _STANDARD_ALPHABET;
    }

    private static final byte[] getDecodabet(int n2) {
        if ((n2 & 0x10) == 16) {
            return _URL_SAFE_DECODABET;
        }
        if ((n2 & 0x20) == 32) {
            return _ORDERED_DECODABET;
        }
        return _STANDARD_DECODABET;
    }

    private Base64() {
    }

    private static byte[] encode3to4(byte[] byArray, byte[] byArray2, int n2, int n3) {
        Base64.encode3to4(byArray2, 0, n2, byArray, 0, n3);
        return byArray;
    }

    private static byte[] encode3to4(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        byte[] byArray3 = Base64.getAlphabet(n5);
        int n6 = (n3 > 0 ? byArray[n2] << 24 >>> 8 : 0) | (n3 > 1 ? byArray[n2 + 1] << 24 >>> 16 : 0) | (n3 > 2 ? byArray[n2 + 2] << 24 >>> 24 : 0);
        switch (n3) {
            case 3: {
                byArray2[n4] = byArray3[n6 >>> 18];
                byArray2[n4 + 1] = byArray3[n6 >>> 12 & 0x3F];
                byArray2[n4 + 2] = byArray3[n6 >>> 6 & 0x3F];
                byArray2[n4 + 3] = byArray3[n6 & 0x3F];
                return byArray2;
            }
            case 2: {
                byArray2[n4] = byArray3[n6 >>> 18];
                byArray2[n4 + 1] = byArray3[n6 >>> 12 & 0x3F];
                byArray2[n4 + 2] = byArray3[n6 >>> 6 & 0x3F];
                byArray2[n4 + 3] = 61;
                return byArray2;
            }
            case 1: {
                byArray2[n4] = byArray3[n6 >>> 18];
                byArray2[n4 + 1] = byArray3[n6 >>> 12 & 0x3F];
                byArray2[n4 + 2] = 61;
                byArray2[n4 + 3] = 61;
                return byArray2;
            }
        }
        return byArray2;
    }

    public static void encode(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        byte[] byArray = new byte[3];
        byte[] byArray2 = new byte[4];
        while (byteBuffer.hasRemaining()) {
            int n2 = Math.min(3, byteBuffer.remaining());
            byteBuffer.get(byArray, 0, n2);
            Base64.encode3to4(byArray2, byArray, n2, 0);
            byteBuffer2.put(byArray2);
        }
    }

    public static void encode(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = new byte[3];
        byte[] byArray2 = new byte[4];
        while (byteBuffer.hasRemaining()) {
            int n2 = Math.min(3, byteBuffer.remaining());
            byteBuffer.get(byArray, 0, n2);
            Base64.encode3to4(byArray2, byArray, n2, 0);
            for (n2 = 0; n2 < 4; ++n2) {
                charBuffer.put((char)(byArray2[n2] & 0xFF));
            }
        }
    }

    public static String encodeObject(Serializable serializable) {
        return Base64.encodeObject(serializable, 0);
    }

    /*
     * Loose catch block
     */
    public static String encodeObject(Serializable serializable, int n2) {
        ByteArrayOutputStream byteArrayOutputStream;
        block25: {
            if (serializable == null) {
                throw new NullPointerException("Cannot serialize a null object.");
            }
            byteArrayOutputStream = null;
            OutputStream outputStream = null;
            DeflaterOutputStream deflaterOutputStream = null;
            ObjectOutputStream objectOutputStream = null;
            byteArrayOutputStream = new ByteArrayOutputStream();
            outputStream = new b(byteArrayOutputStream, 1 | n2);
            if ((n2 & 2) != 0) {
                deflaterOutputStream = new GZIPOutputStream(outputStream);
                objectOutputStream = new ObjectOutputStream(deflaterOutputStream);
            } else {
                objectOutputStream = new ObjectOutputStream(outputStream);
            }
            objectOutputStream.writeObject(serializable);
            try {
                objectOutputStream.close();
            }
            catch (Exception exception) {}
            try {
                deflaterOutputStream.close();
            }
            catch (Exception exception) {}
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {}
            break block25;
            catch (IOException iOException) {
                try {
                    serializable = iOException;
                    throw iOException;
                }
                catch (Throwable throwable) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (Exception exception) {}
                    try {
                        deflaterOutputStream.close();
                    }
                    catch (Exception exception) {}
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
            }
        }
        try {
            return new String(byteArrayOutputStream.toByteArray(), PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byteArrayOutputStream.toByteArray());
        }
    }

    public static String encodeBytes(byte[] byArray) {
        String string;
        block3: {
            string = null;
            try {
                string = Base64.encodeBytes(byArray, 0, byArray.length, 0);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)iOException.getMessage());
            }
        }
        assert (string != null);
        return string;
    }

    public static String encodeBytes(byte[] byArray, int n2) {
        return Base64.encodeBytes(byArray, 0, byArray.length, n2);
    }

    public static String encodeBytes(byte[] byArray, int n2, int n3) {
        String string;
        block3: {
            string = null;
            try {
                string = Base64.encodeBytes(byArray, n2, n3, 0);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)iOException.getMessage());
            }
        }
        assert (string != null);
        return string;
    }

    public static String encodeBytes(byte[] byArray, int n2, int n3, int n4) {
        byArray = Base64.encodeBytesToBytes(byArray, n2, n3, n4);
        try {
            return new String(byArray, PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    public static byte[] encodeBytesToBytes(byte[] byArray) {
        byte[] byArray2;
        block2: {
            byArray2 = null;
            try {
                byArray2 = Base64.encodeBytesToBytes(byArray, 0, byArray.length, 0);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)("IOExceptions only come from GZipping, which is turned off: " + iOException.getMessage()));
            }
        }
        return byArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encodeBytesToBytes(byte[] byArray, int n2, int n3, int n4) {
        int n6;
        if (byArray == null) {
            throw new NullPointerException("Cannot serialize a null array.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Cannot have negative offset: " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Cannot have length offset: " + n3);
        }
        if (n2 + n3 > byArray.length) {
            throw new IllegalArgumentException(String.format("Cannot have offset of %d and length of %d with array of length %d", n2, n3, byArray.length));
        }
        if ((n4 & 2) != 0) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            DeflaterOutputStream deflaterOutputStream = null;
            b b2 = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                b2 = new b(byteArrayOutputStream, 1 | n4);
                deflaterOutputStream = new GZIPOutputStream(b2);
                ((GZIPOutputStream)deflaterOutputStream).write(byArray, n2, n3);
                deflaterOutputStream.close();
            }
            catch (IOException iOException) {
                try {
                    IOException iOException2 = iOException;
                    throw iOException;
                }
                catch (Throwable throwable) {
                    try {
                        deflaterOutputStream.close();
                    }
                    catch (Exception exception) {}
                    try {
                        b2.close();
                    }
                    catch (Exception exception) {}
                    try {
                        byteArrayOutputStream.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
            }
            try {
                deflaterOutputStream.close();
            }
            catch (Exception exception) {}
            try {
                b2.close();
            }
            catch (Exception exception) {}
            try {
                byteArrayOutputStream.close();
                return byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                return byteArrayOutputStream.toByteArray();
            }
        }
        boolean bl = (n4 & 8) != 0;
        int n5 = (n3 / 3 << 2) + (n3 % 3 > 0 ? 4 : 0);
        if (bl) {
            n5 += n5 / 76;
        }
        byte[] byArray2 = new byte[n5];
        int n7 = 0;
        n5 = n3 - 2;
        int n8 = 0;
        for (n6 = 0; n6 < n5; n6 += 3, n7 += 4) {
            Base64.encode3to4(byArray, n6 + n2, 3, byArray2, n7, n4);
            if (!bl || (n8 += 4) < 76) continue;
            byArray2[n7 + 4] = 10;
            ++n7;
            n8 = 0;
        }
        if (n6 < n3) {
            Base64.encode3to4(byArray, n6 + n2, n3 - n6, byArray2, n7, n4);
            n7 += 4;
        }
        if (n7 > byArray2.length - 1) return byArray2;
        byArray = new byte[n7];
        System.arraycopy(byArray2, 0, byArray, 0, n7);
        return byArray;
    }

    private static int decode4to3(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        if (byArray == null) {
            throw new NullPointerException("Source array was null.");
        }
        if (byArray2 == null) {
            throw new NullPointerException("Destination array was null.");
        }
        if (n2 < 0 || n2 + 3 >= byArray.length) {
            throw new IllegalArgumentException(String.format("Source array with length %d cannot have offset of %d and still process four bytes.", byArray.length, n2));
        }
        if (n3 < 0 || n3 + 2 >= byArray2.length) {
            throw new IllegalArgumentException(String.format("Destination array with length %d cannot have offset of %d and still store three bytes.", byArray2.length, n3));
        }
        byte[] byArray3 = Base64.getDecodabet(n4);
        if (byArray[n2 + 2] == 61) {
            int n5 = (byArray3[byArray[n2]] & 0xFF) << 18 | (byArray3[byArray[n2 + 1]] & 0xFF) << 12;
            byArray2[n3] = (byte)(n5 >>> 16);
            return 1;
        }
        if (byArray[n2 + 3] == 61) {
            int n6 = (byArray3[byArray[n2]] & 0xFF) << 18 | (byArray3[byArray[n2 + 1]] & 0xFF) << 12 | (byArray3[byArray[n2 + 2]] & 0xFF) << 6;
            byArray2[n3] = (byte)(n6 >>> 16);
            byArray2[n3 + 1] = (byte)(n6 >>> 8);
            return 2;
        }
        int n7 = (byArray3[byArray[n2]] & 0xFF) << 18 | (byArray3[byArray[n2 + 1]] & 0xFF) << 12 | (byArray3[byArray[n2 + 2]] & 0xFF) << 6 | byArray3[byArray[n2 + 3]] & 0xFF;
        byArray2[n3] = (byte)(n7 >> 16);
        byArray2[n3 + 1] = (byte)(n7 >> 8);
        byArray2[n3 + 2] = (byte)n7;
        return 3;
    }

    public static byte[] decode(byte[] byArray) {
        byArray = Base64.decode(byArray, 0, byArray.length, 0);
        return byArray;
    }

    public static byte[] decode(byte[] byArray, int n2, int n3, int n4) {
        if (byArray == null) {
            throw new NullPointerException("Cannot decode null source array.");
        }
        if (n2 < 0 || n2 + n3 > byArray.length) {
            throw new IllegalArgumentException(String.format("Source array with length %d cannot have offset of %d and process %d bytes.", byArray.length, n2, n3));
        }
        if (n3 == 0) {
            return new byte[0];
        }
        if (n3 < 4) {
            throw new IllegalArgumentException("Base64-encoded string must have at least four characters, but length specified was " + n3);
        }
        byte[] byArray2 = Base64.getDecodabet(n4);
        int n5 = n3 * 3 / 4;
        byte[] byArray3 = new byte[n5];
        int n6 = 0;
        byte[] byArray4 = new byte[4];
        int n7 = 0;
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            byte by = byArray2[byArray[i2] & 0xFF];
            if (by >= -5) {
                if (by < -1) continue;
                byArray4[n7++] = byArray[i2];
                if (n7 <= 3) continue;
                n6 += Base64.decode4to3(byArray4, 0, byArray3, n6, n4);
                n7 = 0;
                if (byArray[i2] != 61) continue;
                break;
            }
            throw new IOException(String.format("Bad Base64 input character decimal %d in array position %d", byArray[i2] & 0xFF, i2));
        }
        byArray = new byte[n6];
        System.arraycopy(byArray3, 0, byArray, 0, n6);
        return byArray;
    }

    public static byte[] decode(String string) {
        return Base64.decode(string, 0);
    }

    /*
     * Loose catch block
     */
    public static byte[] decode(String string, int n2) {
        byte[] byArray;
        block27: {
            int n3;
            if (string == null) {
                throw new NullPointerException("Input string was null.");
            }
            try {
                byArray = string.getBytes(PREFERRED_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string.getBytes();
            }
            byArray = Base64.decode(byArray, 0, byArray.length, n2);
            int n4 = n3 = (n2 & 4) != 0 ? 1 : 0;
            if (byArray != null && byArray.length >= 4 && n3 == 0 && 35615 == (n3 = byArray[0] & 0xFF | byArray[1] << 8 & 0xFF00)) {
                int n5;
                ByteArrayInputStream byteArrayInputStream = null;
                GZIPInputStream gZIPInputStream = null;
                ByteArrayOutputStream byteArrayOutputStream = null;
                Object object = new byte[2048];
                byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
                while ((n5 = gZIPInputStream.read((byte[])object)) >= 0) {
                    byteArrayOutputStream.write((byte[])object, 0, n5);
                }
                byArray = byteArrayOutputStream.toByteArray();
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {}
                try {
                    gZIPInputStream.close();
                }
                catch (Exception exception) {}
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {}
                break block27;
                catch (IOException iOException) {
                    try {
                        object = iOException;
                        iOException.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Exception exception) {}
                        try {
                            gZIPInputStream.close();
                        }
                        catch (Exception exception) {}
                        try {
                            byteArrayInputStream.close();
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Exception exception) {}
                    try {
                        gZIPInputStream.close();
                    }
                    catch (Exception exception) {}
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return byArray;
    }

    public static Object decodeToObject(String string) {
        return Base64.decodeToObject(string, 0, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object decodeToObject(String object, int n2, ClassLoader classLoader) {
        object = Base64.decode((String)object, n2);
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            objectInputStream = classLoader == null ? new ObjectInputStream(byteArrayInputStream) : new com.captcha.botdetect.internal.infrastructure.util.a(byteArrayInputStream, classLoader);
            object = objectInputStream.readObject();
        }
        catch (IOException iOException) {
            try {
                object = iOException;
                throw iOException;
                catch (ClassNotFoundException classNotFoundException) {
                    object = classNotFoundException;
                    throw classNotFoundException;
                }
            }
            catch (Throwable throwable) {
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {}
                try {
                    objectInputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            byteArrayInputStream.close();
        }
        catch (Exception exception) {}
        try {
            objectInputStream.close();
            return object;
        }
        catch (Exception exception) {
            return object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encodeToFile(byte[] object, String string) {
        if (object == null) {
            throw new NullPointerException("Data to encode was null.");
        }
        b b2 = null;
        try {
            b2 = new b(new FileOutputStream(string), 1);
            b2.write((byte[])object);
        }
        catch (IOException iOException) {
            try {
                object = iOException;
                throw iOException;
            }
            catch (Throwable throwable) {
                try {
                    b2.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            b2.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decodeToFile(String object, String string) {
        b b2 = null;
        try {
            b2 = new b(new FileOutputStream(string), 0);
            b2.write(((String)object).getBytes(PREFERRED_ENCODING));
        }
        catch (IOException iOException) {
            try {
                object = iOException;
                throw iOException;
            }
            catch (Throwable throwable) {
                try {
                    b2.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            b2.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decodeFromFile(String object) {
        byte[] byArray;
        FilterInputStream filterInputStream = null;
        try {
            int n2;
            object = new File((String)object);
            int n3 = 0;
            if (((File)object).length() > Integer.MAX_VALUE) {
                throw new IOException("File is too big for this convenience method (" + ((File)object).length() + " bytes).");
            }
            byte[] byArray2 = new byte[(int)((File)object).length()];
            filterInputStream = new a(new BufferedInputStream(new FileInputStream((File)object)), 0);
            while ((n2 = ((a)filterInputStream).read(byArray2, n3, 4096)) >= 0) {
                n3 += n2;
            }
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
        }
        catch (IOException iOException) {
            try {
                object = iOException;
                throw iOException;
            }
            catch (Throwable throwable) {
                try {
                    filterInputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            filterInputStream.close();
            return byArray;
        }
        catch (Exception exception) {
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String encodeFromFile(String object) {
        String string;
        FilterInputStream filterInputStream = null;
        try {
            int n2;
            object = new File((String)object);
            byte[] byArray = new byte[Math.max((int)((double)((File)object).length() * 1.4 + 1.0), 40)];
            int n3 = 0;
            filterInputStream = new a(new BufferedInputStream(new FileInputStream((File)object)), 1);
            while ((n2 = ((a)filterInputStream).read(byArray, n3, 4096)) >= 0) {
                n3 += n2;
            }
            string = new String(byArray, 0, n3, PREFERRED_ENCODING);
        }
        catch (IOException iOException) {
            try {
                object = iOException;
                throw iOException;
            }
            catch (Throwable throwable) {
                try {
                    filterInputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            filterInputStream.close();
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encodeFileToFile(String object, String string) {
        object = Base64.encodeFromFile((String)object);
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(string));
            outputStream.write(((String)object).getBytes(PREFERRED_ENCODING));
        }
        catch (IOException iOException) {
            try {
                object = iOException;
                throw iOException;
            }
            catch (Throwable throwable) {
                try {
                    outputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            outputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decodeFileToFile(String object, String string) {
        object = Base64.decodeFromFile((String)object);
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(string));
            outputStream.write((byte[])object);
        }
        catch (IOException iOException) {
            try {
                object = iOException;
                throw iOException;
            }
            catch (Throwable throwable) {
                try {
                    outputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            outputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final class b
    extends FilterOutputStream {
        private boolean a;
        private int b;
        private byte[] c;
        private int d;
        private int e;
        private boolean f;
        private byte[] g;
        private boolean h;
        private int i;
        private byte[] j;

        private b(OutputStream outputStream) {
            this(outputStream, 1);
        }

        public b(OutputStream outputStream, int n2) {
            super(outputStream);
            this.f = (n2 & 8) != 0;
            this.a = (n2 & 1) != 0;
            this.d = this.a ? 3 : 4;
            this.c = new byte[this.d];
            this.b = 0;
            this.e = 0;
            this.h = false;
            this.g = new byte[4];
            this.i = n2;
            this.j = Base64.getDecodabet(n2);
        }

        public final void write(int n2) {
            if (this.h) {
                this.out.write(n2);
                return;
            }
            if (this.a) {
                this.c[this.b++] = (byte)n2;
                if (this.b >= this.d) {
                    this.out.write(Base64.encode3to4(this.g, this.c, this.d, this.i));
                    this.e += 4;
                    if (this.f && this.e >= 76) {
                        this.out.write(10);
                        this.e = 0;
                    }
                    this.b = 0;
                    return;
                }
            } else if (this.j[n2 & 0x7F] > -5) {
                this.c[this.b++] = (byte)n2;
                if (this.b >= this.d) {
                    n2 = Base64.decode4to3(this.c, 0, this.g, 0, this.i);
                    this.out.write(this.g, 0, n2);
                    this.b = 0;
                    return;
                }
            } else if (this.j[n2 & 0x7F] != -5) {
                throw new IOException("Invalid character in Base64 data.");
            }
        }

        public final void write(byte[] byArray, int n2, int n3) {
            if (this.h) {
                this.out.write(byArray, n2, n3);
                return;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                this.write(byArray[n2 + i2]);
            }
        }

        private void a() {
            if (this.b > 0) {
                if (this.a) {
                    this.out.write(Base64.encode3to4(this.g, this.c, this.b, this.i));
                    this.b = 0;
                    return;
                }
                throw new IOException("Base64 input not properly padded.");
            }
        }

        public final void close() {
            this.a();
            super.close();
            this.c = null;
            this.out = null;
        }

        private void b() {
            this.a();
            this.h = true;
        }

        private void c() {
            this.h = false;
        }
    }

    public static final class a
    extends FilterInputStream {
        private boolean a;
        private int b;
        private byte[] c;
        private int d;
        private int e;
        private int f;
        private boolean g;
        private int h;
        private byte[] i;

        private a(InputStream inputStream) {
            this(inputStream, 0);
        }

        public a(InputStream inputStream, int n2) {
            super(inputStream);
            this.h = n2;
            this.g = (n2 & 8) > 0;
            this.a = (n2 & 1) > 0;
            this.d = this.a ? 4 : 3;
            this.c = new byte[this.d];
            this.b = -1;
            this.f = 0;
            this.i = Base64.getDecodabet(n2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final int read() {
            if (this.b < 0) {
                byte[] byArray;
                if (this.a) {
                    int n2;
                    byArray = new byte[3];
                    int n3 = 0;
                    for (int i2 = 0; i2 < 3 && (n2 = this.in.read()) >= 0; ++i2) {
                        byArray[i2] = (byte)n2;
                        ++n3;
                    }
                    if (n3 <= 0) return -1;
                    Base64.encode3to4(byArray, 0, n3, this.c, 0, this.h);
                    this.b = 0;
                    this.e = 4;
                } else {
                    int n4;
                    byArray = new byte[4];
                    for (n4 = 0; n4 < 4; ++n4) {
                        int n5;
                        while ((n5 = this.in.read()) >= 0 && this.i[n5 & 0x7F] <= -5) {
                        }
                        if (n5 < 0) break;
                        byArray[n4] = (byte)n5;
                    }
                    if (n4 == 4) {
                        this.e = Base64.decode4to3(byArray, 0, this.c, 0, this.h);
                        this.b = 0;
                    } else {
                        if (n4 != 0) throw new IOException("Improperly padded Base64 input.");
                        return -1;
                    }
                }
            }
            if (this.b < 0) throw new IOException("Error in Base64 code reading stream.");
            if (this.b >= this.e) {
                return -1;
            }
            if (this.a && this.g && this.f >= 76) {
                this.f = 0;
                return 10;
            }
            ++this.f;
            byte by = this.c[this.b++];
            if (this.b < this.d) return by & 0xFF;
            this.b = -1;
            return by & 0xFF;
        }

        public final int read(byte[] byArray, int n2, int n3) {
            int n4;
            for (n4 = 0; n4 < n3; ++n4) {
                int n5 = this.read();
                if (n5 < 0) {
                    if (n4 != 0) break;
                    return -1;
                }
                byArray[n2 + n4] = (byte)n5;
            }
            return n4;
        }
    }
}

