/*
 * Decompiled with CFR 0.152.
 */
package com.captcha.botdetect.internal.core;

import com.captcha.botdetect.CaptchaRandomization;
import com.captcha.botdetect.CodeStyle;
import com.captcha.botdetect.HelpLinkMode;
import com.captcha.botdetect.ImageFormat;
import com.captcha.botdetect.ImageSize;
import com.captcha.botdetect.ImageStyle;
import com.captcha.botdetect.ServerHelper;
import com.captcha.botdetect.SoundFormat;
import com.captcha.botdetect.SoundRegenerationMode;
import com.captcha.botdetect.SoundStyle;
import com.captcha.botdetect.configuration.ICaptchaConfiguration;
import com.captcha.botdetect.internal.core.a.e;
import com.captcha.botdetect.internal.core.a.f;
import com.captcha.botdetect.internal.core.b.d;
import com.captcha.botdetect.internal.core.b.g;
import com.captcha.botdetect.internal.core.captchacode.Code;
import com.captcha.botdetect.internal.core.captchacode.CodeCollection;
import com.captcha.botdetect.internal.core.captchacode.CodeGenerationPurpose;
import com.captcha.botdetect.internal.core.captchacode.DisallowedCodeSubstrings;
import com.captcha.botdetect.internal.core.captchacode.b;
import com.captcha.botdetect.internal.core.captchacode.c;
import com.captcha.botdetect.internal.core.captchacode.validation.ValidationAttemptOrigin;
import com.captcha.botdetect.internal.infrastructure.d.b.a;
import com.captcha.botdetect.internal.support.CaptchaDefaults;
import com.captcha.botdetect.internal.support.i18n.Localization;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class CaptchaBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int HELP_LINK_HEIGHT = 10;
    private static int a = 5;
    public static final String VALID_CAPTCHA_ID = "^(\\w+)$";
    private ICaptchaConfiguration b;
    private String c;
    private CodeCollection d;
    private String e;
    private Integer f;
    private CodeStyle g;
    private int h;
    private DisallowedCodeSubstrings i;
    private List j;
    private ImageFormat k;
    private ImageSize l;
    private Color m;
    private Color n;
    private boolean o;
    private List p;
    private SoundFormat q;
    private SoundRegenerationMode r;
    private int s;
    private boolean t;
    private HelpLinkMode u;
    private Localization v;

    public CaptchaBase(String object, ICaptchaConfiguration iCaptchaConfiguration) {
        this.b = iCaptchaConfiguration;
        this.c = object;
        this.d = new CodeCollection();
        this.e = UUID.randomUUID().toString().replaceAll("-", "");
        this.f = iCaptchaConfiguration.getCodeLength();
        this.g = iCaptchaConfiguration.getCodeStyle();
        this.h = iCaptchaConfiguration.getCodeTimeout();
        this.i = DisallowedCodeSubstrings.a(iCaptchaConfiguration.getDisallowedCodeSubstrings());
        this.j = iCaptchaConfiguration.getImageStyle();
        this.k = iCaptchaConfiguration.getImageFormat();
        this.l = iCaptchaConfiguration.getImageSize();
        this.n = iCaptchaConfiguration.getCustomDarkColor();
        this.m = iCaptchaConfiguration.getCustomLightColor();
        this.o = iCaptchaConfiguration.isSoundEnabled();
        this.p = iCaptchaConfiguration.getSoundStyle();
        this.q = iCaptchaConfiguration.getSoundFormat();
        this.r = iCaptchaConfiguration.getSoundRegenerationMode();
        this.t = iCaptchaConfiguration.isHelpLinkEnabled();
        this.u = iCaptchaConfiguration.getHelpLinkMode();
        this.v = com.captcha.botdetect.internal.support.i18n.a.a(iCaptchaConfiguration.getLocale());
        object = this;
        ImageStyle.setDisabledStyles(((CaptchaBase)object).b.getDisabledImageStyles());
        SoundStyle.setDisabledStyles(((CaptchaBase)object).b.getDisabledSoundStyles());
    }

    public ICaptchaConfiguration getConfiguration() {
        return this.b;
    }

    public void setConfiguration(ICaptchaConfiguration iCaptchaConfiguration) {
        this.b = iCaptchaConfiguration;
    }

    public String getCaptchaId() {
        return this.c;
    }

    public CodeCollection getCodeCollection() {
        return this.d;
    }

    public void setCodeCollection(CodeCollection codeCollection) {
        this.d = codeCollection;
    }

    public void setCaptchaId(String string) {
        this.c = string;
    }

    public String getInstanceId() {
        return this.e;
    }

    public Integer getCodeLength() {
        if (this.f == null || this.f == 0) {
            return com.captcha.botdetect.internal.infrastructure.g.b.a(4, 7);
        }
        return this.f;
    }

    public void setCodeLength(int n2) {
        if (n2 > 0 && n2 <= 15 || n2 == 0) {
            this.f = n2;
        }
    }

    public Integer getCodeLengthNullable() {
        return this.f;
    }

    public void setCodeLengthNullable(Integer n2) {
        this.f = n2;
    }

    public CodeStyle getCodeStyle() {
        return this.g;
    }

    public void setCodeStyle(CodeStyle codeStyle) {
        this.g = codeStyle;
    }

    public int getCodeTimeout() {
        return this.h;
    }

    public void setCodeTimeout(int n2) {
        if (n2 >= 30 && n2 <= 7200) {
            this.h = n2;
        }
    }

    public void setDisallowedCodeSubstringsCsv(String string) {
        this.i = DisallowedCodeSubstrings.a(string);
    }

    public void setDisallowedCodeSubstringsList(List list) {
        this.i = DisallowedCodeSubstrings.a(list);
    }

    public DisallowedCodeSubstrings getDisallowedCodeSubstrings() {
        return this.i;
    }

    public void setDisallowedCodeSubstrings(DisallowedCodeSubstrings disallowedCodeSubstrings) {
        this.i = disallowedCodeSubstrings;
    }

    public List getImageStyle() {
        return this.j;
    }

    public void setImageStyle(List list) {
        this.j = list;
    }

    public ImageFormat getImageFormat() {
        return this.k;
    }

    public void setImageFormat(ImageFormat imageFormat) {
        this.k = imageFormat;
    }

    public ImageSize getImageSize() {
        return this.l;
    }

    public void setImageSize(ImageSize imageSize) {
        int n2 = this.l.getWidth();
        int n3 = this.l.getHeight();
        if (imageSize.getWidth() >= CaptchaDefaults.MIN_IMAGE_SIZE.getWidth() && imageSize.getWidth() <= CaptchaDefaults.MAX_IMAGE_SIZE.getWidth()) {
            n2 = imageSize.getWidth();
        }
        if (imageSize.getHeight() >= CaptchaDefaults.MIN_IMAGE_SIZE.getHeight() && imageSize.getHeight() <= CaptchaDefaults.MAX_IMAGE_SIZE.getHeight()) {
            n3 = imageSize.getHeight();
        }
        this.l = new ImageSize(n2, n3);
    }

    public Color getCustomLightColor() {
        return this.m;
    }

    public void setCustomLightColor(Color color) {
        this.m = color;
    }

    public Color getCustomDarkColor() {
        return this.n;
    }

    public void setCustomDarkColor(Color color) {
        this.n = color;
    }

    public boolean isSoundEnabled() {
        return this.o;
    }

    public void setSoundEnabled(boolean bl) {
        this.o = bl;
    }

    public List getSoundStyle() {
        return this.p;
    }

    public void setSoundStyle(List list) {
        this.p = list;
    }

    public SoundFormat getSoundFormat() {
        return this.q;
    }

    public void setSoundFormat(SoundFormat soundFormat) {
        this.q = soundFormat;
    }

    public int getSoundStartDelay() {
        return this.s;
    }

    public void setSoundStartDelay(int n2) {
        this.s = n2;
    }

    public SoundRegenerationMode getSoundRegenerationMode() {
        return this.r;
    }

    public void setSoundRegenerationMode(SoundRegenerationMode soundRegenerationMode) {
        this.r = soundRegenerationMode;
    }

    public String getLocale() {
        return this.v.toString();
    }

    public void setLocale(String string) {
        this.v = com.captcha.botdetect.internal.support.i18n.a.a(string);
        this.setSoundPackagesFolder();
    }

    public Localization getLocalization() {
        return this.v;
    }

    public void setLocalization(Localization localization) {
        this.v = localization;
        this.setSoundPackagesFolder();
    }

    public void setSoundPackagesFolder() {
        String string = this.b.getRealPath();
        String string2 = this.b.getSoundPackagesFolder();
        this.v.setSoundPackagesFolder(ServerHelper.resolvePhysicalFolderPath(string, string2));
    }

    public HelpLinkMode getHelpLinkMode() {
        return this.u;
    }

    public void setHelpLinkMode(HelpLinkMode helpLinkMode) {
        this.u = helpLinkMode;
    }

    public boolean isHelpLinkEnabled() {
        return this.t;
    }

    public void setHelpLinkEnabled(boolean bl) {
        this.t = bl;
    }

    public Code getCode(String object, CodeGenerationPurpose codeGenerationPurpose) {
        Code code;
        this.d.a(com.captcha.botdetect.internal.core.captchacode.b.a(this.v));
        this.d.a().a(this.i);
        if (this.b.isTestModeEnabled()) {
            code = new Code("TEST", this.h);
            code.b(codeGenerationPurpose);
            this.d.a((String)object, code);
        } else {
            code = this.d.a((String)object, codeGenerationPurpose, (object = this.g) != null ? com.captcha.botdetect.internal.core.captchacode.c.valueOf(((Enum)object).name()) : null, this.getCodeLength(), this.h);
        }
        if (code == null) {
            return null;
        }
        return code;
    }

    public ByteArrayOutputStream getImage(String object) {
        object = this.getCode((String)object, CodeGenerationPurpose.IMAGE_GENERATION);
        Object object2 = this.l;
        if (this.u.equals((Object)HelpLinkMode.TEXT)) {
            object2 = new ImageSize(object2.getWidth(), object2.getHeight() - 10);
        }
        Object object3 = this.j;
        object3.removeAll(ImageStyle.getLicenceRestrictedStyles());
        object3 = object3.isEmpty() ? CaptchaRandomization.getRandomImageStyle() : CaptchaRandomization.getRandomImageStyle(object3);
        Serializable serializable = null;
        if (this.m != null) {
            serializable = new a(this.m);
        }
        Object object4 = null;
        if (this.n != null) {
            object4 = new a(this.n);
        }
        String string = ((Code)object).a();
        object = object3;
        f f2 = object != null ? com.captcha.botdetect.internal.core.a.f.valueOf(((Enum)object).name()) : null;
        object = object2;
        com.captcha.botdetect.internal.infrastructure.d.e e2 = new com.captcha.botdetect.internal.infrastructure.d.e(((ImageSize)object).getWidth(), ((ImageSize)object).getHeight());
        object = this.k;
        a a2 = object4;
        a a3 = serializable;
        object4 = object != null ? com.captcha.botdetect.internal.infrastructure.d.d.valueOf(((Enum)object).name()) : null;
        serializable = e2;
        object3 = this.v;
        object2 = f2;
        object = string;
        object2 = com.captcha.botdetect.internal.core.a.e.a((f)((Object)object2));
        object = object2.a((String)object, (Localization)object3, (com.captcha.botdetect.internal.infrastructure.d.e)serializable, a3, a2);
        object = object.a((com.captcha.botdetect.internal.infrastructure.d.d)((Object)object4));
        return object;
    }

    public ByteArrayOutputStream getSound(String object) {
        if (!this.o) {
            return null;
        }
        if (this.b.isTestModeEnabled()) {
            return com.captcha.botdetect.internal.core.b.d.b(CaptchaBase.a(this.q));
        }
        if ((object = this.getCode((String)object, CodeGenerationPurpose.SOUND_GENERATION)) == null) {
            return null;
        }
        if (!((Code)object).b()) {
            return null;
        }
        if (SoundRegenerationMode.NONE == this.r ? ((Code)object).c() > 1 : SoundRegenerationMode.LIMITED == this.r && ((Code)object).c() > 5) {
            return null;
        }
        Object object2 = this.p;
        object2.removeAll(SoundStyle.getLicenceRestrictedStyles());
        object2 = object2.isEmpty() ? CaptchaRandomization.getRandomSoundStyle() : CaptchaRandomization.getRandomSoundStyle(object2);
        String string = ((Code)object).a();
        object = object2;
        com.captcha.botdetect.internal.infrastructure.a.f f2 = CaptchaBase.a(this.q);
        Localization localization = this.v;
        object2 = object != null ? com.captcha.botdetect.internal.core.b.g.valueOf(((Enum)object).name()) : null;
        object = string;
        int n2 = string.hashCode() % 2;
        object = n2 == 0 ? com.captcha.botdetect.internal.core.b.d.a(f2) : com.captcha.botdetect.internal.core.b.d.b((String)object, (g)((Object)object2), localization, f2);
        return object;
    }

    public boolean validate(String string, String string2, ValidationAttemptOrigin validationAttemptOrigin) {
        boolean bl = this.d.a(string, string2, validationAttemptOrigin);
        return bl;
    }

    private static com.captcha.botdetect.internal.infrastructure.d.e a(ImageSize imageSize) {
        return new com.captcha.botdetect.internal.infrastructure.d.e(imageSize.getWidth(), imageSize.getHeight());
    }

    private static c a(CodeStyle codeStyle) {
        if (codeStyle != null) {
            return com.captcha.botdetect.internal.core.captchacode.c.valueOf(codeStyle.name());
        }
        return null;
    }

    private static f a(ImageStyle imageStyle) {
        if (imageStyle != null) {
            return com.captcha.botdetect.internal.core.a.f.valueOf(imageStyle.name());
        }
        return null;
    }

    private static g a(SoundStyle soundStyle) {
        if (soundStyle != null) {
            return com.captcha.botdetect.internal.core.b.g.valueOf(soundStyle.name());
        }
        return null;
    }

    private static com.captcha.botdetect.internal.infrastructure.d.d a(ImageFormat imageFormat) {
        if (imageFormat != null) {
            return com.captcha.botdetect.internal.infrastructure.d.d.valueOf(imageFormat.name());
        }
        return null;
    }

    private static com.captcha.botdetect.internal.infrastructure.a.f a(SoundFormat soundFormat) {
        if (soundFormat != null) {
            return com.captcha.botdetect.internal.infrastructure.a.f.valueOf(soundFormat.name());
        }
        return null;
    }

    private void a() {
        ImageStyle.setDisabledStyles(this.b.getDisabledImageStyles());
        SoundStyle.setDisabledStyles(this.b.getDisabledSoundStyles());
    }

    public static Map getProductInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", "BotDetect Java Captcha Library");
        hashMap.put("version", CaptchaBase.class.getPackage().getImplementationVersion());
        return hashMap;
    }
}

