/*
 * Decompiled with CFR 0.152.
 */
package com.captcha.botdetect;

import java.util.ArrayList;
import java.util.List;

public enum ImageStyle {
    ANCIENT_MOSAIC,
    BLACK_OVERLAP,
    BUBBLES,
    BULLETS,
    BULLETS2,
    CAUGHT_IN_THE_NET,
    CAUGHT_IN_THE_NET2,
    CHALKBOARD,
    CHESS,
    CHESS3D,
    CHIPPED,
    CIRCLES,
    COLLAGE,
    CORROSION,
    CROSS_SHADOW,
    CROSS_SHADOW2,
    CUT,
    DARTS,
    DISTORTION,
    ELECTRIC,
    FINGERPRINTS,
    FLASH,
    GHOSTLY,
    GRAFFITI,
    GRAFFITI2,
    HALO,
    IN_BANDAGES,
    JAIL,
    LEGO,
    MASS,
    MELTING_HEAT,
    MELTING_HEAT2,
    NEGATIVE,
    NEON,
    NEON2,
    OVERLAP,
    OVERLAP2,
    PAINT_MESS,
    RADAR,
    RIPPLE,
    RIPPLE2,
    ROUGH,
    SNOW,
    SPIDER_WEB,
    SPIDER_WEB2,
    SPLIT,
    SPLIT2,
    STITCH,
    STRIPPY,
    SUN_AND_WARM_AIR,
    SUNRAYS,
    SUNRAYS2,
    THICK_THIN_LINES,
    THICK_THIN_LINES2,
    THIN_WAVY_LETTERS,
    VERTIGO,
    WANTED_CIRCULAR,
    WAVE,
    WAVY_CHESS,
    WAVY_COLOR_LETTERS;

    private static List disabledStyles;

    public static ImageStyle parseString(String string) {
        if (string != null) {
            for (ImageStyle imageStyle : ImageStyle.values()) {
                if (!string.equalsIgnoreCase(imageStyle.name())) continue;
                return imageStyle;
            }
        }
        return null;
    }

    public static List parseCommaDelimitedString(String stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = stringArray.split(",");
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = stringArray[i2];
            if ((object = ImageStyle.parseString(object.trim())) == null) continue;
            arrayList.add((String)object);
        }
        return arrayList;
    }

    public static ImageStyle valueOf(int n2) {
        for (ImageStyle imageStyle : ImageStyle.values()) {
            if (imageStyle.ordinal() != n2) continue;
            return imageStyle;
        }
        return null;
    }

    public static List getLicenceRestrictedStyles() {
        ArrayList<ImageStyle> arrayList = new ArrayList<ImageStyle>();
        arrayList.add(BUBBLES);
        arrayList.add(ELECTRIC);
        arrayList.add(GHOSTLY);
        arrayList.add(NEON);
        arrayList.add(NEON2);
        arrayList.add(RADAR);
        arrayList.add(RIPPLE);
        arrayList.add(RIPPLE2);
        arrayList.add(STRIPPY);
        arrayList.add(WAVE);
        return arrayList;
    }

    public static List getDisabledStyles() {
        return disabledStyles;
    }

    public static void setDisabledStyles(List list) {
        disabledStyles = list;
    }
}

