/*
 * Decompiled with CFR 0.152.
 */
package point.mile.common.util;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.StringTokenizer;
import point.mile.common.util.LocaleToCharsetMap;

public class FormatUtil {
    public static SimpleDateFormat checkSdf = null;
    public static final String CHECK_DATE_FORMAT = "yyyyMMdd";
    public static final String DASH = "-";
    public static final String SLASH = "/";

    public static String getCheckDate(String _str) {
        checkSdf = new SimpleDateFormat(CHECK_DATE_FORMAT);
        String newStr = FormatUtil.getherDigit(_str);
        if (newStr != null && newStr.length() == 8) {
            Calendar cal = Calendar.getInstance();
            cal.set(Integer.parseInt(newStr.substring(0, 4)), Integer.parseInt(newStr.substring(4, 6)) - 1, Integer.parseInt(newStr.substring(6, 8)));
            if (checkSdf.format(cal.getTime()).equals(newStr)) {
                return _str;
            }
        }
        return "0";
    }

    public static boolean checkDate(String _str) {
        checkSdf = new SimpleDateFormat(CHECK_DATE_FORMAT);
        String newStr = FormatUtil.getherDigit(_str);
        if (newStr != null && newStr.length() == 8) {
            Calendar cal = Calendar.getInstance();
            cal.set(Integer.parseInt(newStr.substring(0, 4)), Integer.parseInt(newStr.substring(4, 6)) - 1, Integer.parseInt(newStr.substring(6, 8)));
            if (checkSdf.format(cal.getTime()).equals(newStr)) {
                return true;
            }
        }
        return false;
    }

    public static String getherDigit(String _digitStr) {
        String returnStr = "";
        if (_digitStr != null) {
            _digitStr = _digitStr.trim();
            int i = 0;
            while (i < _digitStr.length()) {
                if (Character.isDigit(_digitStr.charAt(i))) {
                    returnStr = String.valueOf(returnStr) + _digitStr.charAt(i);
                }
                ++i;
            }
        }
        return returnStr;
    }

    public static String toHtmlChr(String _value) {
        try {
            if (_value.indexOf(38) != -1 || _value.indexOf(60) != -1 || _value.indexOf(62) != -1 || _value.indexOf(39) != -1 || _value.indexOf(34) != -1 || _value.indexOf(10) != -1) {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                int j = _value.length();
                while (i < j) {
                    char c = _value.charAt(i);
                    if (c == '&') {
                        sb.append("&amp;");
                    } else if (c == '<') {
                        sb.append("&lt;");
                    } else if (c == '>') {
                        sb.append("&gt;");
                    } else if (c == '\'') {
                        sb.append("\\'");
                    } else if (c == '\"') {
                        sb.append("&quot;");
                    } else if (c == '\\') {
                        sb.append("\\\\");
                    } else if (c == '\n') {
                        sb.append("<br>");
                    } else {
                        sb.append(c);
                    }
                    ++i;
                }
                return sb.toString();
            }
            return _value;
        }
        catch (Exception ex) {
            return _value;
        }
    }

    public static Date getSqlDateFormat(String s) {
        try {
            return Date.valueOf(s);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getCommaStr(String value) {
        if (value != null) {
            String temp;
            DecimalFormat df = new DecimalFormat("#,###.###");
            try {
                temp = df.format(new Double(value));
            }
            catch (NumberFormatException e) {
                temp = "";
            }
            return temp;
        }
        return "";
    }

    public static String getSaupStr(String value) {
        if (value != null) {
            try {
                return new String(String.valueOf(value.substring(0, 3)) + DASH + value.substring(3, 5) + DASH + value.substring(5, 10));
            }
            catch (Exception ex) {
                return value;
            }
        }
        return "";
    }

    public static String getBRStr(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        StringTokenizer st = new StringTokenizer(str.toString(), "\n");
        while (st.hasMoreTokens()) {
            out.append(String.valueOf(st.nextToken()) + "<br>");
        }
        return out.toString();
    }

    public static String getReplaceStr(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        StringTokenizer st = new StringTokenizer(str.toString(), "\n");
        while (st.hasMoreTokens()) {
            out.append(String.valueOf(st.nextToken()) + ", ");
        }
        return out.toString();
    }

    public static String getReplaceStr(String str, String oldChar, String newChar) {
        if (str == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        StringTokenizer st = new StringTokenizer(str.toString(), oldChar);
        while (st.hasMoreTokens()) {
            out.append(String.valueOf(st.nextToken()) + newChar);
        }
        return out.toString();
    }

    public static String getCommaStr(int value) {
        String temp;
        DecimalFormat df = new DecimalFormat("#,###.###");
        try {
            temp = df.format(new Integer(value));
        }
        catch (NumberFormatException e) {
            temp = "";
        }
        return temp;
    }

    public static String getCommaStr(long value) {
        String temp;
        DecimalFormat df = new DecimalFormat("#,###.###");
        try {
            temp = df.format(new Long(value));
        }
        catch (NumberFormatException e) {
            temp = "";
        }
        return temp;
    }

    public static String getCommaStr(float value) {
        String temp;
        DecimalFormat df = new DecimalFormat("#,###.###");
        try {
            temp = df.format(new Float(value));
        }
        catch (NumberFormatException e) {
            temp = "";
        }
        return temp;
    }

    public static String getCommaStr(double value) {
        String temp;
        DecimalFormat df = new DecimalFormat("#,###.###");
        try {
            temp = df.format(new Double(value));
        }
        catch (NumberFormatException e) {
            temp = "";
        }
        return temp;
    }

    public static String getCommaStr2(double value) {
        String temp;
        DecimalFormat df = new DecimalFormat("#,###.#");
        try {
            temp = df.format(new Double(value));
        }
        catch (NumberFormatException e) {
            temp = "";
        }
        return temp;
    }

    public static String getTrim(String value) {
        if (value != null) {
            return value.trim();
        }
        return "";
    }

    public static String uniToLocal(String unicode) {
        if (unicode == null) {
            return null;
        }
        String returnStr = null;
        try {
            returnStr = new String(unicode.getBytes("8859_1"), LocaleToCharsetMap.getCharset(new Locale(FormatUtil.getLanguage(), FormatUtil.getCountry())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnStr;
    }

    private static String getLanguage() {
        String locale = "ko_KR";
        StringTokenizer st = new StringTokenizer(locale, "_");
        return st.nextToken();
    }

    private static String getCountry() {
        String locale = "ko_KR";
        StringTokenizer st = new StringTokenizer(locale, "_");
        st.nextToken();
        return st.nextToken();
    }

    public static String deleteChar(String source, String deleteStr) {
        if (source == null || source.equals("")) {
            return source;
        }
        StringBuffer temp = new StringBuffer("");
        StringTokenizer st = new StringTokenizer(source, deleteStr);
        while (st.hasMoreTokens()) {
            temp.append(st.nextToken());
        }
        return temp.toString();
    }

    public static String deleteDot(String value) {
        return FormatUtil.deleteChar(value, ".");
    }

    public static String deleteComma(String value) {
        return FormatUtil.deleteChar(value, ",");
    }

    public static String deleteSlash(String value) {
        return FormatUtil.deleteChar(value, SLASH);
    }

    public static String deleteDash(String value) {
        return FormatUtil.deleteChar(value, DASH);
    }

    public static String getPostCodeStr(String value) {
        try {
            return new String(String.valueOf(value.substring(0, 3)) + DASH + value.substring(3, 6));
        }
        catch (Exception ex) {
            return value;
        }
    }

    public static String getCurrencySymbol() {
        DecimalFormatSymbols d = new DecimalFormatSymbols(new Locale(FormatUtil.getLanguage(), FormatUtil.getCountry()));
        return d.getCurrencySymbol();
    }

    public static String dateToStr(Date date) {
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(CHECK_DATE_FORMAT);
            return df.format(date);
        }
        return "";
    }

    public static String getYear(Date date) {
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy");
            return df.format(date);
        }
        return "";
    }

    public static Date StrToDate(String str) {
        if (str != null) {
            return Date.valueOf(str);
        }
        return null;
    }

    public static String uni12To20(String uni12) {
        if (uni12 == null) {
            return null;
        }
        int len = uni12.length();
        char[] out = new char[len];
        byte[] ksc = new byte[2];
        int i = 0;
        while (i < len) {
            char c = uni12.charAt(i);
            if (c < '\u3400' || '\u4dff' < c) {
                out[i] = c;
            } else if ('\u3d2e' <= c) {
                out[i] = 65533;
            } else {
                try {
                    ksc[0] = (byte)((c - 13312) / 94 + 176);
                    ksc[1] = (byte)((c - 13312) % 94 + 161);
                    out[i] = new String(ksc, "KSC5601").charAt(0);
                }
                catch (Exception ex) {
                    return null;
                }
            }
            ++i;
        }
        return new String(out);
    }

    public static String uni20To12(String uni20) {
        if (uni20 == null) {
            return "";
        }
        int len = uni20.length();
        char[] out = new char[len];
        int i = 0;
        while (i < len) {
            char c = uni20.charAt(i);
            if (c < '\uac00' || '\ud7a3' < c) {
                out[i] = c;
            } else {
                try {
                    byte[] ksc = String.valueOf(c).getBytes("KSC5601");
                    out[i] = ksc.length != 2 ? 65533 : (char)(13312 + ((ksc[0] & 0xFF) - 176) * 94 + (ksc[1] & 0xFF) - 161);
                }
                catch (UnsupportedEncodingException ex) {
                    ex.printStackTrace();
                }
            }
            ++i;
        }
        return new String(out);
    }

    public static String convJS(Object pObject) {
        if (pObject == null) {
            return "";
        }
        String value = (String)pObject;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\\': {
                    buffer.append("\\\\");
                    break;
                }
                case '\'': {
                    buffer.append("\\'");
                    break;
                }
                case '\"': {
                    buffer.append("\\\"");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String[] getDivTelephoneNumber(String oriTelephoneNumber) {
        String[] divPhoneNumber = new String[]{"", "", ""};
        if (oriTelephoneNumber == null || oriTelephoneNumber.equals("")) {
            return divPhoneNumber;
        }
        if (oriTelephoneNumber.length() < 9) {
            return divPhoneNumber;
        }
        if (oriTelephoneNumber.startsWith("02")) {
            divPhoneNumber[0] = "02";
            divPhoneNumber[1] = oriTelephoneNumber.substring(2, oriTelephoneNumber.length() - 4);
            divPhoneNumber[2] = oriTelephoneNumber.substring(oriTelephoneNumber.length() - 4, oriTelephoneNumber.length());
        } else {
            divPhoneNumber[0] = oriTelephoneNumber.substring(0, 3);
            divPhoneNumber[1] = oriTelephoneNumber.substring(3, oriTelephoneNumber.length() - 4);
            divPhoneNumber[2] = oriTelephoneNumber.substring(oriTelephoneNumber.length() - 4, oriTelephoneNumber.length());
        }
        return divPhoneNumber;
    }

    public static String[] getDivBizNubmer(String oriBizNubmer) {
        String[] divOriNumber = new String[]{"", "", ""};
        if (oriBizNubmer == null || oriBizNubmer.equals("")) {
            return divOriNumber;
        }
        if (oriBizNubmer.length() != 10) {
            return divOriNumber;
        }
        divOriNumber[0] = oriBizNubmer.substring(0, 3);
        divOriNumber[1] = oriBizNubmer.substring(3, 5);
        divOriNumber[2] = oriBizNubmer.substring(5, 10);
        return divOriNumber;
    }

    public static String[] getDivEMailAddress(String oriEMail) {
        String[] divOriNumber = new String[]{"", ""};
        if (oriEMail == null || oriEMail.indexOf("@") < 0) {
            return divOriNumber;
        }
        divOriNumber[0] = oriEMail.substring(0, oriEMail.indexOf("@"));
        divOriNumber[1] = oriEMail.substring(oriEMail.indexOf("@") + 1, oriEMail.length());
        return divOriNumber;
    }

    public static String[] getDivJuminNubmer(String oriJuminNubmer) {
        String[] divJuminNubmer = new String[]{"", ""};
        if (oriJuminNubmer == null || oriJuminNubmer.equals("")) {
            return divJuminNubmer;
        }
        if (oriJuminNubmer.length() != 13) {
            return divJuminNubmer;
        }
        divJuminNubmer[0] = oriJuminNubmer.substring(0, 6);
        divJuminNubmer[1] = oriJuminNubmer.substring(6, 13);
        return divJuminNubmer;
    }

    public static String[] getDivZipNubmer(String oriZipNubmer) {
        String[] divZipNubmer = new String[]{"", ""};
        if (oriZipNubmer == null || oriZipNubmer.equals("")) {
            return divZipNubmer;
        }
        if (oriZipNubmer.length() != 6) {
            return divZipNubmer;
        }
        divZipNubmer[0] = oriZipNubmer.substring(0, 3);
        divZipNubmer[1] = oriZipNubmer.substring(3, 6);
        return divZipNubmer;
    }

    public static void main(String[] args) {
        System.out.println("A1");
    }

    public static String chkNull(Object obj) {
        return obj != null ? (String)obj : "";
    }

    public static String chkNumber(Object obj) {
        return obj != null ? (String)obj : "0";
    }

    public static String[] getStrArray(String str, String tokenStr) {
        if (str == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(str.toString(), tokenStr);
        String[] data = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            data[i] = st.nextToken();
            ++i;
        }
        return data;
    }

    public static double round(double r, int decimalPlace) {
        BigDecimal bd = new BigDecimal(r);
        bd = bd.setScale(decimalPlace, 4);
        r = bd.doubleValue();
        return r;
    }

    public static float round(float r, int decimalPlace) {
        BigDecimal bd = new BigDecimal(r);
        bd = bd.setScale(decimalPlace, 4);
        r = bd.floatValue();
        return r;
    }

    public static String shortCutString(String str, int limit) {
        if (str == null || limit < 4) {
            return str;
        }
        int len = str.length();
        int cnt = 0;
        int index = 0;
        while (index < len && cnt < limit) {
            if (str.charAt(index++) < '\u0100') {
                ++cnt;
                continue;
            }
            cnt += 2;
        }
        if (index < len && limit >= cnt) {
            str = str.substring(0, index);
        } else if (index < len && limit < cnt) {
            str = String.valueOf(str.substring(0, index - 1)) + "..";
        }
        return str;
    }
}

