/*
 * Decompiled with CFR 0.152.
 */
package point.mile.common.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import point.mile.common.util.FormatUtil;

public class DateUtil {
    public static SimpleDateFormat dateSqlFormat = new SimpleDateFormat("yyyy.MM.dd");
    public static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");

    public static int betweenDate(String from, String to) {
        if (from == null) {
            throw new IllegalArgumentException("from can not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("to can not be null");
        }
        int len = from.length();
        if (len != 8 && len != 14) {
            throw new IllegalArgumentException("from length must be 8 or 14 (yyyyMMdd or yyyyMMddHHmmss)");
        }
        if (len == 8) {
            from = String.valueOf(from) + "000000";
        }
        if ((len = to.length()) != 8 && len != 14) {
            throw new IllegalArgumentException("to length must be 8 or 14 (yyyyMMdd or yyyyMMddHHmmss)");
        }
        if (len == 8) {
            to = String.valueOf(to) + "000000";
        }
        return DateUtil.betweenDate(DateUtil.getUtilDate(from), DateUtil.getUtilDate(to));
    }

    public static Date getUtilDate(String dt) {
        Calendar cal = Calendar.getInstance();
        cal.set(Integer.parseInt(dt.substring(0, 4)), Integer.parseInt(dt.substring(4, 6)) - 1, Integer.parseInt(dt.substring(6, 8)), Integer.parseInt(dt.substring(8, 10)), Integer.parseInt(dt.substring(10, 12)), Integer.parseInt(dt.substring(12, 14)));
        return cal.getTime();
    }

    public static int betweenDate(Date from, Date to) {
        return new Long((to.getTime() - from.getTime()) / 86400000L).intValue();
    }

    public static String getCurrentTime() {
        SimpleDateFormat df = new SimpleDateFormat("hhmmss");
        return df.format(new Date(System.currentTimeMillis()));
    }

    public static Date getDate(String yyyymmdd) {
        if (yyyymmdd != null && yyyymmdd.length() == 8 && DateUtil.isDigit(yyyymmdd)) {
            Calendar cal = Calendar.getInstance();
            cal.set(Integer.parseInt(yyyymmdd.substring(0, 4)), Integer.parseInt(yyyymmdd.substring(4, 6)) - 1, Integer.parseInt(yyyymmdd.substring(6, 8)));
            return cal.getTime();
        }
        return null;
    }

    public static Date getDateYYYYMM(String yyyymm) {
        if (yyyymm != null && yyyymm.length() == 6 && DateUtil.isDigit(yyyymm)) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, Integer.parseInt(yyyymm.substring(0, 4)));
            cal.set(2, Integer.parseInt(yyyymm.substring(4, 6)) - 1);
            return cal.getTime();
        }
        return null;
    }

    public static Date getDateWithDelimiter(String yyyymmdd) {
        return DateUtil.getDateWithDelimiter(yyyymmdd, '\u0000');
    }

    public static Date getDateWithDelimiterYYYYMM(String yyyymm) {
        return DateUtil.getDateWithDelimiterYYYYMM(yyyymm, '\u0000');
    }

    public static Date getDateWithDelimiter(String yyyymmdd, char delimiter) {
        if (yyyymmdd != null && !yyyymmdd.equals("")) {
            String temp;
            StringTokenizer st = new StringTokenizer(yyyymmdd, String.valueOf(String.valueOf(delimiter)) + "/.-");
            String yyyy = st.nextToken();
            String mm = st.nextToken();
            String dd = st.nextToken();
            if (mm.length() < 2) {
                mm = "0" + mm;
            }
            if (dd.length() < 2) {
                dd = "0" + dd;
            }
            if (DateUtil.isDigit(temp = String.valueOf(yyyy) + mm + dd)) {
                return DateUtil.getDate(temp);
            }
        }
        return null;
    }

    public static Date getDateWithDelimiterYYYYMM(String yyyymm, char delimiter) {
        if (yyyymm != null && !yyyymm.equals("")) {
            String temp;
            StringTokenizer st = new StringTokenizer(yyyymm, String.valueOf(String.valueOf(delimiter)) + "/.-");
            String yyyy = st.nextToken();
            String mm = st.nextToken();
            if (mm.length() < 2) {
                mm = "0" + mm;
            }
            if (DateUtil.isDigit(temp = String.valueOf(yyyy) + mm)) {
                return DateUtil.getDateYYYYMM(temp);
            }
        }
        return null;
    }

    public static String getDateStr(Date date, char delimiter) {
        return DateUtil.getDateStr(date, String.valueOf(delimiter));
    }

    public static String getDateStr(Date date, String delimiter) {
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy" + delimiter + "MM" + delimiter + "dd");
            return df.format(date);
        }
        return null;
    }

    public static String getDateStr(Date date) {
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            return df.format(date);
        }
        return null;
    }

    public static String toDBFormat(String _displayDate) {
        if (_displayDate == null) {
            return null;
        }
        if (_displayDate.length() == 10) {
            return String.valueOf(_displayDate.substring(0, 4)) + _displayDate.substring(5, 7) + _displayDate.substring(8);
        }
        if (_displayDate.length() == 7) {
            return String.valueOf(_displayDate.substring(0, 4)) + _displayDate.substring(5, 7);
        }
        return _displayDate;
    }

    public static String getCurrentMonthOnly() {
        int month = DateUtil.getMonth(DateUtil.getCurrentDate());
        String result = "";
        result = month < 10 ? "0" + month : Integer.toString(month);
        return result;
    }

    public static int getMonth(String date) {
        date = FormatUtil.deleteSlash(date);
        date = FormatUtil.deleteDash(date);
        return Integer.parseInt(date.substring(4, 6));
    }

    public static String getMonthString(String date) {
        date = FormatUtil.deleteSlash(date);
        date = FormatUtil.deleteDash(date);
        return date.substring(4, 6);
    }

    public static int getYear(String date) {
        date = FormatUtil.deleteSlash(date);
        date = FormatUtil.deleteDash(date);
        return Integer.parseInt(date.substring(0, 4));
    }

    public static String getDateStrWeekly(Date date, char delimiter) {
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat("(E)MM" + delimiter + "dd");
            return df.format(date);
        }
        return null;
    }

    public static String getDateStrWithMMDD(Date date) {
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat("MMdd");
            return df.format(date);
        }
        return null;
    }

    public static String getDateStrYYYYMM(Date date, char delimiter) {
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy" + delimiter + "MM");
            return df.format(date);
        }
        return null;
    }

    public static String getDateStrYYYY(Date date) {
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy");
            return df.format(date);
        }
        return null;
    }

    public static Date getTime(String hhmm) {
        if (hhmm != null && hhmm.length() == 4 && DateUtil.isDigit(hhmm)) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, Integer.parseInt(hhmm.substring(0, 2)));
            cal.set(12, Integer.parseInt(hhmm.substring(2, 4)));
            return cal.getTime();
        }
        return null;
    }

    public static Date getTimeWithDelimiter(String hhmm) {
        return DateUtil.getTimeWithDelimiter(hhmm, '\u0000');
    }

    public static Date getTimeWithDelimiter(String hhmm, char delimiter) {
        if (hhmm != null) {
            String temp;
            StringTokenizer st = new StringTokenizer(hhmm, String.valueOf(String.valueOf(delimiter)) + ":-");
            String hh = st.nextToken();
            String mm = st.nextToken();
            if (hh.length() < 2) {
                hh = "0" + hh;
            }
            if (mm.length() < 2) {
                mm = "0" + mm;
            }
            if (DateUtil.isDigit(temp = String.valueOf(hh) + mm)) {
                return DateUtil.getTime(temp);
            }
        }
        return null;
    }

    public static String getTimeStr(Date date, char delimiter) {
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat("HH" + delimiter + "mm");
            return df.format(date);
        }
        return null;
    }

    private static boolean isDigit(String digitStr) {
        if (digitStr != null) {
            int i = 0;
            while (i < digitStr.length()) {
                if (!Character.isDigit(digitStr.charAt(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static String getCurrentDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd");
        return df.format(new Date(System.currentTimeMillis()));
    }

    public static String getCurrentYearMonth() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM");
        return df.format(new Date(System.currentTimeMillis()));
    }

    public static String getCurrentYear() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy");
        return df.format(new Date(System.currentTimeMillis()));
    }

    public static ArrayList listWeeklyDate(String dateStr) {
        Date searchDate = DateUtil.getDateWithDelimiter(dateStr);
        Calendar cal = Calendar.getInstance();
        cal.setTime(searchDate);
        int t = cal.get(7);
        cal.add(5, -(t - 1));
        Date start = cal.getTime();
        cal.add(5, 6);
        Date end = cal.getTime();
        ArrayList<String> dateList = new ArrayList<String>();
        while (start.getTime() <= end.getTime()) {
            dateList.add(DateUtil.getDateStr(start, "."));
            cal.setTime(start);
            cal.add(5, 1);
            start = cal.getTime();
        }
        return dateList;
    }

    public static ArrayList listMonthlyDate(String dateStr) {
        ArrayList row = new ArrayList();
        ArrayList<Object> col = null;
        Date searchDate = DateUtil.getDateWithDelimiter(dateStr);
        Calendar cal = Calendar.getInstance();
        cal.setTime(searchDate);
        cal.set(5, 1);
        int firstWeek = cal.get(7);
        int endDay = cal.getActualMaximum(5);
        col = new ArrayList<Object>();
        int i = 0;
        i = 1;
        while (i < firstWeek) {
            col.add("");
            ++i;
        }
        i = 1;
        while (i <= 7 - (firstWeek - 1)) {
            col.add(new Integer(i));
            ++i;
        }
        row.add(col);
        col = new ArrayList();
        int j = i;
        int k = 1;
        while (j <= endDay) {
            if (k > 7) {
                row.add(col);
                k = 1;
                col = new ArrayList();
            }
            col.add(new Integer(i));
            ++j;
            ++k;
        }
        row.add(col);
        return row;
    }

    public static int getDayStr(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static String getPrevYear(String dateStr) {
        Date date = DateUtil.getDateWithDelimiter(dateStr);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, -1);
        return DateUtil.getDateStr(cal.getTime(), ".");
    }

    public static String getForeYear(String dateStr, int i) {
        dateStr = FormatUtil.deleteSlash(dateStr);
        dateStr = FormatUtil.deleteDash(dateStr);
        Date date = DateUtil.getDate(dateStr);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, i);
        return DateUtil.getDateStr(cal.getTime(), ".");
    }

    public static String getPrevMonth(String dateStr) {
        Date date = DateUtil.getDateWithDelimiter(dateStr);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, -1);
        return DateUtil.getDateStr(cal.getTime(), ".");
    }

    public static String getForeMonth(String dateStr, int i) {
        dateStr = FormatUtil.deleteSlash(dateStr);
        dateStr = FormatUtil.deleteDash(dateStr);
        Date date = DateUtil.getDate(dateStr);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, i);
        return DateUtil.getDateStr(cal.getTime(), ".");
    }

    public static String getYYYYMMBeforeMonth(String yyyymm, int beforeMonth) {
        if (yyyymm != null && yyyymm.length() == 6 && DateUtil.isDigit(yyyymm)) {
            Calendar result = Calendar.getInstance();
            result.set(1, Integer.parseInt(yyyymm.substring(0, 4)));
            result.set(2, Integer.parseInt(yyyymm.substring(4, 6)) - 1);
            result.add(2, beforeMonth);
            SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
            return df.format(result.getTime());
        }
        return null;
    }

    public static String getYYYY(Date date) {
        Calendar result = Calendar.getInstance();
        result.setTime(date);
        SimpleDateFormat df = new SimpleDateFormat("yyyy");
        return df.format(result.getTime());
    }

    public static String getYYYYMM(Date date) {
        return DateUtil.getYYYYMM(date, "");
    }

    public static String getYYYYMM(Date date, String delimiter) {
        Calendar result = Calendar.getInstance();
        result.setTime(date);
        SimpleDateFormat df = new SimpleDateFormat("yyyy" + delimiter + "MM");
        return df.format(result.getTime());
    }

    public static String getNextDay() {
        return DateUtil.getNextDay(DateUtil.getCurrentDate());
    }

    public static String toDisplayFormat(String _srcDate) {
        if (_srcDate == null || _srcDate.length() != 8 && _srcDate.length() != 14) {
            return _srcDate;
        }
        String time = "";
        if (_srcDate.length() == 14) {
            try {
                time = " " + _srcDate.substring(8, 10) + ":" + _srcDate.substring(10, 12) + ":" + _srcDate.substring(12, 14);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return String.valueOf(_srcDate.substring(0, 4)) + "." + _srcDate.substring(4, 6) + "." + _srcDate.substring(6, 8) + time;
    }

    public static String getNextDay(String _startDate) {
        Calendar cal = Calendar.getInstance();
        cal.set(Integer.parseInt(_startDate.substring(0, 4)), Integer.parseInt(_startDate.substring(5, 7)) - 1, Integer.parseInt(_startDate.substring(8, 10)));
        Date currentTime = cal.getTime();
        Date oneTime = new Date(86400000L);
        Date findTime = new Date(currentTime.getTime() + oneTime.getTime());
        return DateUtil.getDateStr(findTime, ".");
    }

    public static String getDayAfter(int day) {
        return DateUtil.getDayAfter(DateUtil.getCurrentDate(), day);
    }

    public static String getDayAfter(String _startDate, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(Integer.parseInt(_startDate.substring(0, 4)), Integer.parseInt(_startDate.substring(5, 7)) - 1, Integer.parseInt(_startDate.substring(8, 10)));
        Date currentTime = cal.getTime();
        Date oneTime = new Date(86400000 * day);
        Date findTime = new Date(currentTime.getTime() + oneTime.getTime());
        return DateUtil.getDateStr(findTime, ".");
    }

    public static String getOneDayPlusSomeDate(String _oneDay, int _aFewDays) {
        if (_oneDay == null || "".equals(_oneDay)) {
            return "";
        }
        _oneDay = FormatUtil.deleteChar(_oneDay, ".");
        Date now = new Date(System.currentTimeMillis());
        String currentDate = dateFormat.format(now);
        long interval = Long.parseLong(_oneDay) - Long.parseLong(currentDate);
        long intervalMillis = (interval += (long)_aFewDays) * 24L * 60L * 60L * 1000L;
        Date current = new Date(System.currentTimeMillis() + intervalMillis);
        return dateSqlFormat.format(current);
    }

    public static String getPrevDate(String _oneDay, int _aFewDays) {
        Calendar cal = Calendar.getInstance();
        cal.set(Integer.parseInt(_oneDay.substring(0, 4)), Integer.parseInt(_oneDay.substring(5, 7)) - 1, Integer.parseInt(_oneDay.substring(8, 10)));
        Date oneDayTime = cal.getTime();
        Date oneTime = new Date(86400000L);
        Date findTime = new Date(oneDayTime.getTime() - oneTime.getTime());
        return DateUtil.getDateStr(findTime, ".");
    }

    public static String getYYYYMMDD(Date date) {
        return DateUtil.getYYYYMMDD(date, "");
    }

    public static int getDiffDays(String start) {
        Calendar cal = Calendar.getInstance();
        int daydiff = 0;
        if (start != null && !start.trim().equals("") && start.length() == 8) {
            cal.set(Integer.parseInt(start.substring(0, 4)), Integer.parseInt(start.substring(4, 6)), Integer.parseInt(start.substring(6, 8)));
            Date startDate = cal.getTime();
            Date endDate = new Date(System.currentTimeMillis());
            long ccc = endDate.getTime() - startDate.getTime();
            daydiff = (int)(ccc / 86400000L);
        }
        return daydiff;
    }

    public static int getDiffMonth(String start) {
        Calendar cal = Calendar.getInstance();
        int daydiff = 0;
        if (start != null && !start.trim().equals("") && start.length() == 8) {
            cal.set(Integer.parseInt(start.substring(0, 4)), 12, Integer.parseInt(start.substring(6, 8)));
            Date startDate = cal.getTime();
            Date endDate = new Date(System.currentTimeMillis());
            long ccc = endDate.getTime() - startDate.getTime();
            daydiff = (int)(ccc / 86400000L);
        }
        return daydiff;
    }

    public static int getDiffDays(String start, String end) {
        Calendar cal = Calendar.getInstance();
        cal.set(Integer.parseInt(start.substring(0, 4)), Integer.parseInt(start.substring(4, 6)), Integer.parseInt(start.substring(6, 8)));
        Date startDate = cal.getTime();
        cal.set(Integer.parseInt(end.substring(0, 4)), Integer.parseInt(end.substring(4, 6)), Integer.parseInt(end.substring(6, 8)));
        Date endDate = cal.getTime();
        long ccc = endDate.getTime() - startDate.getTime();
        int daydiff = (int)(ccc / 86400000L);
        return daydiff;
    }

    public static String getYYYYMMDD(Date date, String delimiter) {
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy" + delimiter + "MM" + delimiter + "dd");
            return df.format(date);
        }
        return null;
    }

    public static Date getDateFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar = new GregorianCalendar(calendar.get(1), calendar.get(2), 1);
        return calendar.getTime();
    }

    public static Date getDateLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static String toDisplayMonth(String _dbDate, String del) {
        if (_dbDate.length() < 6) {
            return _dbDate;
        }
        return String.valueOf(_dbDate.substring(0, 4)) + del + _dbDate.substring(4);
    }

    public static String getYYMM() {
        Date current = new Date(System.currentTimeMillis());
        return new SimpleDateFormat("yyMM").format(current);
    }

    public static String getYYYYMM() {
        Date current = new Date(System.currentTimeMillis());
        return new SimpleDateFormat("yyyyMM").format(current);
    }

    public static Date getDate() {
        return new Date(System.currentTimeMillis());
    }

    public static String getPreYYYYMM() {
        String budgetYm = DateUtil.getForeMonth(DateUtil.getCurrentDate(), 1);
        return budgetYm;
    }

    public static void main(String[] arg) {
        Date date = new Date();
        String budgetYm = DateUtil.getForeMonth(DateUtil.getCurrentDate(), 1);
        System.out.println("\ub2e4\uc74c\ub2ec:" + DateUtil.getYear(budgetYm) + "/" + DateUtil.getMonthString(budgetYm) + "]");
        System.out.println(String.valueOf(DateUtil.getCurrentDate()) + ":vs:" + DateUtil.getOneDayPlusSomeDate("2003/06/30", -30) + "]");
        System.out.println("First day:" + date);
        System.out.println("First day:" + DateUtil.getDateFirstDayOfMonth(new Date()));
        System.out.println("First day:" + DateUtil.getDateLastDayOfMonth(new Date()));
    }

    public static String getDayAfterWithOutSlash(String startDate, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(Integer.parseInt(startDate.substring(0, 4)), Integer.parseInt(startDate.substring(4, 6)) - 1, Integer.parseInt(startDate.substring(6, 8)));
        Date startTime = cal.getTime();
        Date oneTime = new Date(86400000 * day);
        long fTime = startTime.getTime() + oneTime.getTime();
        Date findTime = new Date(fTime);
        return dateFormat.format(findTime);
    }

    public static String getYYYY() {
        Date current = new Date(System.currentTimeMillis());
        return new SimpleDateFormat("yyyy").format(current);
    }

    public static String getMM() {
        Date current = new Date(System.currentTimeMillis());
        return new SimpleDateFormat("MM").format(current);
    }

    public static String getMMDD(String delimiter) {
        Date current = new Date(System.currentTimeMillis());
        String month = new SimpleDateFormat("MM").format(current);
        String day = new SimpleDateFormat("dd").format(current);
        return String.valueOf(month) + delimiter + day;
    }

    public static String getFirstDate(int num) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM");
        c.set(2, c.get(2) + num);
        return String.valueOf(df.format(c.getTime())) + "." + "01";
    }

    public static String getFirstYearDate(int num) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM");
        c.set(1, c.get(1) + num);
        return String.valueOf(df.format(c.getTime())) + "." + "01";
    }

    public static String getLastDate(int num) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy.MM");
        c.set(2, c.get(2) + num);
        return String.valueOf(df.format(c.getTime())) + "." + c.getActualMaximum(5);
    }
}

