/*
 * Decompiled with CFR 0.152.
 */
package point.mile.common.page;

import java.io.Serializable;

public class PageInfo
implements Serializable {
    private int pageUnit = 10;
    private int totalPage;
    private long rowCount;
    private boolean hasPrevious;
    private boolean hasNext;
    private int nextPageNo;
    private int prevPageNo;
    private int currentPageNo = 1;
    private boolean hasNextPageUnit;
    private boolean hasPreviousPageUnit;
    private int currentPageUnitCount = 1;
    public int previousPageUnitNo;
    public int nextPageUnitNo;
    private int totalUnitCount;

    public void setPageUnit(int pageUnit) {
        this.pageUnit = pageUnit;
    }

    public int getPageUnit() {
        return this.pageUnit;
    }

    public boolean isHasNextPageUnit() {
        return this.getCurrentPageUnitCount() < this.getTotalUnitCount();
    }

    public boolean isHasPreviousPageUnit() {
        return this.getCurrentPageUnitCount() > 1;
    }

    public int getCurrentPageUnitCount() {
        if (this.currentPageNo % this.pageUnit == 0) {
            return this.currentPageNo / this.pageUnit;
        }
        return this.currentPageNo / this.pageUnit + 1;
    }

    public int getPreviousPageUnitNo() {
        return this.getCurrentPageUnitStartPageNo() - this.pageUnit;
    }

    public int getNextPageUnitNo() {
        return this.getCurrentPageUnitStartPageNo() + this.pageUnit;
    }

    public int getTotalUnitCount() {
        return this.totalPage % this.pageUnit == 0 ? this.totalPage / this.pageUnit : this.totalPage / this.pageUnit + 1;
    }

    public int getCurrentPageUnitStartPageNo() {
        return this.pageUnit * (this.getCurrentPageUnitCount() - 1) + 1;
    }

    public PageInfo() {
        this.totalPage = 1;
        this.rowCount = 0L;
    }

    public PageInfo(int totalPage, long rowCount, int currentPageNo) {
        this.totalPage = totalPage;
        this.rowCount = rowCount;
        this.currentPageNo = currentPageNo;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    public boolean isHasPrevious() {
        return this.currentPageNo > 1;
    }

    public void setHasPrevious(boolean hasPrevious) {
        this.hasPrevious = hasPrevious;
    }

    public int getNextPageNo() {
        this.nextPageNo = this.currentPageNo + 1;
        return this.nextPageNo;
    }

    public void setNextPageNo(int nextPageNo) {
        this.nextPageNo = nextPageNo;
    }

    public void setPrevPageNo(int prevPageNo) {
        this.prevPageNo = prevPageNo;
    }

    public int getPrevPageNo() {
        this.prevPageNo = this.currentPageNo - 1;
        return this.prevPageNo;
    }

    public int getCurrentPageNo() {
        return this.currentPageNo;
    }

    public void setCurrentPageNo(int currentPageNo) {
        this.currentPageNo = currentPageNo;
    }

    public boolean isHasNext() {
        return this.currentPageNo < this.totalPage;
    }

    public void setHasNext(boolean hasNext) {
        this.hasNext = hasNext;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n Total Page : " + this.totalPage);
        sb.append("\n Current Page No : " + this.currentPageNo);
        sb.append("\n Row Count : " + this.rowCount);
        sb.append("\n Total Page Unit Count: " + this.getTotalUnitCount());
        sb.append("\n Current Page Unit Count: " + this.getCurrentPageUnitCount());
        sb.append("\n Has Previous Unit :" + this.isHasPreviousPageUnit());
        sb.append("\n Has Next Unit :" + this.isHasNextPageUnit());
        sb.append("\n START PAGE : " + this.getCurrentPageUnitStartPageNo());
        sb.append("\n DEFAULT PAGE UNIT :" + this.pageUnit);
        return sb.toString();
    }

    public static void main(String[] args) {
        PageInfo info = new PageInfo(10, 100L, 1);
        System.out.println(info.toString());
    }
}

