/*
 * Decompiled with CFR 0.152.
 */
package point.mile.common.page;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

public class ListPageBar
implements Serializable {
    private int totalCount;
    private int rowNum;
    private int arrayNum;
    private int requestPageNum;
    private int resultArrayNum;
    private int startNum;
    private int totalNumCount;
    private Vector pageLinkNumber;

    public ListPageBar(int i) {
        this(10, 10, i);
    }

    public ListPageBar(int i, int j) {
        this(i, 10, j);
    }

    public ListPageBar(int i, int j, int k) {
        this.rowNum = i;
        this.arrayNum = j;
        this.requestPageNum = k;
    }

    public void setTotalCount(int i) {
        this.totalCount = i;
        this.calculate();
    }

    private void calculate() {
        int i = this.totalCount / this.rowNum;
        int j = this.totalCount % this.rowNum;
        int k = this.requestPageNum / this.arrayNum;
        int l = this.requestPageNum % this.arrayNum;
        this.totalNumCount = j > 0 ? i + 1 : i;
        this.resultArrayNum = l != 0 && this.requestPageNum / this.arrayNum == this.totalNumCount / this.arrayNum ? this.totalNumCount % this.arrayNum : this.arrayNum;
        if (this.requestPageNum <= this.arrayNum) {
            this.startNum = 1;
        } else {
            if (l == 0) {
                --k;
            }
            this.startNum = k * this.arrayNum + 1;
        }
    }

    public Vector getPageBar() {
        Vector<String> vector = new Vector<String>();
        this.pageLinkNumber = new Vector();
        if (this.startNum > this.arrayNum) {
            vector.addElement("[prev]");
            this.pageLinkNumber.addElement(String.valueOf(this.startNum - 1));
        }
        int i = this.startNum;
        while (i < this.resultArrayNum + this.startNum) {
            vector.addElement("[" + i + "]");
            this.pageLinkNumber.addElement(String.valueOf(i));
            ++i;
        }
        if (this.totalNumCount > this.startNum + (this.arrayNum - 1)) {
            vector.addElement("[next]");
            this.pageLinkNumber.addElement(String.valueOf(this.resultArrayNum + this.startNum));
        }
        return vector;
    }

    public Vector getStartPageNumber() {
        return this.pageLinkNumber;
    }

    public int totalPage() {
        return this.totalNumCount;
    }

    public int currentPage() {
        return this.requestPageNum;
    }

    public String getHtmlToString(String s) {
        s = "javascript:" + s;
        StringBuffer stringbuffer = new StringBuffer();
        if (this.startNum > this.arrayNum) {
            stringbuffer.append("<a href=\"" + s + "('" + (this.startNum - 1) + "')\">[prev]</a>");
        }
        int i = this.startNum;
        while (i < this.resultArrayNum + this.startNum) {
            if (i == this.requestPageNum) {
                stringbuffer.append("<a href=\"" + s + "('" + i + "')\"><b>[" + i + "]</b></a>");
            } else {
                stringbuffer.append("<a href=\"" + s + "('" + i + "')\">[" + i + "]</a>");
            }
            ++i;
        }
        if (this.totalNumCount > this.startNum + (this.arrayNum - 1)) {
            stringbuffer.append("<a href=\"" + s + "('" + (this.resultArrayNum + this.startNum) + "')\">[next]</a>");
        }
        return stringbuffer.toString();
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        Iterator iterator = this.getPageBar().iterator();
        while (iterator.hasNext()) {
            stringbuffer.append(iterator.next().toString());
        }
        return stringbuffer.toString();
    }

    public static int pageNumToRecodeNum(int i, int j) {
        return (i - 1) * j + 1;
    }

    public static void main(String[] args) {
    }

    public int getArrayNum() {
        return this.arrayNum;
    }

    public int getRequestPageNum() {
        return this.requestPageNum;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public int getStartRowNum() {
        return this.requestPageNum * this.rowNum - (this.rowNum - 1);
    }

    public String getPageInfo() {
        return "<b>Total " + this.totalCount + " \uac74</b>";
    }

    public int getTotalCount() {
        return this.totalCount;
    }
}

