/*
 * Decompiled with CFR 0.152.
 */
package com.tmile.common.wsvc;

import com.tmile.common.wsvc.DataList;
import com.tmile.common.wsvc.QueryCondition;
import com.tmile.common.wsvc.TMileConstants;
import com.tmile.cstm.entity.CstmET;
import com.tmile.cstm.wsvc.CstmWSVCProxy;
import com.tmile.mile.entity.MileET;
import com.tmile.mile.wsvc.MileWSVCProxy;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;

public class TMileManager
implements Serializable {
    private TMileManager() {
    }

    public static DataList getCstmInfoList(QueryCondition qc) {
        try {
            CstmWSVCProxy cstmWSVCProxy = new CstmWSVCProxy();
            cstmWSVCProxy.setEndpoint(String.valueOf(TMileConstants.WSVC_ENDPOINT_TMILE) + "/services/CstmWSVC");
            CstmET cstmET = new CstmET();
            cstmET.setSiteCd(TMileConstants.CODE_WSVC_SITECD);
            cstmET.setCstmnm(qc.getByString("CSTMNM"));
            cstmET.setCstmid(qc.getByString("CSTMID"));
            cstmET.setChcd(qc.getByString("CHCD"));
            cstmET.setMblno1(qc.getByString("MBLNO1"));
            cstmET.setMblno2(qc.getByString("MBLNO2"));
            cstmET.setMblno3(qc.getByString("MBLNO3"));
            cstmET.setResidno1(qc.getByString("RESIDNO1"));
            cstmET.setResidno2(qc.getByString("RESIDNO2"));
            DataList list = TMileManager.getDataListToArrayUPVersion(cstmWSVCProxy.getCstmInfoList(cstmET));
            return list;
        }
        catch (RemoteException re) {
            System.out.print("=================RemoteException==================:" + re);
            return null;
        }
        catch (Exception e) {
            System.out.print("Exception");
            return null;
        }
    }

    public static HashMap getTotalMileageInfo(QueryCondition qc) {
        try {
            MileWSVCProxy mileWSVCProxy = new MileWSVCProxy();
            mileWSVCProxy.setEndpoint(String.valueOf(TMileConstants.WSVC_ENDPOINT_TMILE) + "/services/MileWSVC");
            MileET mileET = new MileET();
            mileET.setSiteCd(TMileConstants.CODE_WSVC_SITECD);
            mileET.setCstmid(qc.getByString("uCstmId"));
            mileET.setUserCondition(qc.getByString("userCondition"));
            mileET.setUserOrderBy(qc.getByString("userOrderBy"));
            HashMap result = TMileManager.getHashMapToEntity(mileWSVCProxy.getTotalMileageInfo(mileET));
            return result;
        }
        catch (RemoteException re) {
            System.out.print("=================RemoteException==================:" + re);
            return null;
        }
        catch (Exception e) {
            System.out.print("=================Exception==================:" + e);
            return null;
        }
    }

    public static DataList getDataListToArrayUPVersion(Object[] entityObj) throws Exception {
        DataList dataList = new DataList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String key = null;
        if (entityObj != null && entityObj.length == 0) {
            return null;
        }
        Class<?> clazz = entityObj[0].getClass();
        int i = 0;
        while (i < entityObj.length) {
            Method method;
            char[] c;
            Field[] fields = clazz.getDeclaredFields();
            Field[] superClassFields = clazz.getSuperclass().getDeclaredFields();
            int f = 0;
            while (f < fields.length) {
                key = fields[f].getName();
                c = key.toCharArray();
                c[0] = Character.toUpperCase(c[0]);
                method = clazz.getMethod("get" + new String(c), null);
                map.put(key.toUpperCase(), method.invoke(entityObj[i], null));
                ++f;
            }
            f = 0;
            while (f < superClassFields.length) {
                key = superClassFields[f].getName();
                c = key.toCharArray();
                c[0] = Character.toUpperCase(c[0]);
                method = clazz.getMethod("get" + new String(c), null);
                map.put(key.toUpperCase(), method.invoke(entityObj[i], null));
                ++f;
            }
            dataList.add(map.clone());
            map.clear();
            ++i;
        }
        return dataList;
    }

    public static HashMap getHashMapToEntity(Object entityObj) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> clazz = entityObj.getClass();
        Field[] fields = clazz.getDeclaredFields();
        String key = null;
        int f = 0;
        while (f < fields.length) {
            key = fields[f].getName();
            char[] c = key.toCharArray();
            c[0] = Character.toUpperCase(c[0]);
            Method method = clazz.getMethod("get" + new String(c), null);
            map.put(key.toUpperCase(), method.invoke(entityObj, null));
            ++f;
        }
        return map;
    }

    public static String saveCstmInfo(QueryCondition qc) {
        CstmWSVCProxy cstmWSVCProxy = new CstmWSVCProxy();
        cstmWSVCProxy.setEndpoint(String.valueOf(TMileConstants.WSVC_ENDPOINT_TMILE) + "/services/CstmWSVC");
        CstmET cstmET = new CstmET();
        try {
            cstmET.setSiteCd(TMileConstants.CODE_WSVC_SITECD);
            cstmET.setCstmid(TMileManager.nullTrim(qc.getByString("UCSTMID")));
            cstmET.setChcstmid(TMileManager.nullTrim(qc.getByString("CSTMID")));
            cstmET.setCstmnm(TMileManager.nullTrim(qc.getByString("CSTMNM")));
            if (qc.getByString("SALONG_YN").equals("Y")) {
                cstmET.setPrtnrid(TMileManager.nullTrim(qc.getByString("prtnrCD")));
            } else {
                cstmET.setPrtnrid("D" + TMileManager.nullTrim(qc.getByString("prtnrCD")));
            }
            cstmET.setPrtnrnm(TMileManager.nullTrim(qc.getByString("prtnrNM")));
            cstmET.setResidno1(TMileManager.nullTrim(qc.getByString("RESLNO1")));
            cstmET.setResidno2(TMileManager.nullTrim(qc.getByString("RESLNO2")));
            cstmET.setBdayfl(TMileManager.nullTrim(qc.getByString("BRTHDATETP")));
            cstmET.setBday(TMileManager.nullTrim(qc.getByString("BIRTHMONDAY")));
            cstmET.setDmsendcd(TMileManager.nullTrim(qc.getByString("DMSENDPLCCD")));
            if (TMileManager.nullTrim(qc.getByString("DMSENDPLCCD")).equals("H")) {
                cstmET.setZip1(TMileManager.nullTrim(qc.getByString("HOMEZIP1")));
                cstmET.setZip2(TMileManager.nullTrim(qc.getByString("HOMEZIP2")));
                cstmET.setAddr1(TMileManager.nullTrim(qc.getByString("HOMEADDR1")));
                cstmET.setAddr2(TMileManager.nullTrim(qc.getByString("HOMEADDR2")));
            } else {
                cstmET.setZip1(TMileManager.nullTrim(qc.getByString("CMPYZIP1")));
                cstmET.setZip2(TMileManager.nullTrim(qc.getByString("CMPYZIP2")));
                cstmET.setAddr1(TMileManager.nullTrim(qc.getByString("CMPYADDR1")));
                cstmET.setAddr2(TMileManager.nullTrim(qc.getByString("CMPYADDR2")));
            }
            cstmET.setMblno1(TMileManager.nullTrim(qc.getByString("MOBILENO1")));
            cstmET.setMblno2(TMileManager.nullTrim(qc.getByString("MOBILENO2")));
            cstmET.setMblno3(TMileManager.nullTrim(qc.getByString("MOBILENO3")));
            cstmET.setPhoneno1(TMileManager.nullTrim(qc.getByString("HOMEPHONENO1")));
            cstmET.setPhoneno2(TMileManager.nullTrim(qc.getByString("HOMEPHONENO2")));
            cstmET.setPhoneno3(TMileManager.nullTrim(qc.getByString("HOMEPHONENO3")));
            cstmET.setSkintpcd(TMileManager.nullTrim(qc.getByString("SKINTPCD")));
            cstmET.setSkintrblcd(TMileManager.nullTrim(qc.getByString("SKINTRB")));
            cstmET.setEmailid(TMileManager.nullTrim(qc.getByString("EMAIL1")));
            cstmET.setEmailcmpy(TMileManager.nullTrim(qc.getByString("EMAIL2")));
            cstmET.setJobcd(TMileManager.nullTrim(qc.getByString("JOBCD")));
            cstmET.setCstmcardno(TMileManager.nullTrim(qc.getByString("cardNo")));
            cstmET.setCstmdelfl(TMileManager.nullTrim(qc.getByString("cstmdelfl")));
            cstmET.setRnmauthfl(TMileManager.nullTrim(qc.getByString("Read_GUBUN")));
            cstmET.setRnmauthdate(TMileManager.nullTrim(qc.getByString("RESIDNODATE")));
            cstmET.setChdelfl(TMileManager.nullTrim(qc.getByString("chdelfl")));
            cstmET.setDmrcvfl(TMileManager.nullTrim(qc.getByString("DMRCVFL")));
            cstmET.setSmsrcvfl(TMileManager.nullTrim(qc.getByString("SMSRCVFL")));
            cstmET.setEmailrcvfl(TMileManager.nullTrim(qc.getByString("EMAILRCVFL")));
            cstmET.setJoindate(TMileManager.nullTrim(qc.getByString("JOINDATE")));
            cstmET.setLstpurdate(TMileManager.nullTrim(qc.getByString("LASTPURDATE")));
            cstmET.setChcd(TMileManager.nullTrim(qc.getByString("CHCD")));
            cstmET.setChstatfl(TMileManager.nullTrim(qc.getByString("cstmStatFl")));
            cstmET.setChaccumpt("0");
            cstmET.setChrdmpt("0");
            cstmET.setChremainpt("0");
            cstmET.setRegid(qc.getByString("INSDID"));
            cstmET.setUpdid(qc.getByString("INSDID"));
            cstmET.setSiteCd(TMileConstants.CODE_WSVC_SITECD);
            cstmET.setUserCondition(qc.getByString("userCondition"));
            cstmET.setUserOrderBy(qc.getByString("userOrderBy"));
            cstmET = cstmWSVCProxy.saveCstmInfo(cstmET);
        }
        catch (RemoteException re) {
            System.out.println(re);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return cstmET.getCstmid();
    }

    public static String nullTrim(String str) {
        str = str == null ? "" : str.trim();
        return str;
    }
}

