/*
 * Decompiled with CFR 0.152.
 */
package com.tmile.common;

import com.ufo.common.LogManager;
import com.ufo.common.MessageManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;

public class TMileException
extends Exception {
    private String errorMessage;
    private String exStack;

    public TMileException(String className, String errCode) {
        this(className, errCode, "");
    }

    public TMileException(String className, String errorCode, Exception ex) {
        this(className, errorCode, "", ex);
    }

    public TMileException(String className, String errorCode, String insertMessage) {
        this.errorMessage = MessageManager.getMessage((String)errorCode, (String)insertMessage);
        LogManager.addERRLog((String)className, (String)errorCode, (String)this.errorMessage);
    }

    public String getMessage() {
        String scriptErrorMSG = "";
        int i = 0;
        while (i < this.errorMessage.length()) {
            scriptErrorMSG = this.errorMessage.substring(i, i + 1).equals("\n") ? String.valueOf(scriptErrorMSG) + "\\n" : (this.errorMessage.substring(i, i + 1).equals("'") ? String.valueOf(scriptErrorMSG) + "\"" : String.valueOf(scriptErrorMSG) + this.errorMessage.substring(i, i + 1));
            ++i;
        }
        return scriptErrorMSG;
    }

    public TMileException(String className, String errorCode, String insertMessage, Exception ex) {
        this(className, errorCode, insertMessage);
        SQLException sqlExpt;
        String sqlErrCode;
        this.errorMessage = String.valueOf(this.errorMessage) + "\\n\\n[" + errorCode + "]" + ex.getMessage();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println();
        if (ex instanceof SQLException && (sqlErrCode = String.valueOf((sqlExpt = (SQLException)ex).getErrorCode())).equals("1")) {
            this.errorMessage = "\uc774\ubbf8 \uc874\uc7ac\ud558\ub294 \ub370\uc774\ud130\uc785\ub2c8\ub2e4. \\n" + this.errorMessage;
        }
        printWriter.println("Exception Stack Infomation ");
        ex.printStackTrace(printWriter);
        printWriter.println();
        LogManager.addERRLog((String)className, (String)"", (String)stringWriter.toString());
        this.exStack = stringWriter.toString();
        try {
            printWriter.close();
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setStackMessage() {
        this.errorMessage = String.valueOf(this.errorMessage) + "\n Provider Stack Trace [" + this.exStack + "]";
    }
}

