/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert;

import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.asn1.x509.AttributeCertificateInfo;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.operator.ContentSigner;

class CertUtils {
    private static Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());
    private static List EMPTY_LIST = Collections.unmodifiableList(new ArrayList());

    CertUtils() {
    }

    static X509CertificateHolder generateFullCert(ContentSigner contentSigner, TBSCertificateStructure tBSCertificateStructure) {
        try {
            return new X509CertificateHolder(CertUtils.generateStructure(tBSCertificateStructure, contentSigner.getAlgorithmIdentifier(), CertUtils.generateSig(contentSigner, (ASN1Encodable)tBSCertificateStructure)));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot produce certificate signature");
        }
    }

    static X509AttributeCertificateHolder generateFullAttrCert(ContentSigner contentSigner, AttributeCertificateInfo attributeCertificateInfo) {
        try {
            return new X509AttributeCertificateHolder(CertUtils.generateAttrStructure(attributeCertificateInfo, contentSigner.getAlgorithmIdentifier(), CertUtils.generateSig(contentSigner, (ASN1Encodable)attributeCertificateInfo)));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot produce attribute certificate signature");
        }
    }

    static X509CRLHolder generateFullCRL(ContentSigner contentSigner, TBSCertList tBSCertList) {
        try {
            return new X509CRLHolder(CertUtils.generateCRLStructure(tBSCertList, contentSigner.getAlgorithmIdentifier(), CertUtils.generateSig(contentSigner, (ASN1Encodable)tBSCertList)));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot produce certificate signature");
        }
    }

    private static byte[] generateSig(ContentSigner contentSigner, ASN1Encodable aSN1Encodable) throws IOException {
        OutputStream outputStream = contentSigner.getOutputStream();
        outputStream.write(aSN1Encodable.getDEREncoded());
        outputStream.close();
        return contentSigner.getSignature();
    }

    private static X509CertificateStructure generateStructure(TBSCertificateStructure tBSCertificateStructure, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((DEREncodable)tBSCertificateStructure);
        aSN1EncodableVector.add((DEREncodable)algorithmIdentifier);
        aSN1EncodableVector.add((DEREncodable)new DERBitString(byArray));
        return X509CertificateStructure.getInstance((Object)new DERSequence(aSN1EncodableVector));
    }

    private static AttributeCertificate generateAttrStructure(AttributeCertificateInfo attributeCertificateInfo, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((DEREncodable)attributeCertificateInfo);
        aSN1EncodableVector.add((DEREncodable)algorithmIdentifier);
        aSN1EncodableVector.add((DEREncodable)new DERBitString(byArray));
        return AttributeCertificate.getInstance((Object)new DERSequence(aSN1EncodableVector));
    }

    private static CertificateList generateCRLStructure(TBSCertList tBSCertList, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((DEREncodable)tBSCertList);
        aSN1EncodableVector.add((DEREncodable)algorithmIdentifier);
        aSN1EncodableVector.add((DEREncodable)new DERBitString(byArray));
        return CertificateList.getInstance((Object)new DERSequence(aSN1EncodableVector));
    }

    static Set getCriticalExtensionOIDs(X509Extensions x509Extensions) {
        if (x509Extensions == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(x509Extensions.getCriticalExtensionOIDs())));
    }

    static Set getNonCriticalExtensionOIDs(X509Extensions x509Extensions) {
        if (x509Extensions == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(x509Extensions.getNonCriticalExtensionOIDs())));
    }

    static List getExtensionOIDs(X509Extensions x509Extensions) {
        if (x509Extensions == null) {
            return EMPTY_LIST;
        }
        return Collections.unmodifiableList(Arrays.asList(x509Extensions.getExtensionOIDs()));
    }

    static DERBitString booleanToBitString(boolean[] blArray) {
        int n;
        byte[] byArray = new byte[(blArray.length + 7) / 8];
        for (n = 0; n != blArray.length; ++n) {
            int n2 = n / 8;
            byArray[n2] = (byte)(byArray[n2] | (blArray[n] ? 1 << 7 - n % 8 : 0));
        }
        n = blArray.length % 8;
        if (n == 0) {
            return new DERBitString(byArray);
        }
        return new DERBitString(byArray, 8 - n);
    }

    static boolean[] bitStringToBoolean(DERBitString dERBitString) {
        if (dERBitString != null) {
            byte[] byArray = dERBitString.getBytes();
            boolean[] blArray = new boolean[byArray.length * 8 - dERBitString.getPadBits()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    static Date recoverDate(DERGeneralizedTime dERGeneralizedTime) {
        try {
            return dERGeneralizedTime.getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalStateException("unable to recover date: " + parseException.getMessage());
        }
    }
}

