/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.io.LineReaderInputStream;
import org.apache.james.mime4j.io.MaxLineLimitException;
import org.apache.james.mime4j.util.ByteArrayBuffer;

public class LineReaderInputStreamAdaptor
extends LineReaderInputStream {
    private final LineReaderInputStream bis;
    private final int maxLineLen;
    private boolean used = false;
    private boolean eof = false;

    public LineReaderInputStreamAdaptor(InputStream is, int maxLineLen) {
        super(is);
        this.bis = is instanceof LineReaderInputStream ? (LineReaderInputStream)is : null;
        this.maxLineLen = maxLineLen;
    }

    public LineReaderInputStreamAdaptor(InputStream is) {
        this(is, -1);
    }

    public int read() throws IOException {
        int i = this.in.read();
        this.eof = i == -1;
        this.used = true;
        return i;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i = this.in.read(b, off, len);
        this.eof = i == -1;
        this.used = true;
        return i;
    }

    public int readLine(ByteArrayBuffer dst) throws MaxLineLimitException, IOException {
        int i = this.bis != null ? this.bis.readLine(dst) : this.doReadLine(dst);
        this.eof = i == -1;
        this.used = true;
        return i;
    }

    private int doReadLine(ByteArrayBuffer dst) throws MaxLineLimitException, IOException {
        int ch;
        int total = 0;
        while ((ch = this.in.read()) != -1) {
            dst.append(ch);
            ++total;
            if (this.maxLineLen > 0 && dst.length() >= this.maxLineLen) {
                throw new MaxLineLimitException("Maximum line length limit exceeded");
            }
            if (ch != 10) continue;
        }
        if (total == 0 && ch == -1) {
            return -1;
        }
        return total;
    }

    public boolean eof() {
        return this.eof;
    }

    public boolean isUsed() {
        return this.used;
    }

    public String toString() {
        return "[LineReaderInputStreamAdaptor: " + this.bis + "]";
    }

    public boolean unread(ByteArrayBuffer buf) {
        if (this.bis != null) {
            return this.bis.unread(buf);
        }
        return false;
    }

    public long skip(long count) throws IOException {
        int res;
        if (count <= 0L) {
            return 0L;
        }
        int bufferSize = count > 8192L ? 8192 : (int)count;
        byte[] buffer = new byte[bufferSize];
        long result = 0L;
        while (count > 0L && (res = this.read(buffer)) != -1) {
            result += (long)res;
            count -= (long)res;
        }
        return result;
    }
}

