/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.util.uds;

import com.activeintra.manager.HttpParameterDecoder;
import com.activeintra.util.AIReportNexacro;
import com.activeintra.util.AIUtils;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NexacroDataSetHandler {
    private final String dataSetID;
    private final boolean useServerSavedData;
    private final Map<String, Integer> colIdxMap;
    private final String[] constValues;
    private String[][] dataSet;
    private int rowCount = 0;
    private int currRow = 0;
    private String[] row;
    private String xmlID;

    public NexacroDataSetHandler(String string, String string2, boolean bl) {
        int n;
        this.dataSetID = string;
        this.useServerSavedData = bl;
        HashMap<Integer, String> hashMap = null;
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        int n2 = 1;
        int n3 = string2.indexOf(60, 0);
        while (n3 != -1) {
            String string3;
            n = string2.indexOf(62, ++n3);
            if ((n3 = (string3 = string2.substring(n3, n++)).indexOf(58, 0)) != -1) {
                if (hashMap == null) {
                    hashMap = new HashMap<Integer, String>();
                }
                hashMap.put(new Integer(n2), string3.substring(n3 + 1));
                string3 = string3.substring(0, n3);
            }
            hashMap2.put(string3, new Integer(n2++));
            n3 = string2.indexOf(60, n);
        }
        this.colIdxMap = new HashMap<String, Integer>(hashMap2.size(), 1.0f);
        this.colIdxMap.putAll(hashMap2);
        if (hashMap == null) {
            this.constValues = null;
        } else {
            this.constValues = new String[this.colIdxMap.size() + 1];
            for (n = 1; n < this.constValues.length; ++n) {
                this.constValues[n] = (String)hashMap.get(new Integer(n));
            }
        }
    }

    public boolean next() {
        ++this.currRow;
        if (this.rowCount == 0 || this.rowCount < this.currRow) {
            return false;
        }
        this.row = this.dataSet[this.currRow - 1];
        return true;
    }

    public boolean absolute(int n) {
        this.currRow = n;
        if (this.currRow > 0 && this.currRow <= this.rowCount) {
            this.row = this.dataSet[this.currRow - 1];
            return true;
        }
        return false;
    }

    public void beforeFirst() {
        this.currRow = 0;
    }

    public boolean isAfterLast() {
        return this.rowCount > 0 && this.currRow > this.rowCount;
    }

    public boolean previous() {
        --this.currRow;
        if (this.rowCount < 1 || this.currRow < 1) {
            return false;
        }
        this.row = this.dataSet[this.currRow - 1];
        return true;
    }

    public String getField(int n) {
        String string = this.row[n];
        return string == null ? "" : string;
    }

    public void makeDataSet(HttpServletRequest httpServletRequest) {
        try {
            this.makeDataSetOrigin(httpServletRequest);
        }
        catch (Exception exception) {
            this.dataSet = new String[0][];
            this.rowCount = 0;
        }
    }

    private void makeDataSetOrigin(HttpServletRequest httpServletRequest) throws Exception {
        boolean bl = this.useServerSavedData;
        HttpParameterDecoder httpParameterDecoder = (HttpParameterDecoder)httpServletRequest.getAttribute("paramsDecoder");
        String string = httpParameterDecoder.getParameter("reportMode");
        if (string != null && !string.equals("HTML")) {
            bl = true;
        }
        if (bl) {
            File[] fileArray;
            String string2 = httpParameterDecoder.getParameter(this.dataSetID);
            LinkedList<String[]> linkedList = new LinkedList<String[]>();
            for (File file : fileArray = AIReportNexacro.getSavedDataSetFiles(string2, httpServletRequest)) {
                String string3 = AIUtils.readTextFile(file, "UTF-8");
                this.doDataSetMake(string3, linkedList);
            }
            this.dataSet = (String[][])linkedList.toArray((T[])new String[0][]);
            linkedList.clear();
        } else {
            String string4 = httpParameterDecoder.getParameter(this.dataSetID);
            if (string4 == null) {
                throw new IllegalArgumentException("None dataSet for id: " + this.dataSetID);
            }
            this.dataSet = this.doDataSetMake(string4, null);
            String string5 = AIReportNexacro.saveDataSet(this.xmlID, string4, httpServletRequest);
            httpParameterDecoder.putParameter(this.dataSetID, string5, (Object)this);
        }
        this.rowCount = this.dataSet.length;
    }

    private String[][] doDataSetMake(String string, List<String[]> list) throws Exception {
        Element element;
        boolean bl = list != null;
        SAXBuilder sAXBuilder = new SAXBuilder(false);
        Element element2 = sAXBuilder.build((Reader)new StringReader(string)).getRootElement();
        if ("Dataset".equals(element2.getName())) {
            element = element2;
        } else {
            element2.setNamespace(null);
            element = element2.getChild("Dataset", null);
            if (element == null) {
                throw new IllegalStateException("None Dataset element");
            }
        }
        this.xmlID = element.getAttributeValue("id");
        Element element3 = element.getChild("Rows", null);
        if (element3 == null) {
            if (bl) {
                return null;
            }
            return new String[0][];
        }
        List list2 = element3.getChildren("Row", null);
        if (list2.isEmpty()) {
            if (bl) {
                return null;
            }
            return new String[0][];
        }
        int n = this.colIdxMap.size() + 1;
        if (list == null) {
            list = new LinkedList<String[]>();
        }
        for (Element element4 : list2) {
            String string2 = element4.getAttributeValue("type");
            if ("delete".equals(string2)) continue;
            String[] stringArray = new String[n];
            List list3 = element4.getChildren("Col", null);
            for (Element element5 : list3) {
                String string3 = element5.getAttributeValue("id");
                stringArray[this.colIdxMap.get((Object)string3).intValue()] = element5.getText();
            }
            if (this.constValues != null) {
                for (int i = 1; i < n; ++i) {
                    if (this.constValues[i] == null) continue;
                    stringArray[i] = this.constValues[i];
                }
            }
            list.add(stringArray);
        }
        element3.removeContent();
        element2 = null;
        element = null;
        element3 = null;
        if (bl) {
            return null;
        }
        return (String[][])list.toArray((T[])new String[0][]);
    }

    public void close() {
        this.dataSet = null;
    }
}

