/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.util.uds;

import com.activeintra.manager.HttpParameterDecoder;
import com.activeintra.util.AIUtils;
import com.activeintra.util.json.JSONArray;
import com.activeintra.util.json.JSONObject;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONSetHandler {
    private final JSONMetaData metaData;
    private String[][] dataSet;
    private int rowCount = 0;
    private int currRow = 0;
    private String[] row;

    public JSONSetHandler(JSONMetaData jSONMetaData) {
        this.metaData = jSONMetaData;
    }

    public JSONSetHandler(File file) throws IOException {
        this.metaData = new JSONMetaData(AIUtils.readTextFile(file, "UTF-8"));
    }

    public boolean next() {
        ++this.currRow;
        if (this.rowCount == 0 || this.rowCount < this.currRow) {
            return false;
        }
        this.row = this.dataSet[this.currRow - 1];
        return true;
    }

    public boolean absolute(int n) {
        this.currRow = n;
        if (this.currRow > 0 && this.currRow <= this.rowCount) {
            this.row = this.dataSet[this.currRow - 1];
            return true;
        }
        return false;
    }

    public void beforeFirst() {
        this.currRow = 0;
    }

    public boolean isAfterLast() {
        return this.rowCount > 0 && this.currRow > this.rowCount;
    }

    public boolean previous() {
        --this.currRow;
        if (this.rowCount < 1 || this.currRow < 1) {
            return false;
        }
        this.row = this.dataSet[this.currRow - 1];
        return true;
    }

    public String getField(int n) {
        String string = this.row[n];
        return string == null ? "" : string;
    }

    public void close() {
        this.dataSet = null;
    }

    public int getFieldCount() {
        return this.metaData.fields.length;
    }

    public void makeDataSet(HttpServletRequest httpServletRequest) {
        try {
            this.makeDataSetOrigin(httpServletRequest);
        }
        catch (Exception exception) {
            this.dataSet = new String[0][];
            this.rowCount = 0;
        }
    }

    private void makeDataSetOrigin(HttpServletRequest httpServletRequest) throws Exception {
        Iterator<Map.Entry<String, Object>> iterator;
        Object object;
        String string;
        if (this.metaData.docSource == 1) {
            string = this.metaData.request.doHttpRequest(this.metaData.docEncoding, httpServletRequest);
        } else if (this.metaData.docSource == 2) {
            string = AIUtils.readTextFile(this.metaData.request.jsonFile, this.metaData.docEncoding);
        } else {
            object = (HttpParameterDecoder)httpServletRequest.getAttribute("paramsDecoder");
            string = object.getParameterB(this.metaData.request.url);
        }
        if (string.length() == 0) {
            this.rowCount = 0;
            this.dataSet = new String[0][];
            return;
        }
        object = new LinkedList();
        Object object2 = null;
        if (this.metaData.recordSelector[0]) {
            iterator = new JSONObject(string);
            string = null;
            if (this.metaData.recordSelector.length == 1) {
                this.handleOneRecord((JSONObject)((Object)iterator), (List<String[]>)object);
            } else {
                object2 = this.selectRowContainer(iterator);
            }
        } else {
            iterator = new JSONArray(string);
            string = null;
            object2 = this.selectRowContainer(iterator);
        }
        if (object2 != null) {
            if (object2 instanceof JSONObject) {
                for (Map.Entry<String, Object> entry : ((JSONObject)object2).entrySet()) {
                    Object object3 = entry.getValue();
                    if (!(object3 instanceof JSONObject)) continue;
                    this.handleOneRecord((JSONObject)object3, (List<String[]>)object);
                }
            } else {
                iterator = (JSONArray)object2;
                this.rowCount = ((JSONArray)((Object)iterator)).length();
                for (int i = 0; i < this.rowCount; ++i) {
                    Object object4 = ((JSONArray)((Object)iterator)).opt(i);
                    if (!(object4 instanceof JSONObject)) continue;
                    this.handleOneRecord((JSONObject)object4, (List<String[]>)object);
                }
            }
        }
        this.rowCount = object.size();
        this.dataSet = (String[][])object.toArray((T[])new String[this.rowCount][]);
        object.clear();
    }

    private Object selectRowContainer(Object object) {
        if (this.metaData.recordSelector.length == 2) {
            return object;
        }
        Object object2 = object;
        int n = this.metaData.recordSelector.length - 2;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object var5_5 = null;
        for (int i = 1; i <= n; ++i) {
            Iterator<Map.Entry<String, Object>> iterator;
            boolean bl = false;
            if (object2 instanceof JSONObject) {
                iterator = var5_5 == null ? ((JSONObject)object2).entrySet().iterator() : ((ParentObj)var5_5).itr;
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> entry = iterator.next();
                    Object object3 = entry.getValue();
                    if (this.metaData.recordSelector[i]) {
                        if (object3 instanceof JSONObject) {
                            bl = true;
                        }
                    } else if (object3 instanceof JSONArray) {
                        bl = true;
                    }
                    if (bl && i == n) {
                        bl = this.hasRecordChild(object3);
                    }
                    if (!bl) continue;
                    linkedList.add(new ParentObj((JSONObject)object2, iterator));
                    var5_5 = null;
                    object2 = object3;
                    break;
                }
            } else {
                iterator = (JSONArray)object2;
                int n2 = 0;
                if (var5_5 != null) {
                    n2 = ((ParentArr)var5_5).nextIdx;
                }
                int n3 = ((JSONArray)((Object)iterator)).length();
                for (int j = n2; j < n3; ++j) {
                    Object object4 = ((JSONArray)((Object)iterator)).opt(j);
                    if (this.metaData.recordSelector[i]) {
                        if (object4 instanceof JSONObject) {
                            bl = true;
                        }
                    } else if (object4 instanceof JSONArray) {
                        bl = true;
                    }
                    if (bl && i == n) {
                        bl = this.hasRecordChild(object4);
                    }
                    if (!bl) continue;
                    linkedList.add(new ParentArr((JSONArray)((Object)iterator), j + 1));
                    var5_5 = null;
                    object2 = object4;
                    break;
                }
            }
            if (bl) continue;
            var5_5 = linkedList.removeLast();
            if (var5_5 != null && i > 1) {
                object2 = var5_5 instanceof ParentObj ? ((ParentObj)var5_5).obj : ((ParentArr)var5_5).arr;
                i -= 2;
                continue;
            }
            object2 = null;
            break;
        }
        return object2;
    }

    private boolean hasRecordChild(Object object) {
        boolean bl = this.metaData.subRecordsArraySelector != null;
        int n = this.metaData.fields.length;
        boolean bl2 = true;
        if (object instanceof JSONObject) {
            for (Map.Entry<String, Object> entry : ((JSONObject)object).entrySet()) {
                Object object2 = entry.getValue();
                if (!(object2 instanceof JSONObject)) continue;
                if (bl) {
                    JSONArray jSONArray = this.metaData.subRecordsArraySelector.selectSubRecordsArray((JSONObject)object2);
                    if (jSONArray == null) continue;
                    return true;
                }
                JSONObject jSONObject = (JSONObject)object2;
                for (int i = 0; i < n; ++i) {
                    if (!this.metaData.fields[i].required) continue;
                    bl2 = false;
                    String string = this.metaData.fields[i].selector.select(jSONObject);
                    if (string == null) continue;
                    return true;
                }
            }
        } else {
            JSONArray jSONArray = (JSONArray)object;
            int n2 = jSONArray.length();
            for (int i = 0; i < n2; ++i) {
                Object object3 = jSONArray.opt(i);
                if (!(object3 instanceof JSONObject)) continue;
                if (bl) {
                    JSONArray jSONArray2 = this.metaData.subRecordsArraySelector.selectSubRecordsArray((JSONObject)object3);
                    if (jSONArray2 == null) continue;
                    return true;
                }
                JSONObject jSONObject = (JSONObject)object3;
                for (int j = 0; j < n; ++j) {
                    if (!this.metaData.fields[j].required) continue;
                    bl2 = false;
                    String string = this.metaData.fields[j].selector.select(jSONObject);
                    if (string == null) continue;
                    return true;
                }
            }
        }
        return !bl && bl2;
    }

    private void handleOneRecord(JSONObject jSONObject, List<String[]> list) {
        int n = this.metaData.fields.length;
        String[] stringArray = new String[n + 1];
        if (this.metaData.subRecordsArraySelector == null) {
            for (int i = 0; i < n; ++i) {
                String string = this.metaData.fields[i].selector.select(jSONObject);
                if (string == null && this.metaData.fields[i].required) {
                    return;
                }
                stringArray[i + 1] = string;
            }
            list.add(stringArray);
        } else {
            String string;
            for (int i = 0; i < n; ++i) {
                if (this.metaData.fields[i].subField) continue;
                string = this.metaData.fields[i].selector.select(jSONObject);
                if (string == null && this.metaData.fields[i].required) {
                    return;
                }
                stringArray[i + 1] = string;
            }
            JSONArray jSONArray = this.metaData.subRecordsArraySelector.selectSubRecordsArray(jSONObject);
            if (jSONArray == null) {
                list.add(stringArray);
                return;
            }
            int n2 = 0;
            block2: for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.optJSONObject(i);
                if (jSONObject2 == null) continue;
                String[] stringArray2 = new String[n + 1];
                for (int j = 0; j < n; ++j) {
                    if (this.metaData.fields[j].subField) {
                        string = this.metaData.fields[j].selector.select(jSONObject2);
                        if (string == null && this.metaData.fields[j].required) continue block2;
                        stringArray2[j + 1] = string;
                        continue;
                    }
                    stringArray2[j + 1] = stringArray[j + 1];
                }
                list.add(stringArray2);
                ++n2;
            }
            if (n2 == 0) {
                list.add(stringArray);
            }
        }
    }

    public static JSONMetaData configJSONMetaDa(String string) throws UnsupportedEncodingException {
        return new JSONMetaData(string);
    }

    private static class Request {
        private final String url;
        private final File jsonFile;
        private final int paramLen;
        private final String[] stParams;
        private final String[][] dyParams;
        private final String method;
        private final String uriEncoding;

        Request(JSONObject jSONObject, int n) throws UnsupportedEncodingException {
            if (jSONObject == null) {
                throw new IllegalArgumentException("None <request> object definition");
            }
            this.url = jSONObject.getString("url");
            if (n == 1) {
                this.jsonFile = null;
                this.method = jSONObject.optString("method", "POST");
                this.uriEncoding = jSONObject.optString("uriEncoding", "UTF-8");
                JSONObject jSONObject2 = jSONObject.optJSONObject("parameters");
                if (jSONObject2 == null || jSONObject2.length() == 0) {
                    this.paramLen = 0;
                    this.stParams = null;
                    this.dyParams = null;
                } else {
                    this.paramLen = jSONObject2.length();
                    this.stParams = new String[this.paramLen];
                    this.dyParams = new String[this.paramLen][2];
                    Iterator<String> iterator = jSONObject2.keys();
                    for (int i = 0; i < this.paramLen; ++i) {
                        String string = iterator.next();
                        String string2 = jSONObject2.getString(string);
                        if (string2.charAt(0) == '^') {
                            this.dyParams[i] = new String[]{string, string2.substring(1, string2.length() - 1)};
                            continue;
                        }
                        this.stParams[i] = string + '=' + URLEncoder.encode(string2, this.uriEncoding);
                    }
                }
            } else {
                this.paramLen = -1;
                this.stParams = null;
                this.dyParams = null;
                this.uriEncoding = null;
                this.method = null;
                this.jsonFile = n == 2 ? new File(this.url) : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String doHttpRequest(String string, HttpServletRequest httpServletRequest) throws IOException {
            Object object;
            Object object2;
            String string2;
            String string3 = null;
            if (this.paramLen > 0) {
                string2 = (HttpParameterDecoder)httpServletRequest.getAttribute("paramsDecoder");
                object2 = new StringBuilder(128);
                for (int i = 0; i < this.paramLen; ++i) {
                    if (i > 0) {
                        ((StringBuilder)object2).append('&');
                    }
                    if (this.stParams[i] == null) {
                        object = string2.getParameterB(this.dyParams[i][1]);
                        ((StringBuilder)object2).append(this.dyParams[i][0]).append('=');
                        ((StringBuilder)object2).append(URLEncoder.encode((String)object, this.uriEncoding));
                        continue;
                    }
                    ((StringBuilder)object2).append(this.stParams[i]);
                }
                string3 = ((StringBuilder)object2).toString();
            }
            string2 = this.url;
            if ("GET".equals(this.method) && string3 != null) {
                string2 = this.url + '?' + string3;
            }
            object2 = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                int n;
                Closeable closeable;
                object2 = (HttpURLConnection)new URL(string2).openConnection();
                object = httpServletRequest.getSession(false);
                if (object != null) {
                    ((URLConnection)object2).addRequestProperty("Cookie", "JSESSIONID=" + object.getId());
                }
                if ("POST".equals(this.method)) {
                    if (string3 == null) {
                        string3 = "";
                    }
                    ((URLConnection)object2).setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    ((URLConnection)object2).setUseCaches(false);
                    ((URLConnection)object2).setDoOutput(true);
                    ((URLConnection)object2).setDoInput(true);
                    closeable = ((URLConnection)object2).getOutputStream();
                    ((OutputStream)closeable).write(string3.getBytes("US-ASCII"));
                    ((OutputStream)closeable).flush();
                    ((OutputStream)closeable).close();
                }
                closeable = ((URLConnection)object2).getInputStream();
                int n2 = ((URLConnection)object2).getContentLength();
                if (n2 <= 0) {
                    n2 = 8192;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
                byte[] byArray = new byte[4096];
                bufferedInputStream = new BufferedInputStream((InputStream)closeable, 8192);
                while ((n = bufferedInputStream.read(byArray, 0, 4096)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                String string4 = byteArrayOutputStream.toString(string);
                return string4;
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (object2 != null) {
                    ((HttpURLConnection)object2).disconnect();
                }
            }
        }
    }

    private static class Selector {
        private String propName;
        private String[] names;
        private int[] types;
        private int lastIdx;
        private int objectIdx;

        private Selector(JSONArray jSONArray, boolean bl, boolean bl2, Selector selector) {
            int n;
            int n2;
            if (bl2) {
                n2 = selector.names.length + 1;
                for (n = 0; n < n2; ++n) {
                    jSONArray.remove(0);
                }
            }
            if ((n2 = jSONArray.length()) == 1 && !bl) {
                this.propName = jSONArray.getString(0);
                return;
            }
            this.lastIdx = n2 - 1;
            this.names = new String[n2];
            this.types = new int[n2];
            for (n = 0; n < n2; ++n) {
                String string = jSONArray.getString(n);
                if (n == this.lastIdx) {
                    if (bl) {
                        this.names[n] = string.substring(0, string.length() - 2);
                        continue;
                    }
                    if (this.types[n - 1] == 3) {
                        this.names[n] = string;
                        this.types[n] = 1;
                        continue;
                    }
                    this.objectIdx = Integer.parseInt(string, 10);
                    this.types[n] = 2;
                    continue;
                }
                if (string.endsWith("{}")) {
                    this.names[n] = string.substring(0, string.length() - 2);
                    this.types[n] = 3;
                    continue;
                }
                if (string.endsWith("[]")) {
                    this.names[n] = string.substring(0, string.length() - 2);
                    this.types[n] = 4;
                    continue;
                }
                throw new IllegalArgumentException("Illegal Selector expression");
            }
        }

        private String select(JSONObject jSONObject) {
            if (this.propName != null) {
                return jSONObject.optString(this.propName, null);
            }
            JSONObject jSONObject2 = jSONObject;
            JSONArray jSONArray = null;
            for (int i = 0; i <= this.lastIdx; ++i) {
                if (i == this.lastIdx) {
                    if (this.types[i] == 1) {
                        return jSONObject2.optString(this.names[i], null);
                    }
                    return jSONArray.optString(this.objectIdx, null);
                }
                if (!(this.types[i] == 3 ? (jSONObject2 = jSONObject2.optJSONObject(this.names[i])) == null : (jSONArray = jSONObject2.optJSONArray(this.names[i])) == null)) continue;
                return null;
            }
            return null;
        }

        private JSONArray selectSubRecordsArray(JSONObject jSONObject) {
            JSONObject jSONObject2 = jSONObject;
            for (int i = 0; i <= this.lastIdx; ++i) {
                if (i == this.lastIdx) {
                    return jSONObject2.optJSONArray(this.names[i]);
                }
                if ((jSONObject2 = jSONObject2.optJSONObject(this.names[i])) != null) continue;
                return null;
            }
            return null;
        }
    }

    private static class FieldMeta {
        private final String name;
        private final boolean required;
        private final boolean subField;
        private final Selector selector;

        private FieldMeta(JSONObject jSONObject, Selector selector) {
            this.name = jSONObject.getString("name");
            this.required = jSONObject.optBoolean("required", false);
            this.subField = jSONObject.optBoolean("subField", false);
            this.selector = new Selector(jSONObject.getJSONArray("selector"), false, this.subField, selector);
        }
    }

    public static class JSONMetaData {
        private final int docSource;
        private final String docEncoding;
        private final Request request;
        private final boolean[] recordSelector;
        private final Selector subRecordsArraySelector;
        private final FieldMeta[] fields;

        private JSONMetaData(String string) throws UnsupportedEncodingException {
            JSONObject jSONObject = new JSONObject(string);
            String string2 = jSONObject.optString("documentSource");
            this.docSource = "HTTP".equals(string2) ? 1 : ("FILE".equals(string2) ? 2 : ("PARAM".equals(string2) ? 3 : 1));
            this.docEncoding = jSONObject.optString("documentEncoding", "UTF-8");
            this.request = new Request(jSONObject.optJSONObject("request"), this.docSource);
            JSONArray jSONArray = jSONObject.optJSONArray("recordSelector");
            this.recordSelector = new boolean[jSONArray.length()];
            for (int i = 0; i < this.recordSelector.length; ++i) {
                this.recordSelector[i] = "{}".equals(jSONArray.opt(i));
            }
            JSONObject jSONObject2 = jSONObject.optJSONObject("recordMetaData");
            if (jSONObject2 == null) {
                throw new IllegalArgumentException("None <recordMetaData> object definition");
            }
            jSONArray = jSONObject2.optJSONArray("subRecordsArraySelector");
            this.subRecordsArraySelector = jSONArray == null ? null : new Selector(jSONArray, true, false, null);
            jSONArray = jSONObject2.optJSONArray("fields");
            if (jSONArray == null) {
                throw new IllegalArgumentException("None <fields> array definition");
            }
            this.fields = new FieldMeta[jSONArray.length()];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = new FieldMeta(jSONArray.optJSONObject(i), this.subRecordsArraySelector);
            }
        }
    }

    private static class ParentArr {
        private final JSONArray arr;
        private final int nextIdx;

        private ParentArr(JSONArray jSONArray, int n) {
            this.arr = jSONArray;
            this.nextIdx = n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParentObj {
        private final JSONObject obj;
        private final Iterator<Map.Entry<String, Object>> itr;

        private ParentObj(JSONObject jSONObject, Iterator<Map.Entry<String, Object>> iterator) {
            this.obj = jSONObject;
            this.itr = iterator;
        }
    }
}

