/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.util.uds;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletRequest;

public class CSVSetHandler {
    private int currRow = 0;
    private int rowCount = 0;
    private int parsingLine;
    private int csvSource;
    private String reqMethod;
    private String[][] dataSet;
    private String[] params;
    private String param;
    private String[] values;
    private String EQ = "=";
    private String AMP = "&";
    private char NL = (char)10;
    private String csvFilePath;
    private String cgiUrl;
    private String csvString;
    private StringBuffer body;
    private StringBuffer buf;
    private String separator;
    private boolean isLocalCsv;
    private String[] fieldName;
    private String[] fieldType;
    private String encoding;
    private int numOfField;
    private String path;
    private String metaInfo;
    private boolean hasQuotation = true;
    private static final String MetaInfoDim = ":";
    private ServletRequest req;

    CSVSetHandler(String string) {
        this.csvString = string;
        this.csvSource = 0;
    }

    public CSVSetHandler(int n, String string, String string2, String string3) {
        this.param = string2;
        this.csvSource = n;
        this.path = string;
        this.reqMethod = string3;
    }

    public CSVSetHandler(int n, String string, String string2, String string3, ServletRequest servletRequest) {
        this(n, string, string2, string3);
        this.req = servletRequest;
    }

    public final boolean init(String string, String string2, String string3, int n) {
        try {
            this.separator = string2.equals("TAB") ? "\t" : (string2.equals("COMMA") ? "," : ",");
            this.encoding = string3;
            this.metaInfo = string;
            this.parsingLine = n;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final boolean makeDataSet() {
        try {
            int n;
            String string;
            StringTokenizer stringTokenizer;
            int n2;
            int n3 = 0;
            if (this.csvSource == 1) {
                this.csvFilePath = this.path;
            } else if (this.csvSource == 2) {
                this.cgiUrl = this.path;
                if (this.param != null) {
                    for (n2 = 0; n2 < this.param.length(); ++n2) {
                        if (this.param.charAt(n2) != '&') continue;
                        ++n3;
                    }
                    this.params = new String[++n3];
                    this.values = new String[n3];
                    stringTokenizer = new StringTokenizer(this.param, this.AMP);
                    for (n2 = 0; n2 < n3; ++n2) {
                        string = stringTokenizer.nextToken();
                        n = string.indexOf(this.EQ);
                        this.params[n2] = string.substring(0, n);
                        this.values[n2] = string.substring(n + 1, string.length());
                    }
                }
            } else if (this.csvSource != 0) {
                return false;
            }
            stringTokenizer = new StringTokenizer(this.metaInfo, "<");
            this.numOfField = stringTokenizer.countTokens();
            this.fieldName = new String[this.numOfField];
            this.fieldType = new String[this.numOfField];
            n = 0;
            for (n2 = 0; n2 < this.numOfField; ++n2) {
                n = this.metaInfo.indexOf("<", n);
                string = this.metaInfo.substring(n, this.metaInfo.indexOf(">", n));
                n = string.indexOf(MetaInfoDim);
                try {
                    if (n == -1) {
                        this.fieldName[n2] = new String(string.getBytes(this.encoding));
                        this.fieldType[n2] = "STR";
                        continue;
                    }
                    this.fieldName[n2] = new String(string.substring(0, string.indexOf(MetaInfoDim)).getBytes(this.encoding));
                    this.fieldType[n2] = string.substring(n + 1, string.length());
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.rowCount = 0;
                    unsupportedEncodingException.printStackTrace();
                    return false;
                }
            }
            return this.handleDataSet();
        }
        catch (Exception exception) {
            this.rowCount = 0;
            return false;
        }
    }

    private final boolean handleDataSet() {
        boolean bl;
        if (this.csvSource == 2 && !(bl = this.handleCGI())) {
            return false;
        }
        return this.handleCsvFile();
    }

    private final void setCsvFilePath(String string) {
        this.csvFilePath = string;
    }

    private final String getCsvFilePath() {
        return this.csvFilePath;
    }

    public final boolean next() {
        ++this.currRow;
        return this.rowCount >= 1 && this.rowCount >= this.currRow;
    }

    public final boolean isBeforeFirst() {
        return this.rowCount > 0 && this.currRow < 1;
    }

    public final boolean isAfterLast() {
        return this.rowCount > 0 && this.currRow > this.rowCount;
    }

    public final boolean previous() {
        --this.currRow;
        return this.rowCount >= 1 && this.currRow >= 1;
    }

    public final boolean first() {
        this.currRow = 1;
        return this.rowCount >= 1;
    }

    public final boolean last() {
        this.currRow = this.rowCount;
        return this.rowCount >= 1;
    }

    public final boolean absolute(int n) {
        this.currRow = n;
        return this.currRow > 0 && this.currRow <= this.rowCount;
    }

    public final void beforeFirst() {
        this.currRow = 0;
    }

    public final int getRow() {
        return this.currRow;
    }

    public final String getField(int n) {
        if (n < 1 || n > this.numOfField) {
            return null;
        }
        return this.dataSet[this.currRow - 1][n - 1];
    }

    public final void close() {
        this.dataSet = null;
        this.params = null;
        this.values = null;
    }

    private final boolean makeUrlEncodedData() {
        try {
            for (int i = 0; i < this.params.length; ++i) {
                if (i != 0) {
                    this.body.append(this.AMP);
                }
                this.body.append(this.params[i]);
                this.body.append(this.EQ);
                this.body.append(URLEncoder.encode(this.values[i]));
            }
            if (this.reqMethod.equals("GET")) {
                this.cgiUrl = this.cgiUrl + "?" + this.body.toString();
                this.body = new StringBuffer();
            }
            return true;
        }
        catch (Exception exception) {
            this.rowCount = 0;
            exception.printStackTrace();
            return false;
        }
    }

    private final boolean handleCGI() {
        String string = null;
        if (this.req != null) {
            string = this.getRecycleKeyName();
            this.csvString = (String)this.req.getAttribute(string);
            if (this.csvString != null) {
                return true;
            }
        }
        this.body = new StringBuffer(100);
        this.buf = new StringBuffer(50000);
        if (this.params != null) {
            this.makeUrlEncodedData();
        }
        try {
            Object object;
            URL uRL = new URL(this.cgiUrl);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            if (this.body.length() != 0) {
                httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setDoInput(true);
                object = new DataOutputStream(httpURLConnection.getOutputStream());
                ((DataOutputStream)object).writeBytes(new String(this.body.toString().getBytes(this.encoding)));
                ((DataOutputStream)object).flush();
                ((FilterOutputStream)object).close();
            }
            this.buf.setLength(0);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), this.encoding));
            while ((object = bufferedReader.readLine()) != null) {
                this.buf.append((String)object);
                this.buf.append(this.NL);
            }
            bufferedReader.close();
            httpURLConnection.disconnect();
            this.csvString = new String(this.buf.toString());
            if (this.req != null) {
                this.req.setAttribute(string, (Object)this.csvString);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private String getRecycleKeyName() {
        String string = this.path;
        if (this.csvSource == 2) {
            if (this.param != null) {
                string = string + this.param;
            }
            string = string + this.reqMethod;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean handleCsvFile() {
        boolean bl = true;
        BufferedReader bufferedReader = null;
        Vector vector = new Vector();
        Vector<String> vector2 = null;
        String string = null;
        StringBuffer stringBuffer = null;
        try {
            int n;
            String string2;
            if (this.csvSource == 1) {
                if (this.req != null) {
                    string = this.getRecycleKeyName();
                    this.csvString = (String)this.req.getAttribute(string);
                    if (this.csvString != null) {
                        bufferedReader = new BufferedReader(new StringReader(this.csvString));
                    }
                }
                if (bufferedReader == null) {
                    bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.csvFilePath)));
                    if (this.req != null) {
                        stringBuffer = new StringBuffer(20000);
                    }
                }
            } else if (this.csvSource == 2 || this.csvSource == 0) {
                bufferedReader = new BufferedReader(new StringReader(this.csvString));
            } else {
                boolean bl2 = false;
                return bl2;
            }
            int n2 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (stringBuffer != null) {
                    stringBuffer.append(string2);
                    stringBuffer.append(this.NL);
                }
                String string3 = null;
                if (this.parsingLine > ++n2 || this.countSeparator(string2, this.separator.charAt(0)) != this.numOfField - 1) continue;
                vector2 = new Vector<String>();
                for (n2 = 0; n2 < this.numOfField; ++n2) {
                    n = string2.indexOf(this.separator);
                    if (n == -1) {
                        string3 = string2.trim().equals("") ? null : string2;
                    } else {
                        string3 = n == 0 ? null : string2.substring(0, n);
                        string2 = string2.substring(n + 1, string2.length());
                    }
                    if (this.hasQuotation && string3 != null && string3.startsWith("\"")) {
                        string3 = string3.trim();
                        string3 = string3.substring(1, string3.length() - 1);
                    }
                    vector2.add(string3);
                }
                vector.add(vector2);
            }
            this.rowCount = vector.size();
            this.dataSet = new String[this.rowCount][this.numOfField];
            for (n2 = 0; n2 < this.dataSet.length; ++n2) {
                vector2 = (Vector<String>)vector.get(n2);
                if (vector2.size() != this.numOfField) {
                    this.dataSet = this.copyDataSet(this.dataSet.length - 1, n2);
                    vector.remove(n2);
                    --n2;
                    vector2 = null;
                    this.rowCount = this.dataSet.length;
                    continue;
                }
                for (n = 0; n < this.numOfField; ++n) {
                    this.dataSet[n2][n] = (String)vector2.get(n);
                }
            }
            if (stringBuffer != null) {
                this.req.setAttribute(string, (Object)stringBuffer.toString());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
            this.rowCount = 0;
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            bl = false;
            this.rowCount = 0;
            iOException.printStackTrace();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            bl = false;
            this.rowCount = 0;
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.rowCount = 0;
                bl = false;
            }
        }
        return bl;
    }

    private final String[][] copyDataSet(int n, int n2) {
        String[][] stringArray = new String[n][this.numOfField];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < this.numOfField; ++j) {
                stringArray[i][j] = this.dataSet[i][j];
            }
        }
        return stringArray;
    }

    private final int countSeparator(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    final String[][] getDataSet(String[] stringArray) {
        if (this.init(stringArray[0], stringArray[1], stringArray[2], Integer.parseInt(stringArray[3])) && this.makeDataSet()) {
            return this.dataSet;
        }
        return null;
    }

    public static void main(String[] stringArray) {
    }
}

