/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.util.uds;

import com.activeintra.util.uds.CSVSetHandler;
import com.activeintra.util.uds.XMLSetHandler;
import java.util.ArrayList;
import java.util.Vector;

public abstract class AIDataSource {
    protected String[][] dataSet;
    protected Vector userVector;
    protected String userData;
    protected ArrayList arrayList;
    protected String[] args;
    protected Object[] obj;
    protected int dataSetType;
    private String[] params;
    private int rowCount = 0;
    protected int colCount;
    private int currRow = 0;
    public static final int DT_STR_ARR = 1;
    public static final int DT_VECTOR = 2;
    public static final int DT_CSV = 3;
    public static final int DT_XML = 4;
    public static final int DT_ARR_LIST = 5;

    public AIDataSource(int n, String[] stringArray, int n2) {
        this.dataSetType = n;
        this.params = stringArray;
        this.colCount = n2;
    }

    public AIDataSource(int n, String[] stringArray, int n2, Object[] objectArray) {
        this.dataSetType = n;
        this.params = stringArray;
        this.colCount = n2;
        this.obj = objectArray;
    }

    public abstract boolean init(String[] var1);

    public boolean init(String[] stringArray, Object[] objectArray) {
        this.args = stringArray;
        this.obj = objectArray;
        return true;
    }

    public abstract boolean fetchData();

    public final boolean makeDataSet() {
        switch (this.dataSetType) {
            case 1: {
                return this.fromDefSet();
            }
            case 2: {
                return this.fromVector();
            }
            case 3: {
                return this.fromUserSet();
            }
            case 4: {
                return this.fromUserSet();
            }
            case 5: {
                return this.fromArrayList();
            }
        }
        return false;
    }

    public final boolean first() {
        this.currRow = 1;
        return this.rowCount >= 1;
    }

    public final boolean last() {
        this.currRow = this.rowCount;
        return this.rowCount >= 1;
    }

    public final boolean next() {
        ++this.currRow;
        return this.rowCount >= 1 && this.rowCount >= this.currRow;
    }

    public final boolean isBeforeFirst() {
        return this.rowCount > 0 && this.currRow < 1;
    }

    public final boolean isAfterLast() {
        return this.rowCount > 0 && this.currRow > this.rowCount;
    }

    public final boolean previous() {
        --this.currRow;
        return this.rowCount >= 1 && this.currRow >= 1;
    }

    public final boolean absolute(int n) {
        this.currRow = n;
        return this.currRow > 0 && this.currRow <= this.rowCount;
    }

    public final void beforeFirst() {
        this.currRow = 0;
    }

    public final int getRow() {
        return this.currRow;
    }

    public final String getField(int n) {
        try {
            return this.dataSet[this.currRow - 1][n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public final void close() {
        this.dataSet = null;
    }

    private final boolean fromDefSet() {
        if (this.dataSet == null) {
            return false;
        }
        this.rowCount = this.dataSet.length;
        return true;
    }

    private final boolean fromVector() {
        if (this.userVector == null) {
            return false;
        }
        int n = this.userVector.size();
        this.rowCount = n / this.colCount;
        if (this.rowCount * this.colCount != n) {
            this.rowCount = 0;
            return false;
        }
        this.dataSet = new String[this.rowCount][this.colCount];
        int n2 = 0;
        for (int i = 0; i < this.rowCount; ++i) {
            String[] stringArray = new String[this.colCount];
            for (int j = 0; j < this.colCount; ++j) {
                stringArray[j] = (String)this.userVector.elementAt(n2++);
            }
            this.dataSet[i] = stringArray;
        }
        this.userVector.removeAllElements();
        this.userVector = null;
        return true;
    }

    private final boolean fromArrayList() {
        if (this.arrayList == null) {
            return false;
        }
        int n = this.arrayList.size();
        this.rowCount = n / this.colCount;
        if (this.rowCount * this.colCount != n) {
            this.rowCount = 0;
            return false;
        }
        this.dataSet = new String[this.rowCount][this.colCount];
        int n2 = 0;
        for (int i = 0; i < this.rowCount; ++i) {
            String[] stringArray = new String[this.colCount];
            for (int j = 0; j < this.colCount; ++j) {
                stringArray[j] = (String)this.arrayList.get(n2++);
            }
            this.dataSet[i] = stringArray;
        }
        this.arrayList.clear();
        this.arrayList = null;
        return true;
    }

    private final boolean fromUserSet() {
        if (this.userData == null) {
            return false;
        }
        if (this.dataSetType == 3) {
            CSVSetHandler cSVSetHandler = new CSVSetHandler(this.userData);
            this.dataSet = cSVSetHandler.getDataSet(this.params);
        } else if (this.dataSetType == 4) {
            XMLSetHandler xMLSetHandler = new XMLSetHandler(this.userData);
            this.dataSet = xMLSetHandler.getDataSet(this.params);
        }
        this.userData = null;
        if (this.dataSet == null) {
            return false;
        }
        this.rowCount = this.dataSet.length;
        return true;
    }
}

