/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.util;

import com.nexacro.xapi.data.DataSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.log4j.Logger;

public final class AIReportNexacro {
    private static Logger logger = Logger.getLogger((String)"AIReportNexacro");
    private static final String mapKey = "aireport.nexaSaveMap";
    public static File saveBaseDir;

    private AIReportNexacro() {
    }

    public static void cleanupUserDataFiles(HttpSession httpSession) {
        if (httpSession != null) {
            try {
                httpSession.removeAttribute(mapKey);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public static void cleanupStaleDataFiles() {
        final File[] fileArray = saveBaseDir.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        final long l = System.currentTimeMillis();
        new Thread(new Runnable(){
            int deleted = 0;

            public void run() {
                for (File file : fileArray) {
                    Thread.yield();
                    File[] fileArray2 = file.listFiles();
                    if (fileArray2 == null || fileArray2.length == 0) continue;
                    for (File file2 : fileArray2) {
                        if (l - file2.lastModified() <= 9000000L) continue;
                        file2.delete();
                        ++this.deleted;
                    }
                }
                if (this.deleted > 0) {
                    logger.info((Object)("Deleted dataFiles: " + this.deleted));
                }
            }
        }).start();
    }

    public static String getDataSetSaveID() {
        return UUID.randomUUID().toString();
    }

    public static String saveDataSet(DataSet dataSet, HttpServletRequest httpServletRequest) throws IOException {
        return AIReportNexacro.saveDataSet(dataSet.getAlias(), dataSet.saveXml(), httpServletRequest);
    }

    public static String saveDataSet(String string, String string2, HttpServletRequest httpServletRequest) throws IOException {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            throw new IllegalStateException("None Session");
        }
        String string3 = AIReportNexacro.getDataSetSaveID();
        AIReportNexacro.saveDataFile(string3, string, string2);
        boolean bl = false;
        SavedFileMap savedFileMap = (SavedFileMap)httpSession.getAttribute(mapKey);
        if (savedFileMap == null) {
            savedFileMap = new SavedFileMap();
            bl = true;
        }
        savedFileMap.add(string3, string);
        if (bl) {
            httpSession.setAttribute(mapKey, (Object)savedFileMap);
        }
        return string3;
    }

    public static void addDataSet(DataSet dataSet, String string, HttpServletRequest httpServletRequest) throws IOException {
        int n;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            throw new IllegalStateException("None Session");
        }
        boolean bl = false;
        SavedFileMap savedFileMap = (SavedFileMap)httpSession.getAttribute(mapKey);
        if (savedFileMap == null) {
            savedFileMap = new SavedFileMap();
            bl = true;
        }
        String string2 = (n = savedFileMap.getSavedCount(string)) == 0 ? string : string + (n + 1);
        String string3 = dataSet.getAlias();
        AIReportNexacro.saveDataFile(string2, string3, dataSet.saveXml());
        savedFileMap.add(string, string3);
        if (bl) {
            httpSession.setAttribute(mapKey, (Object)savedFileMap);
        }
    }

    private static void saveDataFile(String string, String string2, String string3) throws IOException {
        if (saveBaseDir == null) {
            throw new IllegalStateException("Working-dir not configed");
        }
        File file = new File(saveBaseDir, string2);
        if (!file.exists() && !file.mkdir()) {
            throw new UnsupportedOperationException("Failed to mkdir: " + file.getPath());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(new File(file, string));
        fileOutputStream.write(string3.getBytes("UTF-8"));
        fileOutputStream.close();
    }

    public static File[] getSavedDataSetFiles(String string, HttpServletRequest httpServletRequest) {
        if (saveBaseDir == null) {
            throw new IllegalStateException("Working-dir not configed");
        }
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession == null) {
            throw new IllegalStateException("None Session");
        }
        SavedFileMap savedFileMap = (SavedFileMap)httpSession.getAttribute(mapKey);
        if (savedFileMap == null) {
            throw new IllegalStateException("Session mismatching");
        }
        int n = savedFileMap.getSavedCount(string);
        if (n == 0) {
            throw new IllegalStateException("None saveFile for id: " + string);
        }
        File file = new File(saveBaseDir, (String)savedFileMap.idDirMap.get(string));
        if (n == 1) {
            return new File[]{new File(file, string)};
        }
        File[] fileArray = new File[n];
        fileArray[0] = new File(file, string);
        for (int i = 2; i <= n; ++i) {
            fileArray[i - 1] = new File(file, string + i);
        }
        return fileArray;
    }

    public static class SavedFileMap
    implements HttpSessionBindingListener {
        private final Map<String, Integer> idCountMap = new HashMap<String, Integer>();
        private final Map<String, String> idDirMap = new HashMap<String, String>();

        private SavedFileMap() {
        }

        private synchronized void add(String string, String string2) {
            Integer n = this.idCountMap.get(string);
            if (n == null) {
                n = new Integer(1);
                this.idDirMap.put(string, string2);
            } else {
                n = new Integer(n + 1);
            }
            this.idCountMap.put(string, n);
        }

        private synchronized int getSavedCount(String string) {
            Integer n = this.idCountMap.get(string);
            if (n == null) {
                return 0;
            }
            return n;
        }

        public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
        }

        public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
            if (this.idCountMap.isEmpty()) {
                return;
            }
            for (String string : this.idCountMap.keySet()) {
                File file = new File(saveBaseDir, this.idDirMap.get(string));
                if (!file.exists()) continue;
                int n = this.idCountMap.get(string);
                new File(file, string).delete();
                for (int i = 2; i <= n; ++i) {
                    new File(file, string + i).delete();
                }
            }
        }
    }
}

