/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.util;

import com.activeintra.util.AIGzipOutStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

class AIGzipWrapper
extends HttpServletResponseWrapper {
    private HttpServletResponse originResponse;
    private ServletOutputStream stream;
    private PrintWriter writer;
    private boolean debug = false;

    AIGzipWrapper(HttpServletResponse httpServletResponse) throws IOException {
        super(httpServletResponse);
        this.originResponse = httpServletResponse;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called for this response");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called for this response");
        }
        this.stream = this.createOutputStream();
        this.writer = new PrintWriter((OutputStream)this.stream);
        return this.writer;
    }

    private ServletOutputStream createOutputStream() throws IOException {
        AIGzipOutStream aIGzipOutStream = new AIGzipOutStream(this.originResponse);
        if (this.debug) {
            aIGzipOutStream.setDebug(this.debug);
        }
        return aIGzipOutStream;
    }

    public void setContentLength(int n) {
    }

    void finishResponse() {
        try {
            if (this.writer != null) {
                this.writer.close();
            } else if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void setDebug(boolean bl) {
        this.debug = bl;
    }
}

