/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

class AIGzipOutStream
extends ServletOutputStream {
    private HttpServletResponse originRes;
    private ServletOutputStream originOut;
    private boolean closed = false;
    private ByteArrayOutputStream byteOut;
    private boolean debug = false;

    AIGzipOutStream(HttpServletResponse httpServletResponse) throws IOException {
        this.originRes = httpServletResponse;
        this.originOut = httpServletResponse.getOutputStream();
        this.byteOut = new ByteArrayOutputStream(70000);
    }

    public void write(int n) throws IOException {
        this.byteOut.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.byteOut.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.byteOut.write(byArray, n, n2);
    }

    public void flush() {
    }

    public void close() throws IOException {
        if (!this.closed) {
            int n = this.byteOut.size();
            if (this.debug) {
                // empty if block
            }
            n = (int)((float)n * 0.7f);
            this.originRes.addHeader("Content-Encoding", "gzip");
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)this.originOut, n);
            this.byteOut.writeTo(gZIPOutputStream);
            gZIPOutputStream.finish();
            gZIPOutputStream.close();
            this.originOut.close();
            this.closed = true;
        }
    }

    void setDebug(boolean bl) {
        this.debug = bl;
    }
}

