/*
 * Decompiled with CFR 0.152.
 */
package ChartDirector;

import ChartDirector.BaseMeter;
import ChartDirector.DrawArea;
import ChartDirector.MeterPointer;
import ChartDirector.TextBox;
import ChartDirector.ce;
import ChartDirector.dw;
import ChartDirector.ia;

public class LinearMeter
extends BaseMeter {
    private int x;
    private int y;
    private int z;
    private int A;
    private int B;
    private boolean C;
    private int D = 6;
    private int E = -65535;
    private int F = 2;

    public LinearMeter(int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5, n6);
        this.setLabelStyle("bold", 8.0).setAlignment(-1);
        this.setTickLength(Short.MAX_VALUE, 32766, 32765);
        this.setLabelPos(false, 0);
        this.setLineWidth(2, 2, 1, 1);
        this.setMeterColors(-16777216, -65534, -65535);
    }

    public LinearMeter(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, 0);
    }

    public LinearMeter(int n2, int n3, int n4) {
        this(n2, n3, n4, -16777216, 0);
    }

    public LinearMeter(int n2, int n3) {
        this(n2, n3, -65536, -16777216, 0);
    }

    public void setMeter(int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        this.x = n2;
        this.y = n3;
        this.z = n4;
        this.A = n5;
        this.B = n6;
        this.C = bl2;
    }

    public void setMeter(int n2, int n3, int n4, int n5, int n6) {
        this.setMeter(n2, n3, n4, n5, n6, false);
    }

    public void setMeter(int n2, int n3, int n4, int n5) {
        this.setMeter(n2, n3, n4, n5, 4, false);
    }

    public void setRail(int n2, int n3, int n4) {
        this.E = n2;
        this.F = n3;
        this.D = n4;
    }

    public void setRail(int n2, int n3) {
        this.setRail(n2, n3, 6);
    }

    public void setRail(int n2) {
        this.setRail(n2, 2, 10);
    }

    public TextBox addZone(double d2, double d3, int n2, String string) {
        ia ia2 = new ia(this, d2, d3, n2, string);
        this.a(ia2).setZOrder(4095);
        return ia2;
    }

    public TextBox addZone(double d2, double d3, int n2) {
        return this.addZone(d2, d3, n2, null);
    }

    private boolean e() {
        return this.B == 8 || this.B == 2;
    }

    MeterPointer a(double d2, int n2, int n3) {
        return new ce(this, d2, n2, n3);
    }

    double a(double d2) {
        double d3 = (d2 - this.c) / (this.d - this.c);
        if (this.C ^ !this.e()) {
            d3 = 1.0 - d3;
        }
        if (this.e()) {
            return (double)this.x + d3 * (double)this.z;
        }
        return (double)this.y + d3 * (double)this.A;
    }

    void a(DrawArea drawArea, int n2, int n3) {
        switch (this.B) {
            case 8: {
                drawArea.line(this.x, this.y, this.x + this.z, this.y, n2, n3);
                drawArea.line(this.x - 3, this.y + this.A + this.D, this.x + this.z + 3, this.y + this.A + this.D, this.E, this.F);
                break;
            }
            case 2: {
                drawArea.line(this.x, this.y + this.A, this.x + this.z, this.y + this.A, n2, n3);
                drawArea.line(this.x - 3, this.y - this.D, this.x + this.z + 3, this.y - this.D, this.E, this.F);
                break;
            }
            case 6: {
                drawArea.line(this.x + this.z, this.y, this.x + this.z, this.y + this.A, n2, n3);
                drawArea.line(this.x - this.D, this.y - 3, this.x - this.D, this.y + this.A + 3, this.E, this.F);
                break;
            }
            default: {
                drawArea.line(this.x, this.y, this.x, this.y + this.A, n2, n3);
                drawArea.line(this.x + this.z + this.D, this.y - 3, this.x + this.z + this.D, this.y + this.A + 3, this.E, this.F);
            }
        }
    }

    int c(int n2) {
        if (n2 == Short.MAX_VALUE) {
            return this.e() ? -this.A : -this.z;
        }
        if (n2 == 32766) {
            return this.c(Short.MAX_VALUE) * 6 / 10;
        }
        if (n2 == 32765) {
            return this.c(Short.MAX_VALUE) * 3 / 10;
        }
        return n2;
    }

    void a(DrawArea drawArea, double d2, int n2, int n3, int n4) {
        if ((n2 = this.c(n2)) == 0 || n3 <= 0 || n4 == -16777216) {
            return;
        }
        double d3 = this.a(d2);
        switch (this.B) {
            case 8: {
                drawArea.line(d3, this.y, d3, this.y - n2, n4, n3);
                break;
            }
            case 2: {
                drawArea.line(d3, this.y + this.A, d3, this.y + this.A + n2, n4, n3);
                break;
            }
            case 6: {
                drawArea.line(this.x + this.z, d3, this.x + this.z + n2, d3, n4, n3);
                break;
            }
            default: {
                drawArea.line(this.x, d3, this.x - n2, d3, n4, n3);
            }
        }
    }

    void a(DrawArea drawArea, dw dw2, double d2) {
        int n2 = 0;
        int n3 = this.c(this.i);
        n2 = this.g ? (n3 < 0 ? n3 - this.f : -this.f) : (n3 > 0 ? n3 + this.f : this.f);
        switch (this.B) {
            case 8: {
                dw2.setPos(this.getCoor(d2) + dw2.g, this.y - n2 + dw2.h);
                if (dw2.v != -1) break;
                dw2.v = this.g ? 8 : 2;
                break;
            }
            case 2: {
                dw2.setPos(this.getCoor(d2) + dw2.g, this.y + this.A + n2 + dw2.h);
                if (dw2.v != -1) break;
                dw2.v = this.g ? 2 : 8;
                break;
            }
            case 6: {
                dw2.setPos(this.x + this.z + n2 + dw2.g, this.getCoor(d2) + dw2.h);
                if (dw2.v != -1) break;
                dw2.v = this.g ? 6 : 4;
                break;
            }
            default: {
                dw2.setPos(this.x - n2 + dw2.g, this.getCoor(d2) + dw2.h);
                if (dw2.v != -1) break;
                dw2.v = this.g ? 4 : 6;
            }
        }
        dw2.a(drawArea);
    }

    static boolean a(LinearMeter linearMeter) {
        return linearMeter.e();
    }

    static int b(LinearMeter linearMeter) {
        return linearMeter.A;
    }

    static int c(LinearMeter linearMeter) {
        return linearMeter.y;
    }

    static int d(LinearMeter linearMeter) {
        return linearMeter.z;
    }

    static int e(LinearMeter linearMeter) {
        return linearMeter.x;
    }

    static int f(LinearMeter linearMeter) {
        return linearMeter.B;
    }

    static int g(LinearMeter linearMeter) {
        return linearMeter.D;
    }
}

