/*
 * Decompiled with CFR 0.152.
 */
package ChartDirector;

import ChartDirector.ArrayMath;
import ChartDirector.Axis;
import ChartDirector.BarLayer;
import ChartDirector.Box;
import ChartDirector.CandleStickLayer;
import ChartDirector.Chart;
import ChartDirector.DataSet;
import ChartDirector.HLOCLayer;
import ChartDirector.InterLineLayer;
import ChartDirector.LineLayer;
import ChartDirector.Mark;
import ChartDirector.MultiChart;
import ChartDirector.TextBox;
import ChartDirector.XYChart;
import ChartDirector.dw;
import java.util.Date;

public class FinanceChart
extends MultiChart {
    int a = 0;
    int b = 0;
    boolean c = true;
    boolean d = false;
    boolean e = true;
    int f = 40;
    int g = 40;
    int h = 30;
    int i = 30;
    int j = 0xFFFFFF;
    int k = 0x888888;
    int l = 2;
    int m = 0xDDDDDD;
    int n = 0xDDDDDD;
    int o = 0xDDDDDD;
    int p = 0xDDDDDD;
    String q = "normal";
    double x = 8.0;
    int y = -65534;
    int z = -2134061876;
    String A = "normal";
    double B = 8.0;
    int C = -65534;
    int D = 14;
    String E = "normal";
    double F = 8.0;
    int G = -65534;
    double H = 0.0;
    double[] I = null;
    double[] J = null;
    double[] K = null;
    double[] L = null;
    double[] M = null;
    double[] N = null;
    String O = "";
    int P = 0;
    String Q = "{value|yyyy}";
    String R = "<*font=bold*>{value|mmm yy}";
    String S = "{value|mmm}";
    String T = "<*font=bold*>{value|d mmm}";
    String U = "{value|d}";
    String V = "<*font=bold*>{value|d mmm\nh:nna}";
    String W = "{value|h:nna}";
    int X = 50;
    String Y = "P3";
    String Z = "[{xLabel|mmm yyyy}]";
    String aa = "[{xLabel|mmm d, yyyy}]";
    String ab = "[{xLabel|mmm d, yyyy hh:nn:ss}]";
    XYChart ac = null;
    XYChart ad = null;

    public FinanceChart(int n2) {
        super(n2, 1);
        this.a = n2;
        this.setMainChart(this);
    }

    public void enableAntiAlias(boolean bl2) {
        this.c = bl2;
    }

    public void setMargins(int n2, int n3, int n4, int n5) {
        this.f = n2;
        this.g = n4;
        this.h = n3;
        this.i = n5;
    }

    public TextBox addPlotAreaTitle(int n2, String string) {
        TextBox textBox = this.addText(this.f, 0, string, "bold", 10.0, -65534, n2);
        textBox.setSize(this.a - this.f - this.g + 1, this.h - 1);
        textBox.setMargin(0);
        return textBox;
    }

    public void setPlotAreaStyle(int n2, int n3, int n4, int n5, int n6) {
        this.j = n2;
        this.m = n3;
        this.o = n4;
        this.n = n5;
        this.p = n6;
    }

    public void setPlotAreaBorder(int n2, int n3) {
        this.k = n2;
        this.l = n3;
    }

    public void setLegendStyle(String string, double d2, int n2, int n3) {
        this.q = string;
        this.x = d2;
        this.y = n2;
        this.z = n3;
    }

    public void setXAxisStyle(String string, double d2, int n2, double d3) {
        this.E = string;
        this.F = d2;
        this.G = n2;
        this.H = d3;
    }

    public void setYAxisStyle(String string, double d2, int n2, int n3) {
        this.A = string;
        this.B = d2;
        this.C = n2;
        this.D = n3;
    }

    public void setAxisOnRight(boolean bl2) {
        this.e = bl2;
    }

    public void setLogScale(boolean bl2) {
        this.d = bl2;
        if (this.ac != null) {
            if (this.d) {
                this.ac.yAxis().setLogScale();
            } else {
                this.ac.yAxis().setLinearScale();
            }
        }
    }

    public void setDateLabelFormat(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        if (string != null) {
            this.Q = string;
        }
        if (string2 != null) {
            this.R = string2;
        }
        if (string3 != null) {
            this.S = string3;
        }
        if (string4 != null) {
            this.T = string4;
        }
        if (string5 != null) {
            this.U = string5;
        }
        if (string6 != null) {
            this.V = string6;
        }
        if (string7 != null) {
            this.W = string7;
        }
    }

    public void setDateLabelSpacing(int n2) {
        this.X = n2 > 0 ? n2 : 0;
    }

    public void setToolTipDateFormat(String string, String string2, String string3) {
        if (string != null) {
            this.Z = string;
        }
        if (string2 != null) {
            this.aa = string2;
        }
        if (string3 != null) {
            this.ab = string3;
        }
    }

    public String getToolTipDateFormat() {
        if (this.I == null) {
            return this.ab;
        }
        if (this.I.length <= this.P) {
            return this.ab;
        }
        double d2 = (this.I[this.I.length - 1] - this.I[0]) / (double)this.I.length;
        if (d2 >= 2592000.0) {
            return this.Z;
        }
        if (d2 >= 86400.0) {
            return this.aa;
        }
        return this.ab;
    }

    public void setNumberLabelFormat(String string) {
        if (string != null) {
            this.Y = string;
        }
    }

    private double[] a(double[] dArray, int n2) {
        int n3 = n2 / 2 + 1;
        return new ArrayMath(dArray).movAvg(n3).movAvg(n3).result();
    }

    private double[] b(double[] dArray, int n2) {
        ArrayMath arrayMath = new ArrayMath(dArray);
        int n3 = 2;
        while (n3 < n2 + 1) {
            arrayMath.add(new ArrayMath(dArray).movAvg(n3).mul(n3).result());
            ++n3;
        }
        return arrayMath.div((1 + n2) * n2 / 2).result();
    }

    private double a() {
        int n2 = this.P;
        while (n2 < this.M.length) {
            if (this.M[n2] != 1.7E308 && this.M[n2] != 0.0) {
                return this.M[n2];
            }
            ++n2;
        }
        return 1.7E308;
    }

    private int a(double[] dArray) {
        int n2 = dArray.length - 1;
        while (n2 >= 0) {
            if (dArray[n2] != 1.7E308) break;
            --n2;
        }
        return n2;
    }

    public void setData(Date[] dateArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int n2) {
        this.setData(Chart.CTime(dateArray), dArray, dArray2, dArray3, dArray4, dArray5, n2);
    }

    public void setData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, int n2) {
        this.I = dArray;
        this.J = dArray2;
        this.K = dArray3;
        this.L = dArray4;
        this.M = dArray5;
        this.P = n2 > 0 ? n2 : 0;
        double d2 = new ArrayMath(dArray6).max();
        String[] stringArray = new String[]{"", "K", "M", "B"};
        int n3 = stringArray.length - 1;
        while (n3 > 0 && d2 < Math.pow(1000.0, n3)) {
            --n3;
        }
        this.N = new ArrayMath(dArray6).div(Math.pow(1000.0, n3)).result();
        this.O = stringArray[n3];
    }

    private void a(Axis axis) {
        axis.setLabels2(this.I);
        if (this.P < this.I.length) {
            int n2 = (this.I.length - this.P) * this.X / (this.a - this.f - this.g) + 1;
            double d2 = this.I[this.I.length - 1] - this.I[this.P];
            double d3 = d2 / (double)(this.a - this.f - this.g) * (double)this.X;
            if (d3 * (double)(this.I.length - this.P) <= d2) {
                n2 = 1;
                d3 = this.I.length > 1 ? this.I[this.I.length - 1] - this.I[this.I.length - 2] : 86400.0;
            }
            if (d3 > 3.1104E7 || d3 > 7776000.0 && d2 >= 6.2208E7) {
                axis.setMultiFormat2(Chart.StartOfYearFilter(), this.Q, n2);
            } else if (d3 >= 2592000.0 || d3 > 604800.0 && d2 >= 5184000.0) {
                int n3 = (int)(d3 / 31.0 / 86400.0) + 1;
                axis.setMultiFormat(Chart.StartOfYearFilter(), this.R, Chart.StartOfMonthFilter(n3), this.S);
                axis.setMultiFormat2(Chart.StartOfMonthFilter(), "-", 1, false);
            } else if (d3 >= 86400.0 || d3 > 21600.0 && d2 >= 86400.0) {
                axis.setMultiFormat(Chart.StartOfMonthFilter(), this.T, Chart.StartOfDayFilter(1, 0.5), this.U, n2);
            } else {
                axis.setMultiFormat(Chart.StartOfDayFilter(1, 0.5), this.V, Chart.StartOfHourFilter(1, 0.5), this.W, n2);
            }
        }
    }

    private String e() {
        return "title='" + this.getToolTipDateFormat() + " Op:{open|" + this.Y + "}, Hi:{high|" + this.Y + "}, Lo:{low|" + this.Y + "}, Cl:{close|" + this.Y + "}'";
    }

    public XYChart addMainChart(int n2) {
        this.ac = this.addIndicator(n2);
        this.ac.yAxis().setMargin(2 * this.D);
        if (this.d) {
            this.ac.yAxis().setLogScale();
        } else {
            this.ac.yAxis().setLinearScale();
        }
        return this.ac;
    }

    public CandleStickLayer addCandleStick(int n2, int n3) {
        int n4;
        this.a(n2, n3, true);
        CandleStickLayer candleStickLayer = this.ac.addCandleStickLayer(this.J, this.K, this.L, this.M, n2, n3);
        candleStickLayer.setHTMLImageMap("", "", this.e());
        if (this.J.length - this.P > 60) {
            candleStickLayer.setDataGap(0.0);
        }
        if (this.J.length > this.P && (n4 = (this.a - this.f - this.g) / (this.J.length - this.P)) <= 5) {
            candleStickLayer.setDataWidth(n4 + 1 - n4 % 2);
        }
        return candleStickLayer;
    }

    public HLOCLayer addHLOC(int n2, int n3) {
        this.a(n2, n3, false);
        HLOCLayer hLOCLayer = this.ac.addHLOCLayer(this.J, this.K, this.L, this.M);
        hLOCLayer.setColorMethod(2, n2, n3);
        hLOCLayer.setHTMLImageMap("", "", this.e());
        hLOCLayer.setDataGap(0.0);
        return hLOCLayer;
    }

    private void a(int n2, int n3, boolean bl2) {
        int n4 = this.a(this.M);
        if (n4 >= 0) {
            boolean bl3;
            double d2 = 1.7E308;
            double d3 = 1.7E308;
            double d4 = 1.7E308;
            double d5 = 1.7E308;
            if (n4 < this.L.length) {
                d2 = this.L[n4];
            }
            if (n4 < this.M.length) {
                d3 = this.M[n4];
            }
            if (n4 < this.J.length) {
                d4 = this.J[n4];
            }
            if (n4 < this.K.length) {
                d5 = this.K[n4];
            }
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            if (d2 != 1.7E308) {
                string = "Op:" + this.formatValue(d2, this.Y);
                string5 = ", ";
            }
            if (d4 != 1.7E308) {
                string3 = String.valueOf(string5) + "Hi:" + this.formatValue(d4, this.Y);
                string5 = ", ";
            }
            if (d5 != 1.7E308) {
                string4 = String.valueOf(string5) + "Lo:" + this.formatValue(d5, this.Y);
                string5 = ", ";
            }
            if (d3 != 1.7E308) {
                string2 = String.valueOf(string5) + "Cl:" + this.formatValue(d3, this.Y);
                string5 = ", ";
            }
            String string6 = String.valueOf(string) + string3 + string4 + string2;
            boolean bl4 = bl3 = d3 >= d2;
            if (!bl2) {
                double[] dArray = new ArrayMath(this.M).delta().result();
                int n5 = this.a(dArray);
                boolean bl5 = bl3 = n5 < 0;
                if (!bl3) {
                    bl3 = dArray[n5] >= 0.0;
                }
            }
            int n6 = n3;
            if (bl3) {
                n6 = n2;
            }
            this.ac.getLegend().addKey(string6, n6);
        }
    }

    public LineLayer addCloseLine(int n2) {
        return this.addLineIndicator2(this.ac, this.M, n2, "Closing Price");
    }

    public LineLayer addWeightedClose(int n2) {
        return this.addLineIndicator2(this.ac, new ArrayMath(this.J).add(this.K).add(this.M).add(this.M).div(4.0).result(), n2, "Weighted Close");
    }

    public LineLayer addTypicalPrice(int n2) {
        return this.addLineIndicator2(this.ac, new ArrayMath(this.J).add(this.K).add(this.M).div(3.0).result(), n2, "Typical Price");
    }

    public LineLayer addMedianPrice(int n2) {
        return this.addLineIndicator2(this.ac, new ArrayMath(this.J).add(this.K).div(2.0).result(), n2, "Median Price");
    }

    public LineLayer addSimpleMovingAvg(int n2, int n3) {
        String string = "SMA (" + n2 + ")";
        return this.addLineIndicator2(this.ac, new ArrayMath(this.M).movAvg(n2).result(), n3, string);
    }

    public LineLayer addExpMovingAvg(int n2, int n3) {
        String string = "EMA (" + n2 + ")";
        return this.addLineIndicator2(this.ac, new ArrayMath(this.M).expAvg(2.0 / (double)(n2 + 1)).result(), n3, string);
    }

    public LineLayer addTriMovingAvg(int n2, int n3) {
        String string = "TMA (" + n2 + ")";
        return this.addLineIndicator2(this.ac, new ArrayMath(this.a(this.M, n2)).result(), n3, string);
    }

    public LineLayer addWeightedMovingAvg(int n2, int n3) {
        String string = "WMA (" + n2 + ")";
        return this.addLineIndicator2(this.ac, new ArrayMath(this.b(this.M, n2)).result(), n3, string);
    }

    public LineLayer addParabolicSAR(double d2, double d3, double d4, int n2, int n3, int n4, int n5) {
        boolean bl2 = true;
        double d5 = d2;
        double d6 = 0.0;
        double[] dArray = new double[this.K.length];
        int n6 = -1;
        int n7 = -1;
        int n8 = 0;
        while (n8 < this.K.length) {
            dArray[n8] = 1.7E308;
            if (this.K[n8] != 1.7E308 && this.J[n8] != 1.7E308) {
                if (n6 >= 0 && n7 < 0) {
                    if (this.K[n6] <= this.K[n8]) {
                        dArray[n8] = this.K[n6];
                        bl2 = true;
                        d6 = this.J[n6] > this.J[n8] ? this.J[n6] : this.J[n8];
                    } else {
                        d6 = this.K[n8];
                        bl2 = false;
                        dArray[n8] = this.J[n6] > this.J[n8] ? this.J[n6] : this.J[n8];
                    }
                } else if (n6 >= 0 && n7 >= 0) {
                    if (d5 > d4) {
                        d5 = d4;
                    }
                    dArray[n8] = dArray[n6] + d5 * (d6 - dArray[n6]);
                    if (bl2) {
                        if (this.K[n8] < dArray[n8]) {
                            bl2 = false;
                            dArray[n8] = d6;
                            d6 = this.K[n8];
                            d5 = d2;
                        } else {
                            if (this.J[n8] > d6) {
                                d6 = this.J[n8];
                                d5 += d3;
                            }
                            if (this.K[n6] < dArray[n8]) {
                                dArray[n8] = this.K[n6];
                            }
                            if (this.K[n7] < dArray[n8]) {
                                dArray[n8] = this.K[n7];
                            }
                        }
                    } else if (this.J[n8] > dArray[n8]) {
                        bl2 = true;
                        dArray[n8] = d6;
                        d6 = this.J[n8];
                        d5 = d2;
                    } else {
                        if (this.K[n8] < d6) {
                            d6 = this.K[n8];
                            d5 += d3;
                        }
                        if (this.J[n6] > dArray[n8]) {
                            dArray[n8] = this.J[n6];
                        }
                        if (this.J[n7] > dArray[n8]) {
                            dArray[n8] = this.J[n7];
                        }
                    }
                }
                n7 = n6;
                n6 = n8;
            }
            ++n8;
        }
        LineLayer lineLayer = this.addLineIndicator2(this.ac, dArray, n4, "Parabolic SAR");
        lineLayer.setLineWidth(0);
        lineLayer = this.addLineIndicator2(this.ac, dArray, n4, "");
        lineLayer.setLineWidth(0);
        lineLayer.getDataSet(0).setDataSymbol(n2, n3, n4, n5);
        return lineLayer;
    }

    public LineLayer addComparison(double[] dArray, int n2, String string) {
        int n3 = this.P;
        while (n3 < dArray.length && n3 < this.M.length) {
            if (dArray[n3] != 1.7E308 && this.M[n3] != 1.7E308 && dArray[n3] != 0.0 && this.M[n3] != 0.0) break;
            ++n3;
        }
        if (n3 >= dArray.length || n3 >= this.M.length) {
            return null;
        }
        double d2 = this.M[n3] / dArray[n3];
        LineLayer lineLayer = this.ac.addLineLayer(new ArrayMath(dArray).mul(d2).result(), -16777216);
        lineLayer.setHTMLImageMap("{disable}");
        Axis axis = this.ac.addAxis(6, 0);
        axis.setColors(-16777216, -16777216);
        axis.syncAxis(this.ac.yAxis(), 1.0 / d2, 0.0);
        LineLayer lineLayer2 = this.addLineIndicator2(this.ac, dArray, n2, string);
        lineLayer2.setUseYAxis(axis);
        return lineLayer2;
    }

    public Axis setPercentageAxis() {
        double d2 = this.a();
        if (d2 == 1.7E308) {
            return null;
        }
        int n2 = 4;
        if (this.e) {
            n2 = 6;
        }
        Axis axis = this.ac.addAxis(n2, 0);
        this.a(axis, 300);
        axis.syncAxis(this.ac.yAxis(), 100.0 / d2);
        axis.setRounding(false, false);
        axis.setLabelFormat("{={value}-100|@}%");
        this.ac.yAxis().setColors(-16777216, -16777216);
        this.ac.getPlotArea().setGridAxis(null, axis);
        return axis;
    }

    public InterLineLayer addBand(double[] dArray, double[] dArray2, int n2, int n3, String string) {
        int n4 = dArray.length - 1;
        if (n4 >= dArray2.length) {
            n4 = dArray2.length - 1;
        }
        while (n4 >= 0) {
            if (dArray[n4] != 1.7E308 && dArray2[n4] != 1.7E308) {
                string = String.valueOf(string) + ": " + this.formatValue(dArray2[n4], this.Y) + " - " + this.formatValue(dArray[n4], this.Y);
                break;
            }
            --n4;
        }
        LineLayer lineLayer = this.ac.addLineLayer2();
        lineLayer.addDataSet(dArray, n2, string);
        lineLayer.addDataSet(dArray2, n2);
        return this.ac.addInterLineLayer(lineLayer.getLine(0), lineLayer.getLine(1), n3);
    }

    public InterLineLayer addBollingerBand(int n2, double d2, int n3, int n4) {
        double[] dArray = new ArrayMath(this.M).movStdDev(n2).mul(d2).result();
        double[] dArray2 = new ArrayMath(this.M).movAvg(n2).result();
        String string = "Bollinger (" + n2 + ", " + d2 + ")";
        return this.addBand(new ArrayMath(dArray2).add(dArray).result(), new ArrayMath(dArray2).sub(dArray).selectGTZ(null, 0.0).result(), n3, n4, string);
    }

    public InterLineLayer addDonchianChannel(int n2, int n3, int n4) {
        String string = "Donchian (" + n2 + ")";
        return this.addBand(new ArrayMath(this.J).movMax(n2).result(), new ArrayMath(this.K).movMin(n2).result(), n3, n4, string);
    }

    public InterLineLayer addEnvelop(int n2, double d2, int n3, int n4) {
        double[] dArray = new ArrayMath(this.M).movAvg(n2).result();
        String string = "Envelop (SMA " + n2 + " +/- " + (int)(d2 * 100.0) + "%)";
        return this.addBand(new ArrayMath(dArray).mul(1.0 + d2).result(), new ArrayMath(dArray).mul(1.0 - d2).result(), n3, n4, string);
    }

    public BarLayer addVolBars(int n2, int n3, int n4, int n5) {
        return this.a(this.ac, n2, n3, n4, n5);
    }

    private BarLayer a(XYChart xYChart, int n2, int n3, int n4, int n5) {
        BarLayer barLayer = xYChart.addBarLayer2(0);
        barLayer.setBorderColor(-16777216);
        if (xYChart == this.ac) {
            this.a(xYChart.yAxis2(), n2);
            int n6 = xYChart.getDrawArea().getHeight() - this.h - this.i - n2 + this.D;
            if (n6 < 0) {
                n6 = 0;
            }
            xYChart.yAxis2().setTopMargin(n6);
            barLayer.setUseYAxis2();
        }
        Axis axis = xYChart.yAxis2();
        if (xYChart != this.ac) {
            axis = xYChart.yAxis();
        }
        ArrayMath arrayMath = new ArrayMath(this.N);
        if (arrayMath.max() < 10.0) {
            axis.setLabelFormat("{value|1}" + this.O);
        } else {
            axis.setLabelFormat("{value}" + this.O);
        }
        double[] dArray = new ArrayMath(this.M).delta().replace(1.7E308, 0.0).result();
        int n7 = this.a(this.N);
        String string = "Vol";
        if (n7 >= 0) {
            string = String.valueOf(string) + ": " + this.formatValue(this.N[n7], this.Y) + this.O;
        }
        DataSet dataSet = barLayer.addDataSet(new ArrayMath(this.N).selectGTZ(dArray).result(), n3);
        DataSet dataSet2 = barLayer.addDataSet(new ArrayMath(this.N).selectLTZ(dArray).result(), n4);
        DataSet dataSet3 = barLayer.addDataSet(new ArrayMath(this.N).selectEQZ(dArray).result(), n5);
        if (n7 < 0 || dArray[n7] == 0.0 || dArray[n7] == 1.7E308) {
            dataSet3.setDataName(string);
        } else if (dArray[n7] > 0.0) {
            dataSet.setDataName(string);
        } else {
            dataSet2.setDataName(string);
        }
        return barLayer;
    }

    public XYChart addIndicator(int n2) {
        Object object;
        XYChart xYChart = new XYChart(this.a, n2 + this.h + this.i, -16777216);
        xYChart.setTrimData(this.P);
        if (this.ad != null) {
            this.ad.xAxis().setColors(-16777216, -16777216);
            xYChart.xAxis().copyAxis(this.ad.xAxis());
            this.addChart(0, this.b + this.l, xYChart);
            this.b = this.b + n2 + 1 + this.l;
        } else {
            this.a(xYChart.xAxis());
            this.addChart(0, this.b, xYChart);
            this.b = this.b + n2 + 1;
        }
        this.ad = xYChart;
        this.setSize(this.a, this.b + this.h + this.i);
        xYChart.setPlotArea(this.f, this.h, this.a - this.f - this.g, n2, this.j, -1, this.k).setGridColor(this.m, this.o, this.n, this.p);
        xYChart.setAntiAlias(this.c);
        if (this.y != -16777216) {
            object = xYChart.addLegend(this.f, this.h, false, this.q, this.x);
            ((dw)object).setFontColor(this.y);
            ((Box)object).setBackground(this.z);
            ((TextBox)object).setMargin2(5, 0, 1, 1);
            ((dw)object).setSize(this.a - this.f - this.g + 1, 0);
        }
        object = xYChart.xAxis();
        ((Axis)object).setIndent(true);
        ((Axis)object).setTickLength(2, 0);
        ((Axis)object).setColors(-16777216, this.G, this.G, this.G);
        ((Axis)object).setLabelStyle(this.E, this.F, this.G, this.H);
        xYChart.setYAxisOnRight(this.e);
        this.a(xYChart.yAxis(), n2);
        return xYChart;
    }

    private void a(Axis axis, int n2) {
        axis.setAutoScale(0.0, 0.05, 0.0);
        if (n2 < 100) {
            axis.setTickDensity(15);
        }
        axis.setMargin(this.D);
        axis.setLabelStyle(this.A, this.B, this.C, 0.0);
        axis.setTickLength(-4, -2);
        axis.setColors(-16777216, this.C, this.C, this.C);
    }

    public XYChart addLineIndicator(int n2, double[] dArray, int n3, String string) {
        XYChart xYChart = this.addIndicator(n2);
        this.addLineIndicator2(xYChart, dArray, n3, string);
        return xYChart;
    }

    public LineLayer addLineIndicator2(XYChart xYChart, double[] dArray, int n2, String string) {
        return xYChart.addLineLayer(dArray, n2, this.a(string, dArray));
    }

    public XYChart addBarIndicator(int n2, double[] dArray, int n3, String string) {
        XYChart xYChart = this.addIndicator(n2);
        this.addBarIndicator2(xYChart, dArray, n3, string);
        return xYChart;
    }

    public BarLayer addBarIndicator2(XYChart xYChart, double[] dArray, int n2, String string) {
        BarLayer barLayer = xYChart.addBarLayer(dArray, n2, this.a(string, dArray));
        barLayer.setBorderColor(-16777216);
        return barLayer;
    }

    public void addThreshold(XYChart xYChart, LineLayer lineLayer, double d2, int n2, double d3, int n3) {
        Mark mark = xYChart.yAxis().addMark(d2, n2, this.formatValue(d2, this.Y));
        Mark mark2 = xYChart.yAxis().addMark(d3, n3, this.formatValue(d3, this.Y));
        xYChart.addInterLineLayer(lineLayer.getLine(), mark.getLine(), n2, -16777216);
        xYChart.addInterLineLayer(lineLayer.getLine(), mark2.getLine(), -16777216, n3);
    }

    private String a(String string, double[] dArray) {
        int n2 = this.a(dArray);
        if (string == null) {
            return string;
        }
        if (string == "" || n2 < 0) {
            return string;
        }
        String string2 = String.valueOf(string) + ": " + this.formatValue(dArray[n2], this.Y);
        return string2;
    }

    public XYChart addAccDist(int n2, int n3) {
        double[] dArray = new ArrayMath(this.J).sub(this.K).result();
        return this.addLineIndicator(n2, new ArrayMath(this.M).mul(2.0).sub(this.K).sub(this.J).mul(this.N).financeDiv(dArray, 0.0).acc().result(), n3, "Accumulation/Distribution");
    }

    private double[] c(int n2) {
        double[] dArray = new double[this.J.length];
        int n3 = 0;
        while (n3 < this.J.length) {
            double d2 = this.J[n3];
            if (d2 == 1.7E308) {
                dArray[n3] = 1.7E308;
            } else {
                int n4 = n3;
                int n5 = n2;
                int n6 = n2;
                while (n6 > 0 && n4 >= n6) {
                    double d3;
                    if ((d3 = this.J[--n4]) == 1.7E308) continue;
                    --n6;
                    if (!(d3 > d2)) continue;
                    d2 = d3;
                    n5 = n6;
                }
                dArray[n3] = n6 > 0 ? 1.7E308 : (double)n5 * 100.0 / (double)n2;
            }
            ++n3;
        }
        return dArray;
    }

    private double[] d(int n2) {
        double[] dArray = new double[this.K.length];
        int n3 = 0;
        while (n3 < this.K.length) {
            double d2 = this.K[n3];
            if (d2 == 1.7E308) {
                dArray[n3] = 1.7E308;
            } else {
                int n4 = n3;
                int n5 = n2;
                int n6 = n2;
                while (n6 > 0 && n4 >= n6) {
                    double d3;
                    if ((d3 = this.K[--n4]) == 1.7E308) continue;
                    --n6;
                    if (!(d3 < d2)) continue;
                    d2 = d3;
                    n5 = n6;
                }
                dArray[n3] = n6 > 0 ? 1.7E308 : (double)n5 * 100.0 / (double)n2;
            }
            ++n3;
        }
        return dArray;
    }

    public XYChart addAroon(int n2, int n3, int n4, int n5) {
        XYChart xYChart = this.addIndicator(n2);
        this.addLineIndicator2(xYChart, this.c(n3), n4, "Aroon Up");
        this.addLineIndicator2(xYChart, this.d(n3), n5, "Aroon Down");
        xYChart.yAxis().setLinearScale(0.0, 100.0);
        return xYChart;
    }

    public XYChart addAroonOsc(int n2, int n3, int n4) {
        String string = "Aroon Oscillator (" + n3 + ")";
        XYChart xYChart = this.addLineIndicator(n2, new ArrayMath(this.c(n3)).sub(this.d(n3)).result(), n4, string);
        xYChart.yAxis().setLinearScale(-100.0, 100.0);
        return xYChart;
    }

    private double[] f() {
        double[] dArray = new ArrayMath(this.M).shift().result();
        double[] dArray2 = new ArrayMath(this.J).sub(this.K).result();
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < this.J.length) {
            if (dArray2[n2] != 1.7E308 && dArray[n2] != 1.7E308) {
                d2 = Math.abs(this.J[n2] - dArray[n2]);
                if (d2 > dArray2[n2]) {
                    dArray2[n2] = d2;
                }
                if ((d2 = Math.abs(dArray[n2] - this.K[n2])) > dArray2[n2]) {
                    dArray2[n2] = d2;
                }
            }
            ++n2;
        }
        return dArray2;
    }

    public XYChart addADX(int n2, int n3, int n4, int n5, int n6) {
        ArrayMath arrayMath = new ArrayMath(this.J).delta().selectGTZ();
        ArrayMath arrayMath2 = new ArrayMath(this.K).delta().mul(-1.0).selectGTZ();
        double[] dArray = new ArrayMath(arrayMath.result()).sub(arrayMath2.result()).result();
        arrayMath.selectGTZ(dArray);
        arrayMath2.selectLTZ(dArray);
        double[] dArray2 = arrayMath.result();
        double[] dArray3 = arrayMath2.result();
        if (dArray2.length > 1 && dArray2[1] != 1.7E308 && dArray3[1] != 1.7E308) {
            dArray2[1] = (dArray2[1] * 2.0 + dArray3[1]) / 3.0;
            dArray3[1] = (dArray3[1] + dArray2[1]) / 2.0;
            arrayMath = new ArrayMath(dArray2);
            arrayMath2 = new ArrayMath(dArray3);
        }
        double[] dArray4 = this.f();
        dArray4 = new ArrayMath(dArray4).expAvg(1.0 / (double)n3).result();
        arrayMath.expAvg(1.0 / (double)n3).financeDiv(dArray4, 0.0).mul(100.0);
        arrayMath2.expAvg(1.0 / (double)n3).financeDiv(dArray4, 0.0).mul(100.0);
        double[] dArray5 = new ArrayMath(arrayMath.result()).add(arrayMath2.result()).result();
        ArrayMath arrayMath3 = new ArrayMath(arrayMath.result()).sub(arrayMath2.result()).abs().financeDiv(dArray5, 0.0).mul(100.0).expAvg(1.0 / (double)n3);
        XYChart xYChart = this.addIndicator(n2);
        String string = "+DI (" + n3 + ")";
        String string2 = "-DI (" + n3 + ")";
        String string3 = "ADX (" + n3 + ")";
        this.addLineIndicator2(xYChart, arrayMath.result(), n4, string);
        this.addLineIndicator2(xYChart, arrayMath2.result(), n5, string2);
        this.addLineIndicator2(xYChart, arrayMath3.result(), n6, string3);
        return xYChart;
    }

    public XYChart addATR(int n2, int n3, int n4, int n5) {
        double[] dArray = this.f();
        XYChart xYChart = this.addLineIndicator(n2, dArray, n4, "True Range");
        String string = "Average True Range (" + n3 + ")";
        this.addLineIndicator2(xYChart, new ArrayMath(dArray).expAvg(2.0 / (double)(n3 + 1)).result(), n5, string);
        return xYChart;
    }

    public XYChart addBollingerWidth(int n2, int n3, double d2, int n4) {
        String string = "Bollinger Width (" + n3 + ", " + d2 + ")";
        return this.addLineIndicator(n2, new ArrayMath(this.M).movStdDev(n3).mul(d2 * 2.0).result(), n4, string);
    }

    public XYChart addCCI(int n2, int n3, int n4, double d2, int n5, int n6) {
        double[] dArray = new ArrayMath(this.J).add(this.K).add(this.M).div(3.0).result();
        double[] dArray2 = new ArrayMath(dArray).movAvg(n3).result();
        double[] dArray3 = new double[dArray2.length];
        int n7 = 0;
        while (n7 < dArray2.length) {
            double d3 = dArray2[n7];
            if (d3 == 1.7E308) {
                dArray3[n7] = 1.7E308;
            } else {
                int n8 = n7;
                int n9 = n3 - 1;
                double d4 = 0.0;
                while (n9 >= 0 && n8 >= n9) {
                    double d5 = dArray[n8];
                    --n8;
                    if (d5 == 1.7E308) continue;
                    --n9;
                    d4 += Math.abs(d3 - d5);
                }
                dArray3[n7] = n9 > 0 ? 1.7E308 : d4 / (double)n3;
            }
            ++n7;
        }
        XYChart xYChart = this.addIndicator(n2);
        String string = "CCI (" + n3 + ")";
        LineLayer lineLayer = this.addLineIndicator2(xYChart, new ArrayMath(dArray).sub(dArray2).financeDiv(dArray3, 0.0).div(0.015).result(), n4, string);
        this.addThreshold(xYChart, lineLayer, d2, n5, -d2, n6);
        return xYChart;
    }

    public XYChart addChaikinMoneyFlow(int n2, int n3, int n4) {
        double[] dArray = new ArrayMath(this.J).sub(this.K).result();
        double[] dArray2 = new ArrayMath(this.N).movAvg(n3).result();
        String string = "Chaikin Money Flow (" + n3 + ")";
        return this.addBarIndicator(n2, new ArrayMath(this.M).mul(2.0).sub(this.K).sub(this.J).mul(this.N).financeDiv(dArray, 0.0).movAvg(n3).financeDiv(dArray2, 0.0).result(), n4, string);
    }

    public XYChart addChaikinOscillator(int n2, int n3) {
        double[] dArray = new ArrayMath(this.J).sub(this.K).result();
        double[] dArray2 = new ArrayMath(this.M).mul(2.0).sub(this.K).sub(this.J).mul(this.N).financeDiv(dArray, 0.0).acc().result();
        double[] dArray3 = new ArrayMath(dArray2).expAvg(0.18181818181818182).result();
        return this.addLineIndicator(n2, new ArrayMath(dArray2).expAvg(0.5).sub(dArray3).result(), n3, "Chaikin Oscillator");
    }

    public XYChart addChaikinVolatility(int n2, int n3, int n4, int n5) {
        String string = "Chaikin Volatility (" + n3 + ", " + n4 + ")";
        return this.addLineIndicator(n2, new ArrayMath(this.J).sub(this.K).expAvg(2.0 / (double)(n3 + 1)).rate(n4).sub(1.0).mul(100.0).result(), n5, string);
    }

    public XYChart addCLV(int n2, int n3) {
        double[] dArray = new ArrayMath(this.J).sub(this.K).result();
        return this.addLineIndicator(n2, new ArrayMath(this.M).mul(2.0).sub(this.K).sub(this.J).financeDiv(dArray, 0.0).result(), n3, "Close Location Value");
    }

    public XYChart addDPO(int n2, int n3, int n4) {
        String string = "DPO (" + n3 + ")";
        return this.addLineIndicator(n2, new ArrayMath(this.M).movAvg(n3).shift(n3 / 2 + 1).sub(this.M).mul(-1.0).result(), n4, string);
    }

    public XYChart addDonchianWidth(int n2, int n3, int n4) {
        String string = "Donchian Width (" + n3 + ")";
        return this.addLineIndicator(n2, new ArrayMath(this.J).movMax(n3).sub(new ArrayMath(this.K).movMin(n3).result()).result(), n4, string);
    }

    public XYChart addEaseOfMovement(int n2, int n3, int n4, int n5) {
        double[] dArray = new ArrayMath(this.J).sub(this.K).financeDiv(this.N, 0.0).result();
        double[] dArray2 = new ArrayMath(this.J).add(this.K).div(2.0).delta().mul(dArray).result();
        XYChart xYChart = this.addLineIndicator(n2, dArray2, n4, "EMV");
        String string = "EMV EMA (" + n3 + ")";
        this.addLineIndicator2(xYChart, new ArrayMath(dArray2).movAvg(n3).result(), n5, string);
        return xYChart;
    }

    public XYChart addFastStochastic(int n2, int n3, int n4, int n5, int n6) {
        double[] dArray = new ArrayMath(this.K).movMin(n3).result();
        double[] dArray2 = new ArrayMath(this.J).movMax(n3).sub(dArray).result();
        double[] dArray3 = new ArrayMath(this.M).sub(dArray).financeDiv(dArray2, 0.5).mul(100.0).result();
        String string = "Fast Stochastic %K (" + n3 + ")";
        XYChart xYChart = this.addLineIndicator(n2, dArray3, n5, string);
        String string2 = "%D (" + n4 + ")";
        this.addLineIndicator2(xYChart, new ArrayMath(dArray3).movAvg(n4).result(), n6, string2);
        xYChart.yAxis().setLinearScale(0.0, 100.0);
        return xYChart;
    }

    public XYChart addMACD(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        XYChart xYChart = this.addIndicator(n2);
        double[] dArray = new ArrayMath(this.M).expAvg(2.0 / (double)(n3 + 1)).result();
        double[] dArray2 = new ArrayMath(this.M).expAvg(2.0 / (double)(n4 + 1)).sub(dArray).result();
        String string = "MACD (" + n3 + ", " + n4 + ")";
        this.addLineIndicator2(xYChart, dArray2, n6, string);
        double[] dArray3 = new ArrayMath(dArray2).expAvg(2.0 / (double)(n5 + 1)).result();
        String string2 = "EXP (" + n5 + ")";
        this.addLineIndicator2(xYChart, dArray3, n7, string2);
        this.addBarIndicator2(xYChart, new ArrayMath(dArray2).sub(dArray3).result(), n8, "Divergence");
        return xYChart;
    }

    public XYChart addMassIndex(int n2, int n3, int n4, int n5) {
        double d2 = 0.2;
        double[] dArray = new ArrayMath(this.J).sub(this.K).expAvg(d2).result();
        double[] dArray2 = new ArrayMath(dArray).expAvg(d2).result();
        XYChart xYChart = this.addLineIndicator(n2, new ArrayMath(dArray).financeDiv(dArray2, 1.0).movAvg(25).mul(25.0).result(), n3, "Mass Index");
        xYChart.yAxis().addMark(27.0, n4);
        xYChart.yAxis().addMark(26.5, n5);
        return xYChart;
    }

    public XYChart addMFI(int n2, int n3, int n4, double d2, int n5, int n6) {
        double[] dArray = new ArrayMath(this.J).add(this.K).add(this.M).div(3.0).result();
        double[] dArray2 = new ArrayMath(dArray).mul(this.N).result();
        double[] dArray3 = new ArrayMath(dArray).delta().result();
        double[] dArray4 = new ArrayMath(dArray2).selectGTZ(dArray3).movAvg(n3).result();
        double[] dArray5 = new ArrayMath(dArray2).selectLTZ(dArray3).movAvg(n3).add(dArray4).result();
        XYChart xYChart = this.addIndicator(n2);
        String string = "Money Flow Index (" + n3 + ")";
        LineLayer lineLayer = this.addLineIndicator2(xYChart, new ArrayMath(dArray4).financeDiv(dArray5, 0.5).mul(100.0).result(), n4, string);
        this.addThreshold(xYChart, lineLayer, 50.0 + d2, n5, 50.0 - d2, n6);
        xYChart.yAxis().setLinearScale(0.0, 100.0);
        return xYChart;
    }

    public XYChart addMomentum(int n2, int n3, int n4) {
        String string = "Momentum (" + n3 + ")";
        return this.addLineIndicator(n2, new ArrayMath(this.M).delta(n3).result(), n4, string);
    }

    public XYChart addNVI(int n2, int n3, int n4, int n5) {
        double[] dArray = new double[this.N.length];
        double d2 = 100.0;
        double d3 = 1.7E308;
        double d4 = 1.7E308;
        int n6 = 0;
        while (n6 < this.N.length) {
            if (this.N[n6] == 1.7E308) {
                dArray[n6] = 1.7E308;
            } else {
                dArray[n6] = d3 != 1.7E308 && this.N[n6] < d3 && d4 != 1.7E308 && this.M[n6] != 1.7E308 ? d2 + d2 * (this.M[n6] - d4) / d4 : d2;
                d2 = dArray[n6];
                d3 = this.N[n6];
                d4 = this.M[n6];
            }
            ++n6;
        }
        XYChart xYChart = this.addLineIndicator(n2, dArray, n4, "NVI");
        if (dArray.length > n3) {
            String string = "NVI SMA (" + n3 + ")";
            this.addLineIndicator2(xYChart, new ArrayMath(dArray).movAvg(n3).result(), n5, string);
        }
        return xYChart;
    }

    public XYChart addOBV(int n2, int n3) {
        double[] dArray = new ArrayMath(this.M).delta().result();
        double[] dArray2 = new ArrayMath(this.N).selectGTZ(dArray).result();
        double[] dArray3 = new ArrayMath(this.N).selectLTZ(dArray).result();
        return this.addLineIndicator(n2, new ArrayMath(dArray2).sub(dArray3).acc().result(), n3, "OBV");
    }

    public XYChart addPerformance(int n2, int n3) {
        double d2 = this.a();
        if (d2 != 1.7E308) {
            return this.addLineIndicator(n2, new ArrayMath(this.M).mul(100.0 / d2).sub(100.0).result(), n3, "Performance");
        }
        return this.addIndicator(n2);
    }

    public XYChart addPPO(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        double[] dArray = new ArrayMath(this.M).expAvg(2.0 / (double)(n3 + 1)).result();
        double[] dArray2 = new ArrayMath(this.M).expAvg(2.0 / (double)(n4 + 1)).result();
        ArrayMath arrayMath = new ArrayMath(dArray2).sub(dArray).financeDiv(dArray2, 0.0).mul(100.0);
        double[] dArray3 = new ArrayMath(arrayMath.result()).expAvg(2.0 / (double)(n5 + 1)).result();
        String string = "PPO (" + n3 + ", " + n4 + ")";
        String string2 = "EMA (" + n5 + ")";
        XYChart xYChart = this.addLineIndicator(n2, arrayMath.result(), n6, string);
        this.addLineIndicator2(xYChart, dArray3, n7, string2);
        this.addBarIndicator2(xYChart, arrayMath.sub(dArray3).result(), n8, "Divergence");
        return xYChart;
    }

    public XYChart addPVI(int n2, int n3, int n4, int n5) {
        double[] dArray = new double[this.N.length];
        double d2 = 100.0;
        double d3 = 1.7E308;
        double d4 = 1.7E308;
        int n6 = 0;
        while (n6 < this.N.length) {
            if (this.N[n6] == 1.7E308) {
                dArray[n6] = 1.7E308;
            } else {
                dArray[n6] = d3 != 1.7E308 && this.N[n6] > d3 && d4 != 1.7E308 && this.M[n6] != 1.7E308 ? d2 + d2 * (this.M[n6] - d4) / d4 : d2;
                d2 = dArray[n6];
                d3 = this.N[n6];
                d4 = this.M[n6];
            }
            ++n6;
        }
        XYChart xYChart = this.addLineIndicator(n2, dArray, n4, "PVI");
        if (dArray.length > n3) {
            String string = "PVI SMA (" + n3 + ")";
            this.addLineIndicator2(xYChart, new ArrayMath(dArray).movAvg(n3).result(), n5, string);
        }
        return xYChart;
    }

    public XYChart addPVO(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        double[] dArray = new ArrayMath(this.N).expAvg(2.0 / (double)(n3 + 1)).result();
        double[] dArray2 = new ArrayMath(this.N).expAvg(2.0 / (double)(n4 + 1)).result();
        ArrayMath arrayMath = new ArrayMath(dArray2).sub(dArray).financeDiv(dArray2, 0.0).mul(100.0);
        double[] dArray3 = new ArrayMath(arrayMath.result()).expAvg(2.0 / (double)(n5 + 1)).result();
        String string = "PVO (" + n3 + ", " + n4 + ")";
        String string2 = "EMA (" + n5 + ")";
        XYChart xYChart = this.addLineIndicator(n2, arrayMath.result(), n6, string);
        this.addLineIndicator2(xYChart, dArray3, n7, string2);
        this.addBarIndicator2(xYChart, arrayMath.sub(dArray3).result(), n8, "Divergence");
        return xYChart;
    }

    public XYChart addPVT(int n2, int n3) {
        return this.addLineIndicator(n2, new ArrayMath(this.M).rate().sub(1.0).mul(this.N).acc().result(), n3, "PVT");
    }

    public XYChart addROC(int n2, int n3, int n4) {
        String string = "ROC (" + n3 + ")";
        return this.addLineIndicator(n2, new ArrayMath(this.M).rate(n3).sub(1.0).mul(100.0).result(), n4, string);
    }

    private double[] c(double[] dArray, int n2) {
        if (n2 <= 0) {
            n2 = 1;
        }
        int n3 = 0;
        double d2 = 0.0;
        int n4 = 0;
        while (n4 < dArray.length) {
            if (Math.abs(dArray[n4] / 1.7E308 - 1.0) > 1.0E-5) {
                d2 += dArray[n4];
                if (++n3 < n2) {
                    dArray[n4] = 1.7E308;
                } else {
                    dArray[n4] = d2 / (double)n2;
                    d2 = dArray[n4] * (double)(n2 - 1);
                }
            }
            ++n4;
        }
        return dArray;
    }

    private double[] e(int n2) {
        double[] dArray = this.c(new ArrayMath(this.M).delta().abs().result(), n2);
        double[] dArray2 = this.c(new ArrayMath(this.M).delta().selectGTZ().result(), n2);
        return new ArrayMath(dArray2).financeDiv(dArray, 0.5).mul(100.0).result();
    }

    public XYChart addRSI(int n2, int n3, int n4, double d2, int n5, int n6) {
        XYChart xYChart = this.addIndicator(n2);
        String string = "RSI (" + n3 + ")";
        LineLayer lineLayer = this.addLineIndicator2(xYChart, this.e(n3), n4, string);
        if (d2 > 0.0 && d2 < 50.0) {
            this.addThreshold(xYChart, lineLayer, 50.0 + d2, n5, 50.0 - d2, n6);
        }
        xYChart.yAxis().setLinearScale(0.0, 100.0);
        return xYChart;
    }

    public XYChart addSlowStochastic(int n2, int n3, int n4, int n5, int n6) {
        double[] dArray = new ArrayMath(this.K).movMin(n3).result();
        double[] dArray2 = new ArrayMath(this.J).movMax(n3).sub(dArray).result();
        ArrayMath arrayMath = new ArrayMath(this.M).sub(dArray).financeDiv(dArray2, 0.5).mul(100.0).movAvg(3);
        String string = "Slow Stochastic %K (" + n3 + ")";
        String string2 = "%D (" + n4 + ")";
        XYChart xYChart = this.addLineIndicator(n2, arrayMath.result(), n5, string);
        this.addLineIndicator2(xYChart, arrayMath.movAvg(n4).result(), n6, string2);
        xYChart.yAxis().setLinearScale(0.0, 100.0);
        return xYChart;
    }

    public XYChart addStdDev(int n2, int n3, int n4) {
        String string = "Moving StdDev (" + n3 + ")";
        return this.addLineIndicator(n2, new ArrayMath(this.M).movStdDev(n3).result(), n4, string);
    }

    public XYChart addStochRSI(int n2, int n3, int n4, double d2, int n5, int n6) {
        double[] dArray = this.e(n3);
        double[] dArray2 = new ArrayMath(dArray).movMin(n3).result();
        double[] dArray3 = new ArrayMath(dArray).movMax(n3).sub(dArray2).result();
        XYChart xYChart = this.addIndicator(n2);
        String string = "StochRSI (" + n3 + ")";
        LineLayer lineLayer = this.addLineIndicator2(xYChart, new ArrayMath(dArray).sub(dArray2).financeDiv(dArray3, 0.5).mul(100.0).result(), n4, string);
        if (d2 > 0.0 && d2 < 50.0) {
            this.addThreshold(xYChart, lineLayer, 50.0 + d2, n5, 50.0 - d2, n6);
        }
        xYChart.yAxis().setLinearScale(0.0, 100.0);
        return xYChart;
    }

    public XYChart addTRIX(int n2, int n3, int n4) {
        double d2 = 2.0 / (double)(n3 + 1);
        String string = "TRIX (" + n3 + ")";
        return this.addLineIndicator(n2, new ArrayMath(this.M).expAvg(d2).expAvg(d2).expAvg(d2).rate().sub(1.0).mul(100.0).result(), n4, string);
    }

    private double[] g() {
        double[] dArray = new ArrayMath(this.M).shift().result();
        double[] dArray2 = new double[this.K.length];
        int n2 = 0;
        while (n2 < this.K.length) {
            dArray2[n2] = this.K[n2] != 1.7E308 && dArray[n2] != 1.7E308 ? (this.K[n2] < dArray[n2] ? this.K[n2] : dArray[n2]) : 1.7E308;
            ++n2;
        }
        return dArray2;
    }

    public XYChart addUltimateOscillator(int n2, int n3, int n4, int n5, int n6, double d2, int n7, int n8) {
        double[] dArray = this.g();
        double[] dArray2 = new ArrayMath(this.M).sub(dArray).result();
        double[] dArray3 = this.f();
        double[] dArray4 = new ArrayMath(dArray2).movAvg(n3).financeDiv(new ArrayMath(dArray3).movAvg(n3).result(), 0.5).mul(4.0).result();
        double[] dArray5 = new ArrayMath(dArray2).movAvg(n4).financeDiv(new ArrayMath(dArray3).movAvg(n4).result(), 0.5).mul(2.0).result();
        double[] dArray6 = new ArrayMath(dArray2).movAvg(n5).financeDiv(new ArrayMath(dArray3).movAvg(n5).result(), 0.5).mul(1.0).result();
        XYChart xYChart = this.addIndicator(n2);
        String string = "Ultimate Oscillator (" + n3 + ", " + n4 + ", " + n5 + ")";
        LineLayer lineLayer = this.addLineIndicator2(xYChart, new ArrayMath(dArray4).add(dArray5).add(dArray6).mul(14.285714285714286).result(), n6, string);
        this.addThreshold(xYChart, lineLayer, 50.0 + d2, n7, 50.0 - d2, n8);
        xYChart.yAxis().setLinearScale(0.0, 100.0);
        return xYChart;
    }

    public XYChart addVolIndicator(int n2, int n3, int n4, int n5) {
        XYChart xYChart = this.addIndicator(n2);
        this.a(xYChart, n2, n3, n4, n5);
        return xYChart;
    }

    public XYChart addWilliamR(int n2, int n3, int n4, double d2, int n5, int n6) {
        double[] dArray = new ArrayMath(this.K).movMin(n3).result();
        double[] dArray2 = new ArrayMath(this.J).movMax(n3).result();
        double[] dArray3 = new ArrayMath(dArray2).sub(dArray).result();
        XYChart xYChart = this.addIndicator(n2);
        LineLayer lineLayer = this.addLineIndicator2(xYChart, new ArrayMath(dArray2).sub(this.M).financeDiv(dArray3, 0.5).mul(-100.0).result(), n4, "William %R");
        this.addThreshold(xYChart, lineLayer, -50.0 + d2, n5, -50.0 - d2, n6);
        xYChart.yAxis().setLinearScale(-100.0, 0.0);
        return xYChart;
    }
}

