/*
 * Decompiled with CFR 0.152.
 */
package ChartDirector;

import ChartDirector.ArrayMath;
import ChartDirector.DrawArea;
import ChartDirector.TTFText;
import ChartDirector.ef;
import ChartDirector.w;
import java.awt.Color;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;

public class Chart {
    public static final double LogTick = 1.6E308;
    public static final double LinearTick = 1.5E308;
    public static final double MinorTickOnly = -1.7E308;
    public static final double MicroTickOnly = -1.6E308;
    public static final double TickInc = 1.0E200;
    public static final double TouchBar = -1.7E-100;
    public static final double DataBound = -1.7E-100;
    public static final int AutoGrid = -2;
    public static final double NoValue = 1.7E308;
    public static final int[] oldDefaultPalette;
    public static final int[] defaultPalette;
    public static final int[] whiteOnBlackPalette;
    public static final int[] transparentPalette;
    public static final int Transparent = -16777216;
    public static final int Palette = -65536;
    public static final int BackgroundColor = -65536;
    public static final int LineColor = -65535;
    public static final int TextColor = -65534;
    public static final int DataColor = -65528;
    public static final int SameAsMainColor = -65529;
    public static final int DashLine = 1285;
    public static final int DotLine = 514;
    public static final int DotDashLine = 0x5050205;
    public static final int AltDashLine = 0xA050505;
    public static final int[] goldGradient;
    public static final int[] silverGradient;
    public static final int[] redMetalGradient;
    public static final int[] blueMetalGradient;
    public static final int[] greenMetalGradient;
    public static final int NoSymbol = 0;
    public static final int SquareSymbol = 1;
    public static final int DiamondSymbol = 2;
    public static final int TriangleSymbol = 3;
    public static final int RightTriangleSymbol = 4;
    public static final int LeftTriangleSymbol = 5;
    public static final int InvertedTriangleSymbol = 6;
    public static final int CircleSymbol = 7;
    public static final int CrossSymbol = 8;
    public static final int Cross2Symbol = 9;
    public static final int NoShape = 0;
    public static final int SquareShape = 1;
    public static final int DiamondShape = 2;
    public static final int TriangleShape = 3;
    public static final int RightTriangleShape = 4;
    public static final int LeftTriangleShape = 5;
    public static final int InvertedTriangleShape = 6;
    public static final int CircleShape = 7;
    public static final int CircleShapeNoShading = 10;
    public static final int GlassSphereShape = 15;
    public static final int GlassSphere2Shape = 16;
    public static final int SolidSphereShape = 17;
    private static final int[] a;
    private static final int[] b;
    private static final int[] c;
    private static final int[] d;
    private static final int[] e;
    private static final int[] f;
    private static final int[] g;
    private static final int[] h;
    private static final int[] i;
    private static final int[] j;
    private static final int[] k;
    private static final int[] l;
    private static final int[] m;
    public static final int Overlay = 0;
    public static final int Stack = 1;
    public static final int Depth = 2;
    public static final int Side = 3;
    public static final int Percentage = 4;
    public static final int NormalLegend = 0;
    public static final int ReverseLegend = 1;
    public static final int NoLegend = 2;
    public static final int TopLeft = 7;
    public static final int TopCenter = 8;
    public static final int TopRight = 9;
    public static final int Left = 4;
    public static final int Center = 5;
    public static final int Right = 6;
    public static final int BottomLeft = 1;
    public static final int BottomCenter = 2;
    public static final int BottomRight = 3;
    public static final int Top = 8;
    public static final int Bottom = 2;
    public static final int TopLeft2 = 10;
    public static final int TopRight2 = 11;
    public static final int BottomLeft2 = 12;
    public static final int BottomRight2 = 13;
    public static final int NoAntiAlias = 0;
    public static final int AntiAlias = 1;
    public static final int AutoAntiAlias = 2;
    public static final int ClearType = 3;
    private static int n;
    public static final int CompatAntiAlias = 6;
    public static final int TryPalette = 0;
    public static final int ForcePalette = 1;
    public static final int NoPalette = 2;
    public static final int Quantize = 0;
    public static final int OrderedDither = 1;
    public static final int ErrorDiffusion = 2;
    public static final int PNG = 0;
    public static final int GIF = 1;
    public static final int JPG = 2;
    public static final int WMP = 3;
    public static final int BMP = 4;
    public static final int SVG = 5;
    public static final int SVGZ = 6;
    public static final int BoxFilter = 0;
    public static final int LinearFilter = 1;
    public static final int QuadraticFilter = 2;
    public static final int BSplineFilter = 3;
    public static final int HermiteFilter = 4;
    public static final int CatromFilter = 5;
    public static final int MitchellFilter = 6;
    public static final int SincFilter = 7;
    public static final int LanczosFilter = 8;
    public static final int GaussianFilter = 9;
    public static final int HanningFilter = 10;
    public static final int HammingFilter = 11;
    public static final int BlackmanFilter = 12;
    public static final int BesselFilter = 13;
    public static final int PixelScale = 0;
    public static final int XAxisScale = 1;
    public static final int YAxisScale = 2;
    public static final int AngularAxisScale = 1;
    public static final int RadialAxisScale = 2;
    public static final int EndPoints = 3;
    public static final int SideLayout = 0;
    public static final int CircleLayout = 1;
    public static final int HLOCDefault = 0;
    public static final int HLOCOpenClose = 1;
    public static final int HLOCUpDown = 2;
    public static final int DiamondPointer = 0;
    public static final int TriangularPointer = 1;
    public static final int ArrowPointer = 2;
    public static final int ArrowPointer2 = 3;
    public static final int LinePointer = 4;
    public static final int PencilPointer = 5;
    public static final int ChartBackZ = 256;
    public static final int ChartFrontZ = 65535;
    public static final int PlotAreaZ = 4096;
    public static final int GridLinesZ = 8192;
    public static final int XAxisSymmetric = 1;
    public static final int XAxisSymmetricIfNeeded = 2;
    public static final int YAxisSymmetric = 4;
    public static final int YAxisSymmetricIfNeeded = 8;
    public static final int XYAxisSymmetric = 16;
    public static final int XYAxisSymmetricIfNeeded = 32;
    public static final int XAxisAtOrigin = 1;
    public static final int YAxisAtOrigin = 2;
    public static final int XYAxisAtOrigin = 3;
    public static final int MonotonicNone = 0;
    public static final int MonotonicX = 1;
    public static final int MonotonicY = 2;
    public static final int MonotonicXY = 3;
    public static final int MonotonicAuto = 4;
    public static final int ConstrainedLinearRegression = 0;
    public static final int LinearRegression = 1;
    public static final int ExponentialRegression = -1;
    public static final int LogarithmicRegression = -2;
    public static final int AggregateSum = 0;
    public static final int AggregateAvg = 1;
    public static final int AggregateStdDev = 2;
    public static final int AggregateMin = 3;
    public static final int AggregateMed = 4;
    public static final int AggregateMax = 5;
    public static final int AggregatePercentile = 6;
    public static final int AggregateFirst = 7;
    public static final int AggregateLast = 8;
    public static final int AggregateCount = 9;
    private static final int[] o;
    public static final int NormalGlare = 3;
    public static final int ReducedGlare = 2;
    public static final int NoGlare = 1;
    public static final int DefaultShading = 0;
    public static final int FlatShading = 1;
    public static final int LocalGradientShading = 2;
    public static final int GlobalGradientShading = 3;
    public static final int ConcaveShading = 4;
    public static final int RoundedEdgeNoGlareShading = 5;
    public static final int RoundedEdgeShading = 6;
    public static final int RadialShading = 7;
    public static final int RingShading = 8;
    public static final int SmoothShading = 0;
    public static final int TriangularShading = 1;
    public static final int RectangularShading = 2;
    public static final int TriangularFrame = 3;
    public static final int RectangularFrame = 4;
    public static final int MouseUsageDefault = 0;
    public static final int MouseUsageScrollOnDrag = 1;
    public static final int MouseUsageScrollOnDrop = 2;
    public static final int MouseUsageScroll = 2;
    public static final int MouseUsageZoomIn = 3;
    public static final int MouseUsageZoomOut = 4;
    public static final int DirectionHorizontal = 0;
    public static final int DirectionVertical = 1;
    public static final int DirectionHorizontalVertical = 2;
    private static int p;

    static {
        int[] nArray = new int[24];
        nArray[0] = 0xFFFFFF;
        nArray[3] = 0x808080;
        nArray[4] = 0x808080;
        nArray[5] = 0x808080;
        nArray[6] = 0x808080;
        nArray[7] = 0x808080;
        nArray[8] = 0xFF0000;
        nArray[9] = 65280;
        nArray[10] = 255;
        nArray[11] = 0xFFFF00;
        nArray[12] = 0xFF00FF;
        nArray[13] = 0x66FFFF;
        nArray[14] = 0xFFCC33;
        nArray[15] = 0xCCCCCC;
        nArray[16] = 0x9966FF;
        nArray[17] = 0x339966;
        nArray[18] = 0x999900;
        nArray[19] = 0xCC3300;
        nArray[20] = 0x99CCCC;
        nArray[21] = 26112;
        nArray[22] = 0x660066;
        nArray[23] = 0xCC9999;
        oldDefaultPalette = nArray;
        int[] nArray2 = new int[40];
        nArray2[0] = 0xFFFFFF;
        nArray2[3] = 0x808080;
        nArray2[4] = 0x808080;
        nArray2[5] = 0x808080;
        nArray2[6] = 0x808080;
        nArray2[7] = 0x808080;
        nArray2[8] = 0xFF3333;
        nArray2[9] = 0x33FF33;
        nArray2[10] = 0x6666FF;
        nArray2[11] = 0xFFFF00;
        nArray2[12] = 0xFF66FF;
        nArray2[13] = 0x99FFFF;
        nArray2[14] = 0xFFCC33;
        nArray2[15] = 0xCCCCCC;
        nArray2[16] = 0xCC9999;
        nArray2[17] = 0x339966;
        nArray2[18] = 0x999900;
        nArray2[19] = 0xCC3300;
        nArray2[20] = 0x669999;
        nArray2[21] = 0x993333;
        nArray2[22] = 26112;
        nArray2[23] = 0x990099;
        nArray2[24] = 0xFF9966;
        nArray2[25] = 0x99FF99;
        nArray2[26] = 0x9999FF;
        nArray2[27] = 0xCC6600;
        nArray2[28] = 0x33CC33;
        nArray2[29] = 0xCC99FF;
        nArray2[30] = 0xFF6666;
        nArray2[31] = 0x99CC66;
        nArray2[32] = 39321;
        nArray2[33] = 0xCC3333;
        nArray2[34] = 0x9933FF;
        nArray2[35] = 0xFF0000;
        nArray2[36] = 255;
        nArray2[37] = 65280;
        nArray2[38] = 0xFFCC99;
        nArray2[39] = 0x999999;
        defaultPalette = nArray2;
        int[] nArray3 = new int[40];
        nArray3[1] = 0xFFFFFF;
        nArray3[2] = 0xFFFFFF;
        nArray3[3] = 0x808080;
        nArray3[4] = 0x808080;
        nArray3[5] = 0x808080;
        nArray3[6] = 0x808080;
        nArray3[7] = 0x808080;
        nArray3[8] = 0xFF0000;
        nArray3[9] = 65280;
        nArray3[10] = 255;
        nArray3[11] = 0xFFFF00;
        nArray3[12] = 0xFF00FF;
        nArray3[13] = 0x66FFFF;
        nArray3[14] = 0xFFCC33;
        nArray3[15] = 0xCCCCCC;
        nArray3[16] = 0x9966FF;
        nArray3[17] = 0x339966;
        nArray3[18] = 0x999900;
        nArray3[19] = 0xCC3300;
        nArray3[20] = 0x99CCCC;
        nArray3[21] = 26112;
        nArray3[22] = 0x660066;
        nArray3[23] = 0xCC9999;
        nArray3[24] = 0xFF9966;
        nArray3[25] = 0x99FF99;
        nArray3[26] = 0x9999FF;
        nArray3[27] = 0xCC6600;
        nArray3[28] = 0x33CC33;
        nArray3[29] = 0xCC99FF;
        nArray3[30] = 0xFF6666;
        nArray3[31] = 0x99CC66;
        nArray3[32] = 39321;
        nArray3[33] = 0xCC3333;
        nArray3[34] = 0x9933FF;
        nArray3[35] = 0xFF0000;
        nArray3[36] = 255;
        nArray3[37] = 65280;
        nArray3[38] = 0xFFCC99;
        nArray3[39] = 0x999999;
        whiteOnBlackPalette = nArray3;
        int[] nArray4 = new int[40];
        nArray4[0] = 0xFFFFFF;
        nArray4[3] = 0x808080;
        nArray4[4] = 0x808080;
        nArray4[5] = 0x808080;
        nArray4[6] = 0x808080;
        nArray4[7] = 0x808080;
        nArray4[8] = -2130771968;
        nArray4[9] = -2147418368;
        nArray4[10] = -2147483393;
        nArray4[11] = -2130706688;
        nArray4[12] = -2130771713;
        nArray4[13] = -2140733441;
        nArray4[14] = -2130719693;
        nArray4[15] = -2134061876;
        nArray4[16] = -2137430273;
        nArray4[17] = -2144102042;
        nArray4[18] = -2137417472;
        nArray4[19] = -2134101248;
        nArray4[20] = -2137404212;
        nArray4[21] = -2147457536;
        nArray4[22] = -2140798874;
        nArray4[23] = -2134074983;
        nArray4[24] = -2130732698;
        nArray4[25] = -2137391207;
        nArray4[26] = -2137417217;
        nArray4[27] = -2134088192;
        nArray4[28] = -2144089037;
        nArray4[29] = -2134074881;
        nArray4[30] = -2130745754;
        nArray4[31] = -2137404314;
        nArray4[32] = -2147444327;
        nArray4[33] = -2134101197;
        nArray4[34] = -2137443329;
        nArray4[35] = -2130771968;
        nArray4[36] = -2147483393;
        nArray4[37] = -2147418368;
        nArray4[38] = -2130719591;
        nArray4[39] = -2137417319;
        transparentPalette = nArray4;
        int[] nArray5 = new int[8];
        nArray5[1] = 16770883;
        nArray5[2] = 96;
        nArray5[3] = 0xFFFFE0;
        nArray5[4] = 176;
        nArray5[5] = 0xFFF0B0;
        nArray5[6] = 256;
        nArray5[7] = 16770883;
        goldGradient = nArray5;
        int[] nArray6 = new int[8];
        nArray6[1] = 0xC8C8C8;
        nArray6[2] = 96;
        nArray6[3] = 0xF8F8F8;
        nArray6[4] = 176;
        nArray6[5] = 0xE0E0E0;
        nArray6[6] = 256;
        nArray6[7] = 0xC8C8C8;
        silverGradient = nArray6;
        int[] nArray7 = new int[8];
        nArray7[1] = 14719128;
        nArray7[2] = 96;
        nArray7[3] = 0xFFF0F0;
        nArray7[4] = 176;
        nArray7[5] = 15784152;
        nArray7[6] = 256;
        nArray7[7] = 14719128;
        redMetalGradient = nArray7;
        int[] nArray8 = new int[8];
        nArray8[1] = 10000608;
        nArray8[2] = 96;
        nArray8[3] = 0xF0F0FF;
        nArray8[4] = 176;
        nArray8[5] = 14211312;
        nArray8[6] = 256;
        nArray8[7] = 10000608;
        blueMetalGradient = nArray8;
        int[] nArray9 = new int[8];
        nArray9[1] = 10018968;
        nArray9[2] = 96;
        nArray9[3] = 0xF0FFF0;
        nArray9[4] = 176;
        nArray9[5] = 14217432;
        nArray9[6] = 256;
        nArray9[7] = 10018968;
        greenMetalGradient = nArray9;
        int[] nArray10 = new int[4];
        nArray10[3] = 1000;
        a = nArray10;
        b = new int[]{-500, 500, 500, 500};
        int[] nArray11 = new int[6];
        nArray11[0] = -500;
        nArray11[2] = 500;
        nArray11[5] = 1000;
        c = nArray11;
        int[] nArray12 = new int[6];
        nArray12[0] = -500;
        nArray12[2] = 500;
        nArray12[3] = 500;
        nArray12[4] = -500;
        nArray12[5] = 1000;
        d = nArray12;
        int[] nArray13 = new int[6];
        nArray13[0] = -500;
        nArray13[1] = 500;
        nArray13[2] = 500;
        nArray13[4] = 500;
        nArray13[5] = 1000;
        e = nArray13;
        int[] nArray14 = new int[6];
        nArray14[2] = 500;
        nArray14[3] = 1000;
        nArray14[4] = -500;
        nArray14[5] = 1000;
        f = nArray14;
        int[] nArray15 = new int[8];
        nArray15[0] = -500;
        nArray15[2] = 500;
        nArray15[4] = 500;
        nArray15[5] = 1000;
        nArray15[6] = -500;
        nArray15[7] = 1000;
        g = nArray15;
        int[] nArray16 = new int[8];
        nArray16[2] = 500;
        nArray16[3] = 500;
        nArray16[5] = 1000;
        nArray16[6] = -500;
        nArray16[7] = 500;
        h = nArray16;
        int[] nArray17 = new int[12];
        nArray17[1] = 1000;
        nArray17[2] = 125;
        nArray17[3] = 440;
        nArray17[4] = 500;
        nArray17[7] = 200;
        nArray17[8] = -500;
        nArray17[10] = -125;
        nArray17[11] = 440;
        i = nArray17;
        int[] nArray18 = new int[16];
        nArray18[1] = 1000;
        nArray18[2] = 125;
        nArray18[3] = 625;
        nArray18[4] = 500;
        nArray18[5] = 500;
        nArray18[6] = 125;
        nArray18[7] = 375;
        nArray18[10] = -125;
        nArray18[11] = 375;
        nArray18[12] = -500;
        nArray18[13] = 500;
        nArray18[14] = -125;
        nArray18[15] = 625;
        j = nArray18;
        int[] nArray19 = new int[20];
        nArray19[1] = 1000;
        nArray19[2] = 118;
        nArray19[3] = 637;
        nArray19[4] = 500;
        nArray19[5] = 637;
        nArray19[6] = 191;
        nArray19[7] = 412;
        nArray19[8] = 309;
        nArray19[9] = 50;
        nArray19[11] = 274;
        nArray19[12] = -309;
        nArray19[13] = 50;
        nArray19[14] = -191;
        nArray19[15] = 412;
        nArray19[16] = -500;
        nArray19[17] = 637;
        nArray19[18] = -118;
        nArray19[19] = 637;
        k = nArray19;
        int[] nArray20 = new int[24];
        nArray20[1] = 1000;
        nArray20[2] = 133;
        nArray20[3] = 750;
        nArray20[4] = 500;
        nArray20[5] = 750;
        nArray20[6] = 367;
        nArray20[7] = 500;
        nArray20[8] = 500;
        nArray20[9] = 250;
        nArray20[10] = 133;
        nArray20[11] = 250;
        nArray20[14] = -133;
        nArray20[15] = 250;
        nArray20[16] = -500;
        nArray20[17] = 250;
        nArray20[18] = -367;
        nArray20[19] = 500;
        nArray20[20] = -500;
        nArray20[21] = 750;
        nArray20[22] = -133;
        nArray20[23] = 750;
        l = nArray20;
        int[] nArray21 = new int[32];
        nArray21[1] = 1000;
        nArray21[2] = 104;
        nArray21[3] = 750;
        nArray21[4] = 354;
        nArray21[5] = 854;
        nArray21[6] = 250;
        nArray21[7] = 604;
        nArray21[8] = 500;
        nArray21[9] = 500;
        nArray21[10] = 250;
        nArray21[11] = 396;
        nArray21[12] = 354;
        nArray21[13] = 146;
        nArray21[14] = 104;
        nArray21[15] = 250;
        nArray21[18] = -104;
        nArray21[19] = 250;
        nArray21[20] = -354;
        nArray21[21] = 146;
        nArray21[22] = -250;
        nArray21[23] = 396;
        nArray21[24] = -500;
        nArray21[25] = 500;
        nArray21[26] = -250;
        nArray21[27] = 604;
        nArray21[28] = -354;
        nArray21[29] = 854;
        nArray21[30] = -104;
        nArray21[31] = 750;
        m = nArray21;
        n = 0;
        int[] nArray22 = new int[10];
        nArray22[1] = 1024;
        nArray22[2] = 48;
        nArray22[3] = 2048;
        nArray22[4] = 128;
        nArray22[5] = 4096;
        nArray22[6] = 208;
        nArray22[7] = 2048;
        nArray22[8] = 256;
        nArray22[9] = 1024;
        o = nArray22;
        p = 0;
    }

    public static final int CrossShape(double d2) {
        return 8 | (int)Math.round(ef.b(0.0, d2, 1.0) * 4095.0) << 12;
    }

    public static final int CrossShape() {
        return Chart.CrossShape(0.5);
    }

    public static final int Cross2Shape(double d2) {
        return 9 | (int)Math.round(ef.b(0.0, d2, 1.0) * 4095.0) << 12;
    }

    public static final int Cross2Shape() {
        return Chart.Cross2Shape(0.5);
    }

    public static final int PolygonShape(int n2) {
        return 0xB | ef.a(0, n2, 100) << 12;
    }

    public static final int Polygon2Shape(int n2) {
        return 0xC | ef.a(0, n2, 100) << 12;
    }

    public static final int StarShape(int n2) {
        return 0xD | ef.a(0, n2, 100) << 12;
    }

    private static final int[] a(int n2, double d2, double d3) {
        if (n2 < 3) {
            return a;
        }
        d3 *= 500.0;
        int[] nArray = new int[n2 * 2];
        int n3 = 0;
        while (n3 < nArray.length) {
            double d4 = Math.PI * (double)n3 / (double)n2 + d2;
            nArray[n3] = (int)Math.round(d3 * Math.sin(d4));
            nArray[n3 + 1] = 500 + (int)Math.round(d3 * Math.cos(d4));
            n3 += 2;
        }
        return nArray;
    }

    private static final int[] h(int n2) {
        switch (n2) {
            case 3: {
                return c;
            }
            case 4: {
                return h;
            }
        }
        return Chart.a(n2, 0.0, 1.0);
    }

    private static final int[] i(int n2) {
        switch (n2) {
            case 3: {
                return f;
            }
            case 4: {
                return g;
            }
        }
        double d2 = Math.PI / (double)n2;
        return Chart.a(n2, d2, 1.0);
    }

    private static final int[] b(int n2, double d2) {
        if (n2 < 3) {
            return a;
        }
        d2 *= 500.0;
        int[] nArray = new int[n2 * 4];
        int n3 = 0;
        while (n3 < nArray.length) {
            double d3 = Math.PI * (double)n3 / (double)n2 / 2.0;
            nArray[n3] = (int)Math.round(500.0 * Math.sin(d3));
            nArray[n3 + 1] = 500 + (int)Math.round(500.0 * Math.cos(d3));
            nArray[n3 + 2] = (int)Math.round(d2 * Math.sin(d3 += Math.PI / (double)n2));
            nArray[n3 + 3] = 500 + (int)Math.round(d2 * Math.cos(d3));
            n3 += 4;
        }
        return nArray;
    }

    private static final int[] j(int n2) {
        switch (n2) {
            case 3: {
                return i;
            }
            case 4: {
                return j;
            }
            case 5: {
                return k;
            }
            case 6: {
                return l;
            }
            case 8: {
                return m;
            }
        }
        return Chart.b(n2, 0.75);
    }

    private static final int[] k(int n2) {
        int n3 = n2 * 500 / 4095;
        int n4 = 500 - n3;
        int n5 = 500 + n3;
        int[] nArray = new int[24];
        nArray[0] = -n3;
        nArray[2] = n3;
        nArray[4] = n3;
        nArray[5] = n4;
        nArray[6] = 500;
        nArray[7] = n4;
        nArray[8] = 500;
        nArray[9] = n5;
        nArray[10] = n3;
        nArray[11] = n5;
        nArray[12] = n3;
        nArray[13] = 1000;
        nArray[14] = -n3;
        nArray[15] = 1000;
        nArray[16] = -n3;
        nArray[17] = n5;
        nArray[18] = -500;
        nArray[19] = n5;
        nArray[20] = -500;
        nArray[21] = n4;
        nArray[22] = -n3;
        nArray[23] = n4;
        return nArray;
    }

    private static final int[] l(int n2) {
        int n3 = n2 * 500 / 4095;
        int n4 = 500 - n3;
        int[] nArray = new int[24];
        nArray[0] = -n4;
        nArray[3] = n4;
        nArray[4] = n4;
        nArray[6] = 500;
        nArray[7] = n3;
        nArray[8] = n3;
        nArray[9] = 500;
        nArray[10] = 500;
        nArray[11] = 500 + n4;
        nArray[12] = n4;
        nArray[13] = 1000;
        nArray[15] = 1000 - n4;
        nArray[16] = -n4;
        nArray[17] = 1000;
        nArray[18] = -500;
        nArray[19] = 500 + n4;
        nArray[20] = -n3;
        nArray[21] = 500;
        nArray[22] = -500;
        nArray[23] = n3;
        return nArray;
    }

    static int[] a(int n2) {
        int n3 = n2 & 0x7F;
        int n4 = n2 >> 12 & 0xFFF;
        switch (n3) {
            case 1: {
                return g;
            }
            case 2: {
                return h;
            }
            case 3: {
                return c;
            }
            case 4: {
                return d;
            }
            case 5: {
                return e;
            }
            case 6: {
                return f;
            }
            case 7: {
                return a;
            }
            case 10: {
                return b;
            }
            case 8: {
                return Chart.k(n4);
            }
            case 9: {
                return Chart.l(n4);
            }
            case 11: {
                return Chart.h(n4);
            }
            case 12: {
                return Chart.i(n4);
            }
            case 13: {
                return Chart.j(n4);
            }
        }
        return null;
    }

    static final int a(int n2, int n3, double d2) {
        int n4 = (int)Math.round(ef.b(0.0, d2, 1.0) * 4095.0);
        return n2 << 28 | n4 << 16 | n3 & 0xFFFF;
    }

    public static final int StartOfHourFilter(int n2, double d2) {
        return Chart.a(1, n2, d2);
    }

    public static final int StartOfHourFilter(int n2) {
        return Chart.StartOfHourFilter(n2, 0.05);
    }

    public static final int StartOfHourFilter() {
        return Chart.StartOfHourFilter(1, 0.05);
    }

    public static final int StartOfDayFilter(int n2, double d2) {
        return Chart.a(2, n2, d2);
    }

    public static final int StartOfDayFilter(int n2) {
        return Chart.StartOfDayFilter(n2, 0.05);
    }

    public static final int StartOfDayFilter() {
        return Chart.StartOfDayFilter(1, 0.05);
    }

    public static final int StartOfWeekFilter(int n2, double d2) {
        return Chart.a(3, n2, d2);
    }

    public static final int StartOfWeekFilter(int n2) {
        return Chart.StartOfWeekFilter(n2, 0.05);
    }

    public static final int StartOfWeekFilter() {
        return Chart.StartOfWeekFilter(1, 0.05);
    }

    public static final int StartOfMonthFilter(int n2, double d2) {
        return Chart.a(4, n2, d2);
    }

    public static final int StartOfMonthFilter(int n2) {
        return Chart.StartOfMonthFilter(n2, 0.05);
    }

    public static final int StartOfMonthFilter() {
        return Chart.StartOfMonthFilter(1, 0.05);
    }

    public static final int StartOfYearFilter(int n2, double d2) {
        return Chart.a(5, n2, d2);
    }

    public static final int StartOfYearFilter(int n2) {
        return Chart.StartOfYearFilter(n2, 0.05);
    }

    public static final int StartOfYearFilter() {
        return Chart.StartOfYearFilter(1, 0.05);
    }

    public static final int RegularSpacingFilter(int n2, int n3) {
        return Chart.a(6, n2, (double)n3 / 4095.0);
    }

    public static final int RegularSpacingFilter(int n2) {
        return Chart.RegularSpacingFilter(n2, 0);
    }

    public static final int RegularSpacingFilter() {
        return Chart.RegularSpacingFilter(1, 0);
    }

    public static final int AllPassFilter() {
        return Chart.a(7, 0, 0.0);
    }

    public static final int NonePassFilter() {
        return Chart.a(8, 0, 0.0);
    }

    public static final int SelectItemFilter(int n2) {
        return Chart.a(9, n2, 0.0);
    }

    static double[] a(int n2, double[] dArray) {
        int n3 = n2 >> 28 & 0xF;
        double d2 = (double)(n2 >> 16 & 0xFFF) / 4095.0;
        int n4 = n2 & 0xFFFF;
        switch (n3) {
            case 1: {
                double[] dArray2 = new ArrayMath(dArray).selectStartOfHour(1, (int)Math.round(d2 * 3600.0)).replace(-1.7E308, 1.7E308).result();
                if (n4 > 1) {
                    int n5 = 0;
                    while (n5 < dArray2.length) {
                        if (dArray2[n5] != 1.7E308 && new w((long)dArray2[n5]).e() % n4 != 0) {
                            dArray2[n5] = 1.7E308;
                        }
                        ++n5;
                    }
                }
                return dArray2;
            }
            case 2: {
                return new ArrayMath(dArray).selectStartOfDay(n4, (int)Math.round(d2 * 86400.0)).replace(-1.7E308, 1.7E308).result();
            }
            case 3: {
                return new ArrayMath(dArray).selectStartOfWeek(n4, (int)Math.round(d2 * 7.0 * 86400.0)).replace(-1.7E308, 1.7E308).result();
            }
            case 4: {
                double[] dArray3 = new ArrayMath(dArray).selectStartOfMonth(1, (int)Math.round(d2 * 31.0 * 86400.0)).replace(-1.7E308, 1.7E308).result();
                if (n4 > 1) {
                    int n6 = 0;
                    while (n6 < dArray3.length) {
                        if (dArray3[n6] != 1.7E308 && (new w((long)dArray3[n6]).b() - 1) % n4 != 0) {
                            dArray3[n6] = 1.7E308;
                        }
                        ++n6;
                    }
                }
                return dArray3;
            }
            case 5: {
                return new ArrayMath(dArray).selectStartOfYear(n4, (int)Math.round(d2 * 366.0 * 86400.0)).replace(-1.7E308, 1.7E308).result();
            }
            case 6: {
                double[] dArray4 = new double[dArray.length];
                Arrays.fill(dArray4, 1.7E308);
                int n7 = (int)Math.round(d2 * 4095.0);
                while (n7 < dArray.length) {
                    dArray4[n7] = dArray[n7];
                    n7 += n4;
                }
                return dArray4;
            }
            case 7: {
                return dArray;
            }
            case 8: {
                double[] dArray5 = new double[dArray.length];
                Arrays.fill(dArray5, 1.7E308);
                return dArray5;
            }
            case 9: {
                double[] dArray6 = new double[dArray.length];
                Arrays.fill(dArray6, 1.7E308);
                if (ef.b(0, n4, dArray6.length - 1)) {
                    dArray6[n4] = dArray[n4];
                }
                return dArray6;
            }
        }
        return null;
    }

    private static int a(double d2) {
        return (int)ef.b(0.0, ef.e(d2 * 100.0), 1023.0) << 6;
    }

    public static int ClearTypeMono(double d2) {
        return Chart.a(d2) | 4;
    }

    public static int ClearTypeMono() {
        return Chart.ClearTypeMono(0.0);
    }

    public static int ClearTypeColor(double d2) {
        return Chart.a(d2) | 5;
    }

    public static int ClearTypeColor() {
        return Chart.ClearTypeColor(0.0);
    }

    static final int b(int n2) {
        int n3 = n2 & 0x3F;
        return n3 == 3 ? 4 : n3;
    }

    static final int c(int n2) {
        int n3 = n2 >> 6 & 0x3FF;
        if (n3 == 0) {
            n3 = n;
        }
        if (n3 == 0) {
            n3 = n = TTFText.detectClearTypeGamma();
        }
        return n3;
    }

    public static int PolynomialRegression(int n2) {
        return n2;
    }

    public static int getVersion() {
        return 0x5010001;
    }

    public static String getDescription() {
        return "ChartDirector";
    }

    public static String getCopyright() {
        return "Copyright (c) 2012 Advanced Software Engineering Limited";
    }

    public static String testFont(String string, int n2, double d2, double d3, double d4) {
        return TTFText.test(string, n2, d2, d3, d4);
    }

    public static String testFont(String string, int n2, double d2, double d3) {
        return Chart.testFont(string, n2, d2, d3, 0.0);
    }

    public static String testFont(String string, int n2, double d2) {
        return Chart.testFont(string, n2, d2, 8.0, 0.0);
    }

    public static String testFont(String string, int n2) {
        return Chart.testFont(string, n2, 8.0, 8.0, 0.0);
    }

    public static String testFont(String string) {
        return Chart.testFont(string, 0, 8.0, 8.0, 0.0);
    }

    public static String testFont() {
        return Chart.testFont(null, 0, 8.0, 8.0, 0.0);
    }

    public static String libgTTFTest(String string, int n2, double d2, double d3, double d4) {
        return Chart.testFont(string, n2, d2, d3, d4);
    }

    public static String libgTTFTest(String string, int n2, double d2, double d3) {
        return Chart.testFont(string, n2, d2, d3);
    }

    public static String libgTTFTest(String string, int n2, double d2) {
        return Chart.testFont(string, n2, d2);
    }

    public static String libgTTFTest(String string, int n2) {
        return Chart.testFont(string, n2);
    }

    public static String libgTTFTest(String string) {
        return Chart.testFont(string);
    }

    public static String libgTTFTest() {
        return Chart.testFont();
    }

    public static String setLicenseCode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        DrawArea.a(string, stringBuffer);
        return stringBuffer.toString();
    }

    public static boolean isLicensed() {
        return DrawArea.a();
    }

    public static String getBootLog() {
        return DrawArea.b();
    }

    public static double chartTime(int n2, int n3, int n4, int n5, int n6, int n7) {
        return new w(n2, n3, n4, n5, n6, n7).h();
    }

    public static double chartTime(int n2, int n3, int n4) {
        return Chart.chartTime(n2, n3, n4, 0, 0, 0);
    }

    public static double chartTime2(int n2) {
        return Chart.CTime(new Date((long)n2 * 1000L));
    }

    public static int getChartYMD(double d2) {
        w w2 = new w((long)d2);
        return w2.a() * 10000 + w2.b() * 100 + w2.c();
    }

    public static int getChartWeekDay(double d2) {
        return (int)(((long)d2 / 86400L + 1L) % 7L);
    }

    public static double CTime(Date date) {
        if (date == null) {
            return 1.7E308;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return Chart.CTime(gregorianCalendar);
    }

    public static double[] CTime(Date[] dateArray) {
        if (dateArray == null) {
            return null;
        }
        double[] dArray = new double[dateArray.length];
        int n2 = 0;
        while (n2 < dateArray.length) {
            dArray[n2] = Chart.CTime(dateArray[n2]);
            ++n2;
        }
        return dArray;
    }

    public static double CTime(Calendar calendar) {
        if (calendar == null) {
            return 1.7E308;
        }
        return Chart.chartTime(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13)) + (double)calendar.get(14) / 1000.0;
    }

    public static double[] CTime(Calendar[] calendarArray) {
        if (calendarArray == null) {
            return null;
        }
        double[] dArray = new double[calendarArray.length];
        int n2 = 0;
        while (n2 < calendarArray.length) {
            dArray[n2] = Chart.CTime(calendarArray[n2]);
            ++n2;
        }
        return dArray;
    }

    public static double[] CTime2(Date[] dateArray) {
        return Chart.CTime(dateArray);
    }

    public static double[] CTime2(Calendar[] calendarArray) {
        return Chart.CTime(calendarArray);
    }

    private static int m(int n2) {
        return --n2 * 365 + n2 / 4 - n2 / 100 + n2 / 400;
    }

    private static boolean a(long l2) {
        return l2 % 400L == 0L || l2 % 4L == 0L && l2 % 100L != 0L;
    }

    private static int a(int n2, int n3) {
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        int[] nArray2 = nArray;
        int n4 = nArray2[n3 - 1];
        if (n3 > 2 && Chart.a((long)n2)) {
            ++n4;
        }
        return n4;
    }

    public static Date NTime(double d2) {
        long l2 = (long)d2;
        int n2 = (int)(l2 % 60L);
        int n3 = (int)((l2 /= 60L) % 60L);
        int n4 = (int)((l2 /= 60L) % 24L);
        int n5 = (int)((double)(l2 /= 24L) / 365.2425) + 1;
        l2 -= (long)Chart.m(n5);
        if (Chart.a((long)n5)) {
            if (l2 >= 366L) {
                ++n5;
                l2 -= 366L;
            }
        } else if (l2 >= 365L) {
            ++n5;
            l2 -= 365L;
        }
        int n6 = 1;
        while (n6 < 12) {
            if (l2 < (long)Chart.a(n5, n6 + 1)) break;
            ++n6;
        }
        int n7 = (int)(l2 - (long)Chart.a(n5, n6)) + 1;
        return new GregorianCalendar(n5, n6 - 1, n7, n4, n3, n2).getTime();
    }

    public static Date[] NTime(double[] dArray) {
        Date[] dateArray = new Date[dArray.length];
        int n2 = 0;
        while (n2 < dArray.length) {
            dateArray[n2] = Chart.NTime(dArray[n2]);
            ++n2;
        }
        return dateArray;
    }

    public static Date[] NTime2(double[] dArray) {
        return Chart.NTime(dArray);
    }

    public static int CColor(Color color) {
        if (color == null || color.getAlpha() == 0) {
            return -16777216;
        }
        return 255 - color.getAlpha() << 24 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
    }

    public static int[] CColor(Color[] colorArray) {
        if (colorArray == null) {
            return null;
        }
        int[] nArray = new int[colorArray.length];
        int n2 = 0;
        while (n2 < colorArray.length) {
            nArray[n2] = Chart.CColor(colorArray[n2]);
            ++n2;
        }
        return nArray;
    }

    public static int[] CColor2(Color[] colorArray) {
        return Chart.CColor(colorArray);
    }

    public static Color NColor(int n2) {
        return new Color(n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF, 255 - (n2 >> 24 & 0xFF));
    }

    public static Color[] NColor(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        Color[] colorArray = new Color[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            colorArray[n2] = Chart.NColor(nArray[n2]);
            ++n2;
        }
        return colorArray;
    }

    public static Color[] NColor2(int[] nArray) {
        return Chart.NColor(nArray);
    }

    public static int metalColor(int n2, int n3) {
        n3 = (ef.a(n3, 180) + 22) / 45;
        switch (n2 & 0xFFFF0000) {
            case -131072: {
                return 0xFF800000 | n3 << 16 | 0xF000 | n2 & 0x7FF;
            }
            case -65536: {
                if ((n2 &= 0xFFFF) == 65535) {
                    return -16777216;
                }
                if ((n2 & 0x8000) == 0) {
                    return 0xFF800000 | n3 << 16 | 0xF800 | n2 & 0x7FF;
                }
                n2 &= 0xFFFF;
            }
        }
        int n4 = ((n2 >> 24 & 0xFF) + 8) / 17;
        if (n4 == 15) {
            return -16777216;
        }
        int n5 = ((n2 >> 16 & 0xFF) + 8) / 17;
        int n6 = ((n2 >> 8 & 0xFF) + 8) / 17;
        int n7 = ((n2 & 0xFF) + 8) / 17;
        return 0xFF800000 | n3 << 16 | n4 << 12 | n5 << 8 | n6 << 4 | n7;
    }

    public static int metalColor(Color color, int n2) {
        return Chart.metalColor(Chart.CColor(color), n2);
    }

    public static int metalColor(int n2) {
        return Chart.metalColor(n2, 90);
    }

    public static int metalColor(Color color) {
        return Chart.metalColor(color, 90);
    }

    public static int goldColor(int n2) {
        return Chart.metalColor(0xFFEE44, n2);
    }

    public static int goldColor() {
        return Chart.goldColor(90);
    }

    public static int silverColor(int n2) {
        return Chart.metalColor(0xDDDDDD, n2);
    }

    public static int silverColor() {
        return Chart.silverColor(90);
    }

    public static int brushedMetalColor(int n2, int n3, int n4) {
        return Chart.metalColor(n2, n4) | (n3 & 3) << 18;
    }

    public static int brushedMetalColor(Color color, int n2, int n3) {
        return Chart.brushedMetalColor(Chart.CColor(color), n2, n3);
    }

    public static int brushedMetalColor(int n2, int n3) {
        return Chart.brushedMetalColor(n2, n3, 90);
    }

    public static int brushedMetalColor(Color color, int n2) {
        return Chart.brushedMetalColor(Chart.CColor(color), n2);
    }

    public static int brushedMetalColor(int n2) {
        return Chart.brushedMetalColor(n2, 2, 90);
    }

    public static int brushedMetalColor(Color color) {
        return Chart.brushedMetalColor(Chart.CColor(color));
    }

    public static int brushedGoldColor(int n2, int n3) {
        return Chart.brushedMetalColor(0xFFEE44, n2, n3);
    }

    public static int brushedGoldColor(int n2) {
        return Chart.brushedGoldColor(n2, 90);
    }

    public static int brushedGoldColor() {
        return Chart.brushedGoldColor(2, 90);
    }

    public static int brushedSilverColor(int n2, int n3) {
        return Chart.brushedMetalColor(0xDDDDDD, n2, n3);
    }

    public static int brushedSilverColor(int n2) {
        return Chart.brushedSilverColor(n2, 90);
    }

    public static int brushedSilverColor() {
        return Chart.brushedSilverColor(2, 90);
    }

    static int a(DrawArea drawArea, int n2) {
        int n3 = n2 >> 18 & 3;
        switch (n3) {
            case 1: {
                n3 = 24;
                break;
            }
            case 2: {
                n3 = 36;
                break;
            }
            case 3: {
                n3 = 48;
            }
        }
        return drawArea.d(drawArea.a(o, null, Chart.b(drawArea, n2 & 0xFFFF), (double)(45 * (n2 >> 16 & 3)), 1.0, 0.0), n3);
    }

    private static int b(DrawArea drawArea, int n2) {
        int n3 = (n2 & 0xF000) >> 12;
        if (n3 == 15) {
            if ((n2 & 0x800) != 0) {
                return drawArea.getARGBColor(0xFFFF0000 | n2 & 0x7FF);
            }
            return 0xFFFE0000 | n2 & 0x7FF;
        }
        int n4 = (n2 & 0xF00) >> 8;
        int n5 = (n2 & 0xF0) >> 4;
        int n6 = n2 & 0xF;
        n3 = n3 << 4 | n3;
        n4 = n4 << 4 | n4;
        n5 = n5 << 4 | n5;
        n6 = n6 << 4 | n6;
        return n3 << 24 | n4 << 16 | n5 << 8 | n6;
    }

    public static int glassEffect(int n2, int n3, int n4) {
        int n5 = 0;
        if (n3 == 4) {
            n5 = 1;
        } else if (n3 == 2) {
            n5 = 2;
        } else if (n3 == 6) {
            n5 = 3;
        }
        n4 = n4 <= 0 ? ef.a(0, -n4, 50) : ef.a(50, 50 + n4, 4095);
        return ef.a(0, n2, 3) + (n5 << 2) << 16 | 0x2000 | 0x1000 | 0x100000 | 0x800000 | n4;
    }

    public static int glassEffect(int n2, int n3) {
        return Chart.glassEffect(n2, n3, 5);
    }

    public static int glassEffect(int n2) {
        return Chart.glassEffect(n2, 8, 5);
    }

    public static int glassEffect() {
        return Chart.glassEffect(3, 8, 5);
    }

    public static int softLighting(int n2, int n3) {
        n2 = n2 == 4 ? 6 : (n2 == 2 ? 8 : (n2 == 6 ? 4 : 2));
        return Chart.glassEffect(1, n2, n3);
    }

    public static int softLighting(int n2) {
        return Chart.softLighting(n2, 4);
    }

    public static int softLighting() {
        return Chart.softLighting(8, 4);
    }

    private static int b(double d2) {
        if (d2 <= 1.0) {
            return (int)Math.round(Math.max(0.0, d2) * 100.0);
        }
        return 100 + (int)Math.round(128.0 - 128.0 / d2);
    }

    private static double n(int n2) {
        if (n2 <= 100) {
            return (double)n2 / 100.0;
        }
        return 128.0 / Math.max(0.1, (double)(228 - n2));
    }

    public static int barLighting(double d2, double d3) {
        return 0x10000000 | Chart.b(d3) << 8 | Chart.b(d2);
    }

    public static int barLighting() {
        return Chart.barLighting(0.75, 1.5);
    }

    static boolean d(int n2) {
        return (n2 & 0xF0000000) == 0x10000000;
    }

    static int[] a(int n2, double d2) {
        d2 *= 1024.0;
        double d3 = Chart.n(n2 & 0xFF);
        double d4 = Chart.n(n2 >> 8 & 0xFF);
        if (d2 < 0.0) {
            d2 = -d2;
            d3 = (d3 * 2.0 + d4) / 3.0;
            d4 = (d3 + d4) / 2.0;
        }
        int[] nArray = new int[4];
        nArray[1] = (int)Math.round(d4 * d2);
        nArray[2] = 256;
        nArray[3] = (int)Math.round(d3 * d2);
        return nArray;
    }

    public static int cylinderEffect(int n2, double d2, double d3, double d4, int n3) {
        int n4;
        switch (n2) {
            case 4: 
            case 6: {
                n4 = 0x20000000;
                break;
            }
            case 2: 
            case 8: {
                n4 = 0x40000000;
                break;
            }
            default: {
                n4 = 0x60000000;
            }
        }
        return n4 | Chart.b(d2) | Chart.b(d3) << 8 | Chart.b(d4) << 16 | ef.a(0, n3 - 1, 31) << 24;
    }

    public static int cylinderEffect(int n2) {
        return Chart.cylinderEffect(n2, 0.5, 0.5, 0.75, 8);
    }

    public static int cylinderEffect() {
        return Chart.cylinderEffect(5, 0.5, 0.5, 0.75, 8);
    }

    static boolean e(int n2) {
        return n2 > 0 && (n2 & 0xE0000000) != 0;
    }

    static int f(int n2) {
        switch (n2 & 0xE0000000) {
            case 0x20000000: {
                return 4;
            }
            case 0x40000000: {
                return 8;
            }
        }
        return 5;
    }

    static int[] a(int n2, int n3, int n4) {
        int n5 = n3 * n3 + n4 * n4;
        if (n5 == 0) {
            return null;
        }
        double d2 = Math.sqrt(n5);
        int n6 = Math.max(16, 2 * (int)Math.ceil(d2));
        int n7 = n6 / 128 + 1;
        double d3 = (double)n4 / d2;
        double d4 = (double)n3 / d2;
        double d5 = 2.0 / (double)(n6 /= n7);
        double d6 = Chart.n(n2 & 0xFF);
        double d7 = Chart.n(n2 >> 8 & 0xFF);
        double d8 = Chart.n(n2 >> 16 & 0xFF);
        int n8 = (n2 >> 24 & 0x1F) + 1;
        int[] nArray = new int[(n6 + 1) * 2];
        int n9 = 0;
        while (n9 <= n6) {
            double d9 = 1.0 - d5 * (double)n9;
            double d10 = d3 * d9 + d4 * ef.a(1.0 - d9 * d9);
            double d11 = d6;
            if (d10 > 0.0) {
                d11 += d7 * d10;
                if (d10 > 0.707) {
                    d11 += d8 * Math.pow(2.0 * d10 * d10 - 1.0, n8);
                }
            }
            nArray[n9 * 2] = n9 * 256 / n6;
            nArray[n9 * 2 + 1] = (int)Math.round(1024.0 * d11);
            ++n9;
        }
        return nArray;
    }

    public static int phongLighting(double d2, double d3, double d4, int n2) {
        return Chart.cylinderEffect(5, d2, d3, d4, n2);
    }

    public static int phongLighting() {
        return Chart.phongLighting(0.5, 0.5, 0.75, 8);
    }

    static double[] g(int n2) {
        double[] dArray = new double[]{Chart.n(n2 & 0xFF), Chart.n(n2 >> 8 & 0xFF), Chart.n(n2 >> 16 & 0xFF), (n2 >> 24 & 0x1F) + 1};
        return dArray;
    }

    public static synchronized int getUniqueId() {
        return ++p;
    }

    public static double bSearch(Date[] dateArray, Date date) {
        if (dateArray == null || dateArray.length == 0) {
            return -1.0;
        }
        int n2 = Arrays.binarySearch(dateArray, date);
        if (n2 >= 0) {
            return n2;
        }
        if ((n2 ^= 0xFFFFFFFF) >= dateArray.length) {
            return dateArray.length - 1;
        }
        if (n2 == 0) {
            return n2;
        }
        return (double)n2 - (double)(dateArray[n2].getTime() - date.getTime()) / (double)(dateArray[n2].getTime() - dateArray[n2 - 1].getTime());
    }

    public static double bSearch(double[] dArray, double d2) {
        if (dArray == null || dArray.length == 0) {
            return -1.0;
        }
        int n2 = Arrays.binarySearch(dArray, d2);
        if (n2 >= 0) {
            return n2;
        }
        if ((n2 ^= 0xFFFFFFFF) >= dArray.length) {
            return dArray.length - 1;
        }
        if (n2 == 0) {
            return n2;
        }
        return (double)n2 - (dArray[n2] - d2) / (dArray[n2] - dArray[n2 - 1]);
    }

    public static double bSearch(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return -1.0;
        }
        int n2 = Arrays.binarySearch(stringArray, string);
        if (n2 >= 0) {
            return n2;
        }
        if ((n2 ^= 0xFFFFFFFF) >= stringArray.length) {
            return stringArray.length - 1;
        }
        if (n2 == 0) {
            return n2;
        }
        return (double)n2 - 0.5;
    }

    public static Object arraySlice(Object object, int n2, int n3) {
        n2 = Math.max(0, n2);
        n3 = Math.max(0, Math.min(n3, Array.getLength(object) - n2));
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n3);
        if (n3 > 0) {
            System.arraycopy(object, n2, object2, 0, n3);
        }
        return object2;
    }

    public static String stringJoin(Iterator iterator, String string) {
        if (iterator == null || !iterator.hasNext()) {
            return "";
        }
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            stringBuffer.append(iterator.next().toString());
            if (!iterator.hasNext()) break;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String stringJoin(Collection collection, String string) {
        return collection == null ? "" : Chart.stringJoin(collection.iterator(), string);
    }

    public static String stringJoin(String[] stringArray, String string) {
        return stringArray == null ? "" : Chart.stringJoin(Arrays.asList(stringArray), string);
    }
}

