/*
 * Decompiled with CFR 0.152.
 */
package ChartDirector;

import ChartDirector.BaseMeter;
import ChartDirector.DrawArea;
import ChartDirector.MeterPointer;
import ChartDirector.TextBox;
import ChartDirector.at;
import ChartDirector.dw;
import ChartDirector.ec;
import ChartDirector.ef;
import ChartDirector.gq;
import ChartDirector.l;

public class AngularMeter
extends BaseMeter {
    private int x;
    private int y;
    private int z;
    private double A = -90.0;
    private double B = 90.0;
    private int C = 3;
    private int D = 0xDDDDDD;
    private int E = 0;

    public AngularMeter(int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5, n6);
        TextBox textBox = this.setLabelStyle("bold", 10.0);
        textBox.setMargin(0);
        textBox.setAlignment(5);
    }

    public AngularMeter(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, 0);
    }

    public AngularMeter(int n2, int n3, int n4) {
        this(n2, n3, n4, -16777216, 0);
    }

    public AngularMeter(int n2, int n3) {
        this(n2, n3, -65536, -16777216, 0);
    }

    boolean a() {
        return Math.abs(Math.abs(this.B - this.A) - 360.0) < 0.1;
    }

    public void addRing(int n2, int n3, int n4, int n5) {
        n5 = n5 == -1 ? n4 : n5;
        this.a(new ec(this, n2, n3, n4, n5)).setZOrder(4095);
    }

    public void addRing(int n2, int n3, int n4) {
        this.addRing(n2, n3, n4, -1);
    }

    public void addRingSector(int n2, int n3, double d2, double d3, int n4, int n5) {
        n5 = n5 == -1 ? n4 : n5;
        this.a(new l(this, n2, n3, d2, d3, n4, n5)).setZOrder(4095);
    }

    public void addRingSector(int n2, int n3, double d2, double d3, int n4) {
        this.addRingSector(n2, n3, d2, d3, n4, -1);
    }

    public void setCap(int n2, int n3, int n4) {
        this.C = n2;
        this.D = n3;
        this.E = n4;
    }

    public void setCap(int n2, int n3) {
        this.setCap(n2, n3, -65535);
    }

    public void setMeter(int n2, int n3, int n4, double d2, double d3) {
        this.x = n2;
        this.y = n3;
        this.z = n4;
        this.A = d2;
        this.B = d3;
    }

    public void addZone(double d2, double d3, int n2, int n3, int n4, int n5) {
        n5 = n5 == -1 ? n4 : n5;
        this.a(new at(this, d2, d3, n2, n3, n4, n5)).setZOrder(4095);
    }

    public void addZone(double d2, double d3, int n2, int n3, int n4) {
        this.addZone(d2, d3, n2, n3, n4, -1);
    }

    public void addZone(double d2, double d3, int n2, int n3) {
        this.addZone(d2, d3, this.z, this.z + this.i, n2, n3);
    }

    public void addZone(double d2, double d3, int n2) {
        this.addZone(d2, d3, this.z, this.z + this.i, n2, -1);
    }

    public void addZone2(double d2, double d3, int n2, int n3) {
        this.addZone(d2, d3, this.z, this.z + this.i, n2, n3);
    }

    public void addZone2(double d2, double d3, int n2) {
        this.addZone(d2, d3, this.z, this.z + this.i, n2, -1);
    }

    MeterPointer a(double d2, int n2, int n3) {
        return new gq(this, d2, n2, n3);
    }

    double a(double d2) {
        double d3 = (d2 - this.c) / (this.d - this.c);
        return this.A + d3 * (this.B - this.A);
    }

    void a(DrawArea drawArea, int n2, int n3) {
        if (n2 == -16777216 || n3 <= 0) {
            return;
        }
        if (Math.abs(this.B - this.A) > 359.9) {
            if (n3 == 1) {
                drawArea.circle(this.x, this.y, this.z, this.z, n2, -16777216);
            } else {
                drawArea.a(this.x, this.y, this.z, this.z, this.z - n3 + 1, this.z - n3 + 1, n2, n2);
            }
        } else {
            double d2 = Math.min(this.A, this.B);
            double d3 = Math.max(this.A, this.B);
            if (n3 == 1) {
                drawArea.arc(this.x, this.y, this.z, this.z, d2, d3, n2);
            } else {
                drawArea.a(this.x, this.y, this.z, this.z, this.z - n3 + 1, this.z - n3 + 1, d2, d3, n2, n2);
            }
        }
    }

    void a(DrawArea drawArea, double d2, int n2, int n3, int n4) {
        if (n2 == 0 || n3 <= 0 || n4 == -16777216) {
            return;
        }
        double d3 = this.a(d2);
        double d4 = Math.toRadians(d3);
        double d5 = Math.sin(d4);
        double d6 = Math.cos(d4);
        double d7 = (double)this.x + (double)this.z * d5;
        double d8 = (double)this.y - (double)this.z * d6;
        if (n3 == 1) {
            double d9 = (double)this.x + (double)(this.z + n2) * d5;
            double d10 = (double)this.y - (double)(this.z + n2) * d6;
            drawArea.line(d7, d8, d9, d10, n4, n3);
        } else {
            int[] nArray = new int[8];
            nArray[0] = -(--n3);
            nArray[2] = n3;
            nArray[4] = n3;
            nArray[5] = n2 * 2;
            nArray[6] = -n3;
            nArray[7] = n2 * 2;
            int[] nArray2 = nArray;
            drawArea.a(nArray2, d7, d8, d3, 0.5, 0.5, n4, n4);
        }
    }

    void a(DrawArea drawArea, dw dw2, double d2) {
        int n2 = this.z;
        n2 = this.g ? (this.i < 0 ? (n2 += this.i - this.f) : (n2 -= this.f)) : (this.i > 0 ? (n2 += this.i + this.f) : (n2 += this.f));
        double d3 = ef.c(this.a(d2), 360.0);
        double d4 = Math.max(this.h.q, this.h.r);
        n2 = (int)((double)n2 + (this.g ? -d4 : d4));
        d3 = Math.toRadians(d3);
        int n3 = (int)Math.round((double)this.x + (double)n2 * Math.sin(d3));
        int n4 = (int)Math.round((double)this.y - (double)n2 * Math.cos(d3));
        dw2.setPos(n3 + dw2.g, n4 + dw2.h);
        dw2.a(drawArea);
    }

    void b() {
        if (this.C >= 0 && this.D != -16777216 && this.E != -16777216) {
            this.a(new ec(this, 0, this.C, this.D, this.E));
        }
        super.b();
    }

    static int a(AngularMeter angularMeter) {
        return angularMeter.x;
    }

    static int b(AngularMeter angularMeter) {
        return angularMeter.y;
    }

    static int c(AngularMeter angularMeter) {
        return angularMeter.z;
    }
}

